/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.collect.server.rest;

import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitamui.collect.server.service.SearchCriteriaHistoryService;
import fr.gouv.vitamui.common.security.SanityChecker;
import fr.gouv.vitamui.commons.api.ParameterChecker;
import fr.gouv.vitamui.commons.api.domain.IdDto;
import fr.gouv.vitamui.commons.api.dtos.SearchCriteriaHistoryDto;
import fr.gouv.vitamui.commons.api.exception.PreconditionFailedException;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.annotation.Secured;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Tag(name="searchCriteriaHistory")
@RequestMapping(value={"/archive-units/searchcriteriahistory"})
public class SearchCriteriaHistoryController {
    private static final Logger LOGGER = LoggerFactory.getLogger(SearchCriteriaHistoryController.class);
    private final SearchCriteriaHistoryService searchCriteriaHistoryService;

    @GetMapping
    @Secured(value={"ROLE_COLLECT_GET_ARCHIVE_SEARCH"})
    public List<SearchCriteriaHistoryDto> getSearchCriteriaHistory() {
        LOGGER.debug("getSearchCriteriaHistory archive external");
        return this.searchCriteriaHistoryService.getSearchCriteriaHistoryDtos();
    }

    @PostMapping
    @Secured(value={"ROLE_COLLECT_GET_ARCHIVE_SEARCH"})
    public SearchCriteriaHistoryDto create(@Valid @RequestBody SearchCriteriaHistoryDto dto) throws PreconditionFailedException {
        ParameterChecker.checkParameter((String)"the Search Criteria is mandatory : ", (Object[])new Object[]{dto});
        SanityChecker.sanitizeCriteria((Object)dto);
        LOGGER.debug("Create SearchCriteriaHistory {}", (Object)dto);
        return (SearchCriteriaHistoryDto)this.searchCriteriaHistoryService.create((IdDto)dto);
    }

    @DeleteMapping(value={"/{id}"})
    @Secured(value={"ROLE_COLLECT_GET_ARCHIVE_SEARCH"})
    public void delete(@PathVariable(value="id") String id) throws PreconditionFailedException {
        ParameterChecker.checkParameter((String)"Identifier is mandatory : ", (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        LOGGER.debug("Delete SearchCriteriaHistory with id :{}", (Object)id);
        this.searchCriteriaHistoryService.delete(id);
    }

    @Operation(summary="Update Search criteria history")
    @Secured(value={"ROLE_COLLECT_GET_ARCHIVE_SEARCH"})
    @PutMapping(value={"/{id}"})
    public void update(@RequestBody SearchCriteriaHistoryDto entity) throws PreconditionFailedException, InvalidParseOperationException {
        ParameterChecker.checkParameter((String)"Search criteria is mandatory : ", (Object[])new Object[]{entity});
        SanityChecker.sanitizeCriteria((Object)entity);
        ParameterChecker.checkParameter((String)"Identifier is mandatory : ", (String[])new String[]{entity.getId()});
        LOGGER.debug("Update SearchCriteriaHistory with id :{}", (Object)entity.getId());
        this.searchCriteriaHistoryService.update((IdDto)entity);
    }

    @Generated
    public SearchCriteriaHistoryController(SearchCriteriaHistoryService searchCriteriaHistoryService) {
        this.searchCriteriaHistoryService = searchCriteriaHistoryService;
    }
}

