/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.collect.server.rest;

import fr.gouv.vitamui.collect.server.service.ExternalParametersService;
import fr.gouv.vitamui.commons.vitam.api.administration.ConfigurationService;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.annotation.Secured;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/collect-api/v1/configurations"})
@Tag(name="Configurations", description="System Configurations")
public class ConfigurationsController {
    static final Logger LOGGER = LoggerFactory.getLogger(ConfigurationsController.class);
    private final ConfigurationService configurationService;
    private final ExternalParametersService externalParametersService;

    public ConfigurationsController(ConfigurationService configurationService, ExternalParametersService externalParametersService) {
        this.configurationService = configurationService;
        this.externalParametersService = externalParametersService;
    }

    @GetMapping(value={"/virtual-paths-fields"})
    @Secured(value={"ROLE_COLLECT_GET_ARCHIVE_SEARCH"})
    public List<String> getVirtualPathsFields() {
        LOGGER.debug("Retrieve Vitam virtual paths fields list  ");
        return this.configurationService.getVirtualPathPathAvailableTenantsIds(this.externalParametersService.buildVitamContextFromExternalParam());
    }
}

