/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.collect.server.rest;

import fr.gouv.vitamui.collect.common.dto.OperationIdDto;
import fr.gouv.vitamui.collect.common.dto.UpdateArchiveUnitDto;
import fr.gouv.vitamui.collect.common.service.ArchiveUnitService;
import fr.gouv.vitamui.commons.api.dtos.JsonPatch;
import fr.gouv.vitamui.commons.api.dtos.JsonPatchDto;
import fr.gouv.vitamui.commons.api.dtos.MultiJsonPatchDto;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.Produces;
import java.util.Set;
import lombok.Generated;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.annotation.Secured;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Tag(name="Collect")
@RequestMapping(value={"/collect-api/archive-units/{transactionId}"})
public class CollectArchiveUnitController {
    private final ArchiveUnitService archiveUnitService;

    @PatchMapping
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Secured(value={"ROLE_COLLECT_UPDATE_BULK_ARCHIVE_UNIT"})
    @Operation(summary="Updates several archive units asynchronously by passing partial changes to apply to an archive unit")
    public ResponseEntity<OperationIdDto> updateArchiveUnitsByTransaction(@PathVariable String transactionId, @RequestBody @Validated Set<UpdateArchiveUnitDto> updateArchiveUnitDtoSet) {
        return ResponseEntity.ok((Object)this.archiveUnitService.update(transactionId, updateArchiveUnitDtoSet));
    }

    @PatchMapping(value={"/{archiveUnitId}"})
    @Consumes(value={"application/json-patch+json"})
    @Produces(value={"application/json"})
    @Secured(value={"ROLE_COLLECT_UPDATE_UNITARY_ARCHIVE_UNIT"})
    @Operation(summary="Updates one archive unit asynchronously by passing a list of operation to do on an archive unit")
    public ResponseEntity<OperationIdDto> updateArchiveUnitByTransaction(@PathVariable String transactionId, @RequestBody @Validated JsonPatch jsonPatch, @PathVariable String archiveUnitId) {
        JsonPatchDto jsonPatchDto = new JsonPatchDto().setId(archiveUnitId).setJsonPatch(jsonPatch);
        return this.updateArchiveUnitByTransaction(transactionId, jsonPatchDto);
    }

    @PatchMapping(value={"/update/single"})
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Secured(value={"ROLE_COLLECT_UPDATE_UNITARY_ARCHIVE_UNIT"})
    @Operation(summary="Updates one archive unit asynchronously by passing a list of operation to do on this one")
    public ResponseEntity<OperationIdDto> updateArchiveUnitByTransaction(@PathVariable String transactionId, @RequestBody @Validated JsonPatchDto jsonPatchDto) {
        return ResponseEntity.ok((Object)this.archiveUnitService.update(transactionId, jsonPatchDto));
    }

    @PatchMapping(value={"/update/multiple"})
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Secured(value={"ROLE_COLLECT_UPDATE_BULK_ARCHIVE_UNIT"})
    @Operation(summary="Updates several archive units asynchronously by passing a list of operation to do on these ones")
    public ResponseEntity<OperationIdDto> updateArchiveUnitsByTransaction(@PathVariable String transactionId, @RequestBody @Validated MultiJsonPatchDto multiJsonPatchDto) {
        return ResponseEntity.ok((Object)this.archiveUnitService.update(transactionId, multiJsonPatchDto));
    }

    @Generated
    public CollectArchiveUnitController(ArchiveUnitService archiveUnitService) {
        this.archiveUnitService = archiveUnitService;
    }
}

