/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.collect.server.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import fr.gouv.vitam.access.external.client.AdminExternalClient;
import fr.gouv.vitamui.collect.server.config.ApiCollectApplicationProperties;
import fr.gouv.vitamui.collect.server.security.WebSecurityConfig;
import fr.gouv.vitamui.commons.api.application.AbstractContextConfiguration;
import fr.gouv.vitamui.commons.mongo.dao.CustomSequenceRepository;
import fr.gouv.vitamui.commons.mongo.service.SequenceGeneratorService;
import fr.gouv.vitamui.commons.rest.RestExceptionHandler;
import fr.gouv.vitamui.commons.vitam.api.administration.ConfigurationService;
import fr.gouv.vitamui.commons.vitam.api.config.VitamAccessConfig;
import fr.gouv.vitamui.commons.vitam.api.config.VitamAdministrationConfig;
import fr.gouv.vitamui.commons.vitam.api.config.VitamCollectConfig;
import fr.gouv.vitamui.iam.openapiclient.ExternalParametersApi;
import fr.gouv.vitamui.iam.openapiclient.IamApiClientsFactory;
import fr.gouv.vitamui.iam.openapiclient.UsersApi;
import fr.gouv.vitamui.iam.security.provider.ApiAuthenticationProvider;
import fr.gouv.vitamui.iam.security.provider.ExternalApiAuthenticationProvider;
import fr.gouv.vitamui.iam.security.provider.InternalApiAuthenticationProvider;
import fr.gouv.vitamui.iam.security.service.IamClientUserAuthenticationService;
import fr.gouv.vitamui.iam.security.service.SecurityService;
import fr.gouv.vitamui.iam.security.service.UserAuthenticationService;
import fr.gouv.vitamui.security.openapiclient.ContextsApi;
import fr.gouv.vitamui.security.openapiclient.SecurityApiClientsFactory;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@Import(value={RestExceptionHandler.class, WebSecurityConfig.class, VitamAccessConfig.class, VitamCollectConfig.class, VitamAdministrationConfig.class})
public class ApiCollectServerConfig
extends AbstractContextConfiguration {
    @Bean
    public SecurityApiClientsFactory securityApiClientsFactory(ApiCollectApplicationProperties apiCollectApplicationProperties, RestTemplateBuilder restTemplateBuilder) {
        return new SecurityApiClientsFactory(apiCollectApplicationProperties.getSecurityClient(), restTemplateBuilder);
    }

    @Bean
    public ContextsApi contextsApi(SecurityApiClientsFactory securityApiClientsFactory) {
        return securityApiClientsFactory.getContextsApi();
    }

    @Bean
    public UserAuthenticationService authentificationService(UsersApi usersApi) {
        return new IamClientUserAuthenticationService(usersApi);
    }

    @Bean
    public ApiAuthenticationProvider apiAuthenticationProvider(UserAuthenticationService userAuthenticationService, ContextsApi contextsApi) {
        return new ApiAuthenticationProvider(new InternalApiAuthenticationProvider(userAuthenticationService), new ExternalApiAuthenticationProvider(contextsApi, userAuthenticationService));
    }

    @Bean
    public SecurityService securityService() {
        return new SecurityService();
    }

    @Bean
    public IamApiClientsFactory iamApiClientsFactory(ApiCollectApplicationProperties apiCollectApplicationProperties, RestTemplateBuilder restTemplateBuilder) {
        return new IamApiClientsFactory(apiCollectApplicationProperties.getIamClient(), restTemplateBuilder);
    }

    @Bean
    public UsersApi usersApi(IamApiClientsFactory iamApiClientsFactory) {
        return iamApiClientsFactory.getUsersApi();
    }

    @Bean
    public SequenceGeneratorService sequenceGeneratorService(CustomSequenceRepository sequenceRepository) {
        return new SequenceGeneratorService(sequenceRepository);
    }

    @Bean
    public ExternalParametersApi externalParametersApi(IamApiClientsFactory iamApiClientsFactory) {
        return iamApiClientsFactory.getExternalParametersApi();
    }

    @Bean
    public ConfigurationService configurationService(AdminExternalClient adminExternalClient, ObjectMapper objectMapper) {
        return new ConfigurationService(adminExternalClient, objectMapper);
    }
}

