/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.ingest.server.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.external.client.IngestCollection;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.ingest.external.api.exception.IngestExternalException;
import fr.gouv.vitam.ingest.external.client.IngestExternalClient;
import fr.gouv.vitamui.commons.api.domain.AccessContractDto;
import fr.gouv.vitamui.commons.api.domain.DirectionDto;
import fr.gouv.vitamui.commons.api.domain.PaginatedValuesDto;
import fr.gouv.vitamui.commons.api.enums.AttachmentType;
import fr.gouv.vitamui.commons.api.exception.IngestFileGenerationException;
import fr.gouv.vitamui.commons.api.exception.InternalServerException;
import fr.gouv.vitamui.commons.vitam.api.access.LogbookService;
import fr.gouv.vitamui.commons.vitam.api.dto.LogbookOperationDto;
import fr.gouv.vitamui.commons.vitam.api.dto.LogbookOperationsCommonResponseDto;
import fr.gouv.vitamui.iam.openapiclient.CustomersApi;
import fr.gouv.vitamui.iam.openapiclient.UsersApi;
import fr.gouv.vitamui.iam.openapiclient.domain.AuthUserDto;
import fr.gouv.vitamui.iam.openapiclient.domain.CustomerDto;
import fr.gouv.vitamui.iam.security.service.SecurityService;
import fr.gouv.vitamui.ingest.common.dsl.VitamQueryHelper;
import fr.gouv.vitamui.ingest.common.dto.ArchiveUnitDto;
import fr.gouv.vitamui.ingest.server.service.IngestAccessContractService;
import fr.gouv.vitamui.ingest.server.service.IngestConverter;
import fr.gouv.vitamui.ingest.server.service.IngestExternalParametersService;
import fr.gouv.vitamui.ingest.server.service.IngestGeneratorODTFile;
import jakarta.ws.rs.core.Response;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.odftoolkit.simple.TextDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;
import org.springframework.http.ResponseEntity;
import org.w3c.dom.Document;

public class IngestService {
    private static final Logger LOGGER = LoggerFactory.getLogger(IngestService.class);
    private static final String ILLEGAL_CHARACTERS = "[\ufeff-\uffff]";
    private static final String SELECTED_ORIGINATING_AGENCIES = "SELECTED_ORIGINATING_AGENCIES";
    private final SecurityService securityService;
    private final IngestExternalClient ingestExternalClient;
    private final LogbookService logbookService;
    private final ObjectMapper objectMapper;
    private final CustomersApi customersApi;
    private final UsersApi usersApi;
    private final IngestGeneratorODTFile ingestGeneratorODTFile;
    private final IngestExternalParametersService ingestExternalParametersService;
    private final IngestAccessContractService ingestAccessContractService;

    public IngestService(SecurityService securityService, LogbookService logbookService, ObjectMapper objectMapper, IngestExternalClient ingestExternalClient, CustomersApi customersApi, UsersApi usersApi, IngestGeneratorODTFile ingestGeneratorODTFile, IngestExternalParametersService ingestExternalParametersService, IngestAccessContractService ingestAccessContractService) {
        this.securityService = securityService;
        this.ingestExternalClient = ingestExternalClient;
        this.logbookService = logbookService;
        this.objectMapper = objectMapper;
        this.customersApi = customersApi;
        this.usersApi = usersApi;
        this.ingestGeneratorODTFile = ingestGeneratorODTFile;
        this.ingestExternalParametersService = ingestExternalParametersService;
        this.ingestAccessContractService = ingestAccessContractService;
    }

    public PaginatedValuesDto<LogbookOperationDto> getAllPaginated(Integer pageNumber, Integer size, Optional<String> orderBy, Optional<DirectionDto> direction, Optional<String> criteria) {
        JsonNode query;
        Optional<AccessContractDto> accessContractDtoOpt;
        VitamContext vitamContext = this.ingestExternalParametersService.buildVitamContextFromExternalParam();
        String accessContract = vitamContext.getAccessContract();
        Set originatingAgencies = null;
        Boolean everyOriginatingAgency = false;
        if (accessContract != null && (accessContractDtoOpt = this.ingestAccessContractService.getOne(vitamContext, accessContract)).isPresent()) {
            originatingAgencies = accessContractDtoOpt.get().getOriginatingAgencies();
            everyOriginatingAgency = accessContractDtoOpt.get().getEveryOriginatingAgency();
        }
        Map<String, Object> vitamCriteria = new HashMap<String, Object>();
        try {
            LOGGER.info(" All ingests EvIdAppSession : {} ", (Object)vitamContext.getApplicationSessionId());
            if (criteria.isPresent()) {
                TypeReference<HashMap<String, Object>> typRef = new TypeReference<HashMap<String, Object>>(){};
                vitamCriteria = (Map)this.objectMapper.readValue(criteria.get(), (TypeReference)typRef);
                if (!everyOriginatingAgency.booleanValue() && originatingAgencies != null) {
                    vitamCriteria.put(SELECTED_ORIGINATING_AGENCIES, new ArrayList(originatingAgencies));
                }
            }
            query = VitamQueryHelper.createQueryDSL(vitamCriteria, pageNumber, size, orderBy, direction);
        }
        catch (InvalidCreateOperationException | InvalidParseOperationException ioe) {
            throw new InternalServerException("Unable to find LogbookOperations with pagination", ioe);
        }
        catch (IOException e) {
            throw new InternalServerException("Can't parse criteria as Vitam query", (Throwable)e);
        }
        LogbookOperationsCommonResponseDto results = this.findAll(vitamContext, query);
        boolean hasMore = pageNumber * size + results.getHits().getSize() < results.getHits().getTotal();
        List<LogbookOperationDto> valuesDto = IngestConverter.convertVitamsToDtos(results.getResults());
        LOGGER.debug("After Conversion: {}", valuesDto);
        return new PaginatedValuesDto(valuesDto, pageNumber.intValue(), results.getHits().getSize().intValue(), hasMore);
    }

    public LogbookOperationDto getOne(String id) {
        try {
            VitamContext vitamContext = this.ingestExternalParametersService.buildVitamContextFromExternalParam();
            LOGGER.info("Ingest EvIdAppSession : {} ", (Object)vitamContext.getApplicationSessionId());
            RequestResponse requestResponse = this.logbookService.selectOperationbyId(id, vitamContext);
            LOGGER.debug("One Ingest Response: {}: ", (Object)requestResponse);
            LogbookOperationsCommonResponseDto logbookOperationDtos = (LogbookOperationsCommonResponseDto)this.objectMapper.treeToValue((TreeNode)requestResponse.toJsonNode(), LogbookOperationsCommonResponseDto.class);
            List<LogbookOperationDto> singleLogbookOperationDto = IngestConverter.convertVitamsToDtos(logbookOperationDtos.getResults());
            return singleLogbookOperationDto.get(0);
        }
        catch (JsonProcessingException | VitamClientException e) {
            throw new InternalServerException("Unable to find LogbookOperations", e);
        }
    }

    private LogbookOperationsCommonResponseDto findAll(VitamContext vitamContext, JsonNode query) {
        try {
            LOGGER.info("All Ingest EvIdAppSession : {} ", (Object)vitamContext.getApplicationSessionId());
            RequestResponse requestResponse = this.logbookService.selectOperations(query, vitamContext);
            LOGGER.debug("Response: {}: ", (Object)requestResponse);
            LogbookOperationsCommonResponseDto logbookOperationsCommonResponseDto = (LogbookOperationsCommonResponseDto)this.objectMapper.treeToValue((TreeNode)requestResponse.toJsonNode(), LogbookOperationsCommonResponseDto.class);
            LOGGER.debug("Response DTO: {}: ", (Object)logbookOperationsCommonResponseDto);
            return logbookOperationsCommonResponseDto;
        }
        catch (JsonProcessingException | VitamClientException e) {
            throw new InternalServerException("Unable to find LogbookOperations", e);
        }
    }

    public String getManifestAsString(VitamContext vitamContext, String id) {
        try {
            String manifest = "";
            Response response = this.ingestExternalClient.downloadObjectAsync(vitamContext, id, IngestCollection.MANIFESTS);
            Object entity = response.getEntity();
            if (entity instanceof InputStream) {
                InputStream stream = (InputStream)entity;
                InputStreamResource resource = new InputStreamResource(stream);
                manifest = this.ingestGeneratorODTFile.resourceAsString((Resource)resource).replaceAll(ILLEGAL_CHARACTERS, "");
            }
            LOGGER.info("Manifest EvIdAppSession : {} ", (Object)vitamContext.getApplicationSessionId());
            return manifest;
        }
        catch (VitamClientException e) {
            LOGGER.error("Unable to find the Manifest {}", (Object)e.getMessage());
            throw new InternalServerException("Unable to find the Manifest", (Throwable)e);
        }
    }

    public String getAtrAsString(VitamContext vitamContext, String id) {
        try {
            String atr = "";
            Response response = this.ingestExternalClient.downloadObjectAsync(vitamContext, id, IngestCollection.ARCHIVETRANSFERREPLY);
            Object entity = response.getEntity();
            if (entity instanceof InputStream) {
                InputStream stream = (InputStream)entity;
                InputStreamResource resource = new InputStreamResource(stream);
                atr = this.ingestGeneratorODTFile.resourceAsString((Resource)resource).replaceAll(ILLEGAL_CHARACTERS, "");
            }
            LOGGER.info("ATR EvIdAppSession : {} ", (Object)vitamContext.getApplicationSessionId());
            return atr;
        }
        catch (VitamClientException e) {
            LOGGER.error("Unable to find ATR {}", (Object)e.getMessage());
            throw new InternalServerException("Unable to find ATR", (Throwable)e);
        }
    }

    public byte[] generateODTReport(String id) throws IngestFileGenerationException {
        try {
            TextDocument document;
            LOGGER.info("Generate ODT Report : get Manifest and ATR of the operation ID : {} ", (Object)id);
            VitamContext vitamContext = this.ingestExternalParametersService.buildVitamContextFromExternalParam();
            AuthUserDto me = this.usersApi.getMe();
            if (me == null || StringUtils.isEmpty((CharSequence)me.getCustomerId())) {
                throw new IngestFileGenerationException("Could not retrieve current user or his customer id to generate the document");
            }
            CustomerDto myCustomer = this.customersApi.getMyCustomer();
            Resource customerLogo = null;
            Document atr = this.ingestGeneratorODTFile.convertStringToXMLDocument(this.getAtrAsString(vitamContext, id));
            Document manifest = this.ingestGeneratorODTFile.convertStringToXMLDocument(this.getManifestAsString(vitamContext, id));
            try {
                document = TextDocument.newTextDocument();
            }
            catch (Exception e) {
                LOGGER.error("Error to initialize the document : {} ", (Object)e.getMessage());
                throw new IngestFileGenerationException("Error to initialize the document : {} ", (Throwable)e);
            }
            if (myCustomer.isHasCustomGraphicIdentity()) {
                customerLogo = this.customersApi.getLogo(myCustomer.getId(), AttachmentType.HEADER.value());
            }
            List<ArchiveUnitDto> archiveUnitDtoList = this.ingestGeneratorODTFile.getValuesForDynamicTable(atr, manifest);
            LOGGER.info("Generate ODT Report : get customer : {} logo ", (Object)myCustomer.getId());
            this.ingestGeneratorODTFile.generateDocumentHeader(document, (fr.gouv.vitamui.iam.common.dto.CustomerDto)myCustomer, customerLogo);
            LOGGER.info("Generate ODT Report : generate the first page content ");
            this.ingestGeneratorODTFile.generateFirstTitle(document);
            this.ingestGeneratorODTFile.generateServicesTable(document, manifest);
            this.ingestGeneratorODTFile.generateDepositDataTable(document, manifest, archiveUnitDtoList);
            this.ingestGeneratorODTFile.generateOperationDataTable(document, manifest, id);
            this.ingestGeneratorODTFile.generateResponsibleSignatureTable(document);
            document.addPageBreak();
            LOGGER.info("Generate ODT Report : generate the second page content");
            this.ingestGeneratorODTFile.generateSecondtTitle(document);
            this.ingestGeneratorODTFile.generateArchiveUnitDetailsTable(document, archiveUnitDtoList);
            LOGGER.info("Generate ODT Report EvIdAppSession : {} ", (Object)vitamContext.getApplicationSessionId());
            ByteArrayOutputStream result = new ByteArrayOutputStream();
            try {
                document.save((OutputStream)result);
            }
            catch (Exception e) {
                LOGGER.error("Error to save the document : {} ", (Object)e.getMessage());
                throw new IngestFileGenerationException("Error to save the document : {} ", (Throwable)e);
            }
            return result.toByteArray();
        }
        catch (IngestFileGenerationException | IOException | URISyntaxException e) {
            LOGGER.error("Error with generating Report : {} ", (Object)e.getMessage());
            throw new IngestFileGenerationException("Unable to generate the ingest report ", e);
        }
    }

    public ResponseEntity<Void> streamingUpload(InputStream inputStream, String contextId, String action) throws IngestExternalException {
        try {
            VitamContext vitamContext = new VitamContext(this.securityService.getTenantIdentifier()).setApplicationSessionId(this.securityService.getApplicationId());
            RequestResponse ingestResponse = this.ingestExternalClient.ingest(vitamContext, inputStream, contextId, action);
            if (!ingestResponse.isOk()) {
                LOGGER.debug("Error on ingest streaming Upload ");
                throw new VitamClientException("Error on ingest streaming Upload");
            }
            String operationId = (String)ingestResponse.getVitamHeaders().get("X-Request-Id");
            LOGGER.debug("Ingest passed successfully : " + String.valueOf(ingestResponse) + " with operationId = " + operationId);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("X-Operation-Id", new String[]{operationId})).build();
        }
        catch (Exception e) {
            LOGGER.debug("Error sending upload to vitam ", (Throwable)e);
            throw new IngestExternalException((Throwable)e);
        }
    }
}

