/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.ingest.server.service;

import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitamui.iam.openapiclient.ExternalParametersApi;
import fr.gouv.vitamui.iam.security.service.SecurityService;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;

@Service
public class IngestExternalParametersService {
    public static final String PARAM_ACCESS_CONTRACT_NAME = "PARAM_ACCESS_CONTRACT";
    private final ExternalParametersApi externalParametersApi;
    private final SecurityService securityService;

    public IngestExternalParametersService(ExternalParametersApi externalParametersApi, SecurityService securityService) {
        this.externalParametersApi = externalParametersApi;
        this.securityService = securityService;
    }

    public String retrieveAccessContractFromExternalParam() {
        Map myExternalParameter = this.externalParametersApi.getMyExternalParameters();
        if (myExternalParameter == null || CollectionUtils.isEmpty(myExternalParameter.entrySet())) {
            throw new IllegalArgumentException("No external profile defined for access contract defined");
        }
        Map.Entry parameterAccessContract = myExternalParameter.entrySet().stream().filter(entry -> PARAM_ACCESS_CONTRACT_NAME.equals(entry.getKey())).findFirst().orElse(null);
        if (Objects.isNull(parameterAccessContract) || Objects.isNull(parameterAccessContract.getValue())) {
            throw new IllegalArgumentException("No access contract defined");
        }
        return (String)parameterAccessContract.getValue();
    }

    public VitamContext buildVitamContextFromExternalParam() {
        return new VitamContext(this.securityService.getTenantIdentifier()).setAccessContract(this.retrieveAccessContractFromExternalParam()).setApplicationSessionId(this.securityService.getApplicationId());
    }
}

