/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.ingest.server.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import fr.gouv.vitam.ingest.external.client.IngestExternalClient;
import fr.gouv.vitamui.commons.api.application.AbstractContextConfiguration;
import fr.gouv.vitamui.commons.rest.RestExceptionHandler;
import fr.gouv.vitamui.commons.vitam.api.access.LogbookService;
import fr.gouv.vitamui.commons.vitam.api.config.VitamAccessConfig;
import fr.gouv.vitamui.commons.vitam.api.config.VitamAdministrationConfig;
import fr.gouv.vitamui.commons.vitam.api.config.VitamIngestConfig;
import fr.gouv.vitamui.iam.openapiclient.CustomersApi;
import fr.gouv.vitamui.iam.openapiclient.ExternalParametersApi;
import fr.gouv.vitamui.iam.openapiclient.IamApiClientsFactory;
import fr.gouv.vitamui.iam.openapiclient.UsersApi;
import fr.gouv.vitamui.iam.security.provider.ApiAuthenticationProvider;
import fr.gouv.vitamui.iam.security.provider.ExternalApiAuthenticationProvider;
import fr.gouv.vitamui.iam.security.provider.InternalApiAuthenticationProvider;
import fr.gouv.vitamui.iam.security.service.IamClientUserAuthenticationService;
import fr.gouv.vitamui.iam.security.service.SecurityService;
import fr.gouv.vitamui.iam.security.service.UserAuthenticationService;
import fr.gouv.vitamui.ingest.server.config.ApiIngestApplicationProperties;
import fr.gouv.vitamui.ingest.server.security.WebSecurityConfig;
import fr.gouv.vitamui.ingest.server.service.IngestAccessContractService;
import fr.gouv.vitamui.ingest.server.service.IngestExternalParametersService;
import fr.gouv.vitamui.ingest.server.service.IngestGeneratorODTFile;
import fr.gouv.vitamui.ingest.server.service.IngestService;
import fr.gouv.vitamui.security.openapiclient.ContextsApi;
import fr.gouv.vitamui.security.openapiclient.SecurityApiClientsFactory;
import java.util.Arrays;
import org.springframework.boot.autoconfigure.http.HttpMessageConvertersAutoConfiguration;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.http.MediaType;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;

@Configuration
@Import(value={RestExceptionHandler.class, WebSecurityConfig.class, VitamAccessConfig.class, VitamIngestConfig.class, VitamAdministrationConfig.class, HttpMessageConvertersAutoConfiguration.class})
public class ApiIngestServerConfig
extends AbstractContextConfiguration {
    @Bean
    public SecurityApiClientsFactory securityApiClientsFactory(ApiIngestApplicationProperties apiIngestApplicationProperties, RestTemplateBuilder restTemplateBuilder) {
        return new SecurityApiClientsFactory(apiIngestApplicationProperties.getSecurityClient(), restTemplateBuilder);
    }

    @Bean
    public ContextsApi contextsApi(SecurityApiClientsFactory securityApiClientsFactory) {
        return securityApiClientsFactory.getContextsApi();
    }

    @Bean
    public MappingJackson2HttpMessageConverter customizedJacksonMessageConverter() {
        MappingJackson2HttpMessageConverter converter = new MappingJackson2HttpMessageConverter();
        converter.setSupportedMediaTypes(Arrays.asList(MediaType.APPLICATION_JSON, new MediaType("application", "*+json"), MediaType.APPLICATION_OCTET_STREAM));
        return converter;
    }

    @Bean
    public UserAuthenticationService authentificationService(UsersApi usersApi) {
        return new IamClientUserAuthenticationService(usersApi);
    }

    @Bean
    public ApiAuthenticationProvider apiAuthenticationProvider(UserAuthenticationService userAuthenticationService, ContextsApi contextsApi) {
        return new ApiAuthenticationProvider(new InternalApiAuthenticationProvider(userAuthenticationService), new ExternalApiAuthenticationProvider(contextsApi, userAuthenticationService));
    }

    @Bean
    public SecurityService securityService() {
        return new SecurityService();
    }

    @Bean
    public IamApiClientsFactory iamApiClientsFactory(ApiIngestApplicationProperties apiIngestApplicationProperties, RestTemplateBuilder restTemplateBuilder) {
        return new IamApiClientsFactory(apiIngestApplicationProperties.getIamClient(), restTemplateBuilder);
    }

    @Bean
    public UsersApi usersApi(IamApiClientsFactory iamApiClientsFactory) {
        return iamApiClientsFactory.getUsersApi();
    }

    @Bean
    public CustomersApi customersApi(IamApiClientsFactory iamApiClientsFactory) {
        return iamApiClientsFactory.getCustomersApi();
    }

    @Bean
    public IngestGeneratorODTFile ingestGeneratorODTFile() {
        return new IngestGeneratorODTFile();
    }

    @Bean
    public ExternalParametersApi externalParametersApi(IamApiClientsFactory iamApiClientsFactory) {
        return iamApiClientsFactory.getExternalParametersApi();
    }

    @Bean
    public IngestService ingestService(SecurityService securityService, LogbookService logbookService, ObjectMapper objectMapper, IngestExternalClient ingestExternalClient, CustomersApi customersApi, IngestGeneratorODTFile ingestGeneratorODTFile, IngestExternalParametersService ingestExternalParametersService, IngestAccessContractService ingestAccessContractService, UsersApi usersApi) {
        return new IngestService(securityService, logbookService, objectMapper, ingestExternalClient, customersApi, usersApi, ingestGeneratorODTFile, ingestExternalParametersService, ingestAccessContractService);
    }
}

