/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.ingest.common.dsl;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.common.database.builder.query.BooleanQuery;
import fr.gouv.vitam.common.database.builder.query.Query;
import fr.gouv.vitam.common.database.builder.query.QueryHelper;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.single.Select;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitamui.commons.api.domain.DirectionDto;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VitamQueryHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(VitamQueryHelper.class);
    public static final String AGENCY_IMPORT_OPERATION_TYPE = "IMPORT_AGENCIES.OK";
    private static final String ID = "#id";
    private static final String OB_ID_IN = "obIdIn";
    private static final String TRANSFERRING_AGENCY = "events.agIdExt.TransferringAgency";
    private static final String ORIGINATING_AGENCY = "events.agIdExt.originatingAgency";
    private static final String ARCHIVAL_AGENCY = "events.evDetData.ArchivalAgreement";
    private static final String EV_TYPE_PROC = "evTypeProc";
    private static final String STATUS = "Status";
    private static final String EV_TYPE = "evType";
    private static final String EV_DATE_TIME_START = "evDateTime_Start";
    private static final String EV_DATE_TIME_END = "evDateTime_End";
    private static final String COMMENT = "events.evDetData.EvDetailReq";
    private static final String SELECTED_ORIGINATING_AGENCIES = "SELECTED_ORIGINATING_AGENCIES";

    public static JsonNode createQueryDSL(Map<String, Object> searchCriteriaMap, Integer pageNumber, Integer size, Optional<String> orderBy, Optional<DirectionDto> direction) throws InvalidParseOperationException, InvalidCreateOperationException {
        Select select = new Select();
        BooleanQuery query = QueryHelper.and();
        BooleanQuery queryOr = QueryHelper.or();
        boolean isEmpty = true;
        boolean haveOrParameters = false;
        BooleanQuery orGroup = QueryHelper.or();
        boolean haveOrGroup = false;
        if (orderBy.isPresent()) {
            if (direction.isPresent() && DirectionDto.DESC.equals((Object)direction.get())) {
                select.addOrderByDescFilter(new String[]{orderBy.get()});
            } else {
                select.addOrderByAscFilter(new String[]{orderBy.get()});
            }
        }
        select.setLimitFilter((long)(pageNumber * size), (long)size.intValue());
        if (!searchCriteriaMap.isEmpty()) {
            isEmpty = false;
            Set<Map.Entry<String, Object>> entrySet = searchCriteriaMap.entrySet();
            block23: for (Map.Entry<String, Object> entry : entrySet) {
                String searchKey;
                switch (searchKey = entry.getKey()) {
                    case "evTypeProc": {
                        String stringValue = (String)entry.getValue();
                        query.add(new Query[]{QueryHelper.eq((String)searchKey, (String)stringValue)});
                        continue block23;
                    }
                    case "obIdIn": 
                    case "events.agIdExt.TransferringAgency": 
                    case "events.evDetData.ArchivalAgreement": 
                    case "events.agIdExt.originatingAgency": 
                    case "#id": 
                    case "events.evDetData.EvDetailReq": {
                        if (entry.getValue() instanceof ArrayList) {
                            ArrayList stringsValues = (ArrayList)entry.getValue();
                            for (String elt : stringsValues) {
                                queryOr.add(new Query[]{QueryHelper.eq((String)searchKey, (String)elt)});
                            }
                            haveOrParameters = true;
                            continue block23;
                        }
                        if (!(entry.getValue() instanceof String)) continue block23;
                        String searchValue = (String)entry.getValue();
                        queryOr.add(new Query[]{QueryHelper.eq((String)searchKey, (String)searchValue)});
                        haveOrParameters = true;
                        continue block23;
                    }
                    case "evType": {
                        if (entry.getValue() instanceof String) {
                            String evType = (String)entry.getValue();
                            query.add(new Query[]{QueryHelper.eq((String)searchKey, (String)evType)});
                            continue block23;
                        }
                    }
                    case "Status": {
                        ArrayList stringValues = (ArrayList)entry.getValue();
                        query.add(new Query[]{QueryHelper.in((String)searchKey, (String[])stringValues.toArray(new String[0]))});
                        continue block23;
                    }
                    case "evDateTime_Start": {
                        query.add(new Query[]{QueryHelper.gt((String)"evDateTime", (String)((String)entry.getValue()))});
                        continue block23;
                    }
                    case "evDateTime_End": {
                        query.add(new Query[]{QueryHelper.lt((String)"evDateTime", (String)((String)entry.getValue()))});
                        continue block23;
                    }
                    case "SELECTED_ORIGINATING_AGENCIES": {
                        if (!(entry.getValue() instanceof ArrayList)) continue block23;
                        ArrayList stringsValues = (ArrayList)entry.getValue();
                        for (String elt : stringsValues) {
                            orGroup.add(new Query[]{QueryHelper.eq((String)ORIGINATING_AGENCY, (String)elt)});
                        }
                        haveOrGroup = true;
                        continue block23;
                    }
                }
                LOGGER.error("Can not find binding for key: {}", (Object)searchKey);
            }
        }
        if (!isEmpty) {
            if (haveOrParameters) {
                query.add(new Query[]{queryOr});
            }
            if (haveOrGroup) {
                query.add(new Query[]{orGroup});
            }
            select.setQuery((Query)query);
        }
        LOGGER.debug("Final query: {}", (Object)select.getFinalSelect().toPrettyString());
        return select.getFinalSelect();
    }
}

