/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.storage.swift;

import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.storage.StorageConfiguration;
import fr.gouv.vitam.common.storage.swift.SwiftKeystoneFactoryV3;
import java.util.function.Function;
import org.openstack4j.api.identity.EndpointURLResolver;
import org.openstack4j.api.types.ServiceType;
import org.openstack4j.model.identity.URLResolverParams;
import org.openstack4j.openstack.identity.internal.DefaultEndpointURLResolver;

public class VitamEndpointUrlResolver
implements EndpointURLResolver {
    private DefaultEndpointURLResolver resolver;
    private StorageConfiguration configuration;
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(SwiftKeystoneFactoryV3.class);

    public VitamEndpointUrlResolver(StorageConfiguration configuration) {
        this(new DefaultEndpointURLResolver(), configuration);
    }

    @VisibleForTesting
    VitamEndpointUrlResolver(DefaultEndpointURLResolver resolver, StorageConfiguration configuration) {
        this.resolver = resolver;
        this.configuration = configuration;
    }

    public String findURLV2(URLResolverParams params) {
        return this.findSwiftUrl(params, arg_0 -> ((DefaultEndpointURLResolver)this.resolver).findURLV2(arg_0));
    }

    public String findURLV3(URLResolverParams params) {
        return this.findSwiftUrl(params, arg_0 -> ((DefaultEndpointURLResolver)this.resolver).findURLV3(arg_0));
    }

    private String findSwiftUrl(URLResolverParams params, Function<URLResolverParams, String> findURL) {
        String result = findURL.apply(params);
        if (params.type == ServiceType.OBJECT_STORAGE) {
            if (this.configuration.getSwiftUrl() == null || "".equals(this.configuration.getSwiftUrl().trim())) {
                LOGGER.debug("No swift url found in configuration, using openstack4j EndpointUrlResolver result");
                return result;
            }
            if (result != null) {
                return this.configuration.getSwiftUrl();
            }
        }
        return result;
    }
}

