/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.storage.swift;

import com.google.common.base.Stopwatch;
import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.performance.PerformanceLogger;
import fr.gouv.vitam.common.storage.StorageConfiguration;
import fr.gouv.vitam.common.storage.swift.VitamEndpointUrlResolver;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.openstack4j.api.OSClient;
import org.openstack4j.api.client.IOSClientBuilder;
import org.openstack4j.api.identity.EndpointURLResolver;
import org.openstack4j.core.transport.Config;
import org.openstack4j.model.identity.v2.Access;
import org.openstack4j.openstack.OSFactory;
import org.openstack4j.openstack.internal.OSClientSession;

public class SwiftKeystoneFactoryV2
implements Supplier<OSClient> {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(SwiftKeystoneFactoryV2.class);
    private final StorageConfiguration configuration;
    private final Config configOS4J;
    private final AtomicReference<Access> atomicAccess = new AtomicReference<Object>(null);
    private final AtomicBoolean oneThread = new AtomicBoolean(true);
    private final Object monitor = new Object();

    public SwiftKeystoneFactoryV2(StorageConfiguration configuration) {
        this.configOS4J = Config.newConfig().withEndpointURLResolver((EndpointURLResolver)new VitamEndpointUrlResolver(configuration)).withConnectionTimeout(configuration.getSwiftConnectionTimeout()).withReadTimeout(configuration.getSwiftReadTimeout()).withMaxConnections(configuration.getSwiftMaxConnections()).withMaxConnectionsPerRoute(configuration.getSwiftMaxConnectionsPerRoute());
        this.configuration = configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OSClient.OSClientV2 get() {
        Access currentAccess = this.atomicAccess.get();
        Date nearTime = LocalDateUtil.getDate((LocalDateTime)LocalDateUtil.now().plusSeconds(this.configuration.getSwiftHardRenewTokenDelayBeforeExpireTime()));
        if (currentAccess == null || currentAccess.getToken().getExpires().before(nearTime)) {
            Object object = this.monitor;
            synchronized (object) {
                currentAccess = this.atomicAccess.get();
                if (currentAccess == null) {
                    OSClient.OSClientV2 osClientV2 = this.renewAccess();
                    currentAccess = osClientV2.getAccess();
                    this.atomicAccess.set(currentAccess);
                    return osClientV2;
                }
            }
        }
        Date farTime = LocalDateUtil.getDate((LocalDateTime)LocalDateUtil.now().plusSeconds(this.configuration.getSwiftSoftRenewTokenDelayBeforeExpireTime()));
        if (currentAccess.getToken().getExpires().before(farTime) && this.oneThread.compareAndSet(true, false)) {
            try {
                OSClient.OSClientV2 osClientV2 = this.renewAccess();
                currentAccess = osClientV2.getAccess();
                this.atomicAccess.set(currentAccess);
                OSClient.OSClientV2 oSClientV2 = osClientV2;
                return oSClientV2;
            }
            finally {
                this.oneThread.set(true);
            }
        }
        OSClientSession.OSClientSessionV2 currentClient = (OSClientSession.OSClientSessionV2)OSClientSession.OSClientSessionV2.getCurrent();
        if (null != currentClient && currentAccess.getToken().equals((Object)currentClient.getAccess().getToken())) {
            return currentClient;
        }
        return OSFactory.clientFromAccess((Access)currentAccess, (Config)this.configOS4J);
    }

    private OSClient.OSClientV2 renewAccess() {
        Stopwatch times = Stopwatch.createStarted();
        LOGGER.info("No access or access expired, let's get authenticate again");
        try {
            OSClient.OSClientV2 oSClientV2 = (OSClient.OSClientV2)((IOSClientBuilder.V2)((IOSClientBuilder.V2)((IOSClientBuilder.V2)OSFactory.builderV2().endpoint(this.configuration.getSwiftKeystoneAuthUrl())).tenantName(this.configuration.getSwiftDomain()).credentials(this.configuration.getSwiftUser(), this.configuration.getSwiftPassword())).withConfig(this.configOS4J)).authenticate();
            return oSClientV2;
        }
        finally {
            PerformanceLogger.getInstance().log("STP_AUTHENTICATION", "AUTHENTICATE", "RENEW_ACCESS", times.elapsed(TimeUnit.MILLISECONDS));
        }
    }
}

