/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.storage.s3;

class BucketNameUtils {
    private static final int MIN_BUCKET_NAME_LENGTH = 3;
    private static final int MAX_BUCKET_NAME_LENGTH = 63;

    BucketNameUtils() {
    }

    public static void validateBucketName(String bucketName) {
        if (bucketName == null) {
            throw new IllegalArgumentException("Bucket name cannot be null");
        }
        if (bucketName.length() < 3 || bucketName.length() > 63) {
            throw new IllegalArgumentException("Bucket name must be between 3 and 63 characters long: " + bucketName);
        }
        if (!bucketName.matches("^[a-z0-9.]+$")) {
            throw new IllegalArgumentException("Bucket name can only contain lowercase letters, numbers, and periods: " + bucketName);
        }
        if (!bucketName.matches("^[a-z0-9].*")) {
            throw new IllegalArgumentException("Bucket name must start with a lowercase letter or number: " + bucketName);
        }
        if (bucketName.contains("..")) {
            throw new IllegalArgumentException("Bucket name cannot contain two adjacent periods: " + bucketName);
        }
        if (bucketName.endsWith(".")) {
            throw new IllegalArgumentException("Bucket name cannot end with a period: " + bucketName);
        }
        if (bucketName.matches("^\\d+\\.\\d+\\.\\d+\\.\\d+$")) {
            throw new IllegalArgumentException("Bucket name cannot be formatted as an IP address: " + bucketName);
        }
    }
}

