/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.storage.constants;

public enum StorageProvider {
    FILESYSTEM("filesystem", true),
    SWIFT_AUTH_V1("openstack-swift", false),
    SWIFT_AUTH_V2("openstack-swift-v2", false),
    SWIFT_AUTH_V3("openstack-swift-v3", false),
    AMAZON_S3_V2("amazon-s3-v2", false),
    HASHFILESYSTEM("filesystem-hash", true),
    TAPE_LIBRARY("tape-library", false);

    private String value;
    private boolean hasStoragePath;

    private StorageProvider(String value, boolean hasStoragePath) {
        this.value = value;
        this.hasStoragePath = hasStoragePath;
    }

    public static StorageProvider getStorageProvider(String storageProvider) {
        for (StorageProvider provider : StorageProvider.values()) {
            if (!provider.getValue().equalsIgnoreCase(storageProvider)) continue;
            return provider;
        }
        throw new IllegalArgumentException();
    }

    public String getValue() {
        return this.value;
    }

    public boolean hasStoragePath() {
        return this.hasStoragePath;
    }
}

