/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.storage.cas.container.api;

import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.digest.DigestType;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.storage.ObjectEntry;
import fr.gouv.vitam.common.storage.ContainerInformation;
import fr.gouv.vitam.common.storage.StorageConfiguration;
import fr.gouv.vitam.common.storage.cas.container.api.ContentAddressableStorageAbstract;
import fr.gouv.vitam.common.storage.cas.container.api.ObjectContent;
import fr.gouv.vitam.common.storage.cas.container.api.ObjectListingListener;
import fr.gouv.vitam.common.storage.constants.ErrorMessage;
import fr.gouv.vitam.common.stream.StreamUtils;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageDigestMismatchException;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageException;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.blobstore.ContainerNotFoundException;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.domain.PageSet;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.blobstore.options.ListContainerOptions;

public abstract class ContentAddressableStorageJcloudsAbstract
extends ContentAddressableStorageAbstract {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(ContentAddressableStorageJcloudsAbstract.class);
    protected final BlobStoreContext context;

    public ContentAddressableStorageJcloudsAbstract(StorageConfiguration configuration) {
        super(configuration);
        this.context = this.getContext(configuration);
    }

    public abstract BlobStoreContext getContext(StorageConfiguration var1);

    public abstract void closeContext();

    @Override
    public void createContainer(String containerName) {
        LOGGER.info(" create container : " + containerName);
        ParametersChecker.checkParameter((String)ErrorMessage.CONTAINER_NAME_IS_A_MANDATORY_PARAMETER.getMessage(), (String[])new String[]{containerName});
        try {
            if (!this.context.getBlobStore().createContainerInLocation(null, containerName)) {
                LOGGER.warn("Container " + containerName + " already exists");
            }
        }
        finally {
            this.closeContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isExistingContainer(String containerName) {
        try {
            if (super.isExistingContainerInCache(containerName)) {
                boolean bl = true;
                return bl;
            }
            boolean exists = this.context.getBlobStore().containerExists(containerName);
            this.cacheExistsContainer(containerName, exists);
            boolean bl = exists;
            return bl;
        }
        finally {
            this.closeContext();
        }
    }

    @Override
    public void writeObject(String containerName, String objectName, InputStream inputStream, DigestType digestType, long size) throws ContentAddressableStorageException {
        ParametersChecker.checkParameter((String)ErrorMessage.CONTAINER_OBJECT_NAMES_ARE_A_MANDATORY_PARAMETER.getMessage(), (String[])new String[]{containerName, objectName});
        BlobStore blobStore = this.context.getBlobStore();
        try {
            Blob blob = blobStore.blobBuilder(objectName).payload(inputStream).build();
            blob.getMetadata().getContentMetadata().setContentLength(Long.valueOf(size));
            blobStore.putBlob(containerName, blob);
        }
        catch (ContainerNotFoundException e) {
            LOGGER.error(ErrorMessage.CONTAINER_NOT_FOUND.getMessage() + containerName);
            throw new ContentAddressableStorageNotFoundException((Throwable)e);
        }
        catch (Exception e) {
            LOGGER.error("Rollback", (Object)e.getMessage());
            throw new ContentAddressableStorageException((Throwable)e);
        }
        finally {
            this.closeContext();
            StreamUtils.closeSilently((InputStream)inputStream);
        }
    }

    @Override
    public void checkObjectDigestAndStoreDigest(String containerName, String objectName, String objectDigest, DigestType digestType, long size) throws ContentAddressableStorageException {
        String computedDigest = this.computeObjectDigest(containerName, objectName, digestType);
        if (!objectDigest.equals(computedDigest)) {
            throw new ContentAddressableStorageDigestMismatchException("Illegal state for container " + containerName + " and object " + objectName + ". Stream digest " + objectDigest + " is not equal to computed digest " + computedDigest);
        }
    }

    @Override
    public String getObjectDigest(String containerName, String objectName, DigestType digestType, boolean noCache) throws ContentAddressableStorageException {
        return this.computeObjectDigest(containerName, objectName, digestType);
    }

    @Override
    public ObjectContent getObject(String containerName, String objectName) throws ContentAddressableStorageException {
        ParametersChecker.checkParameter((String)ErrorMessage.CONTAINER_OBJECT_NAMES_ARE_A_MANDATORY_PARAMETER.getMessage(), (String[])new String[]{containerName, objectName});
        try {
            BlobStore blobStore = this.context.getBlobStore();
            if (!this.isExistingObject(containerName, objectName)) {
                throw new ContentAddressableStorageNotFoundException(ErrorMessage.OBJECT_NOT_FOUND.getMessage() + objectName + " in container '" + containerName + "'");
            }
            Blob blob = blobStore.getBlob(containerName, objectName);
            if (null == blob) {
                throw new ContentAddressableStorageNotFoundException(ErrorMessage.OBJECT_NOT_FOUND.getMessage() + objectName);
            }
            long size = blob.getMetadata().getSize();
            InputStream is = blob.getPayload().openStream();
            ObjectContent objectContent = new ObjectContent(is, size);
            return objectContent;
        }
        catch (ContainerNotFoundException e) {
            throw new ContentAddressableStorageNotFoundException(ErrorMessage.CONTAINER_NOT_FOUND.getMessage() + containerName, (Throwable)e);
        }
        catch (ContentAddressableStorageNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ContentAddressableStorageException((Throwable)e);
        }
        finally {
            this.closeContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteObject(String containerName, String objectName) throws ContentAddressableStorageNotFoundException {
        ParametersChecker.checkParameter((String)ErrorMessage.CONTAINER_OBJECT_NAMES_ARE_A_MANDATORY_PARAMETER.getMessage(), (String[])new String[]{containerName, objectName});
        try {
            BlobStore blobStore = this.context.getBlobStore();
            if (!this.isExistingContainer(containerName) || !this.isExistingObject(containerName, objectName)) {
                throw new ContentAddressableStorageNotFoundException(ErrorMessage.OBJECT_NOT_FOUND.getMessage() + objectName);
            }
            blobStore.removeBlob(containerName, objectName);
        }
        finally {
            this.closeContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isExistingObject(String containerName, String objectName) {
        try {
            boolean isExists = false;
            BlobStore blobStore = this.context.getBlobStore();
            try {
                isExists = blobStore.blobExists(containerName, objectName);
            }
            catch (Exception e) {
                LOGGER.info(e.getMessage());
            }
            boolean bl = isExists;
            return bl;
        }
        finally {
            this.closeContext();
        }
    }

    @Override
    public abstract ContainerInformation getContainerInformation(String var1) throws ContentAddressableStorageNotFoundException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void listContainer(String containerName, ObjectListingListener objectListingListener) throws ContentAddressableStorageNotFoundException, IOException {
        ParametersChecker.checkParameter((String)ErrorMessage.CONTAINER_NAME_IS_A_MANDATORY_PARAMETER.getMessage(), (String[])new String[]{containerName});
        try {
            PageSet pageSet;
            BlobStore blobStore = this.context.getBlobStore();
            if (!this.isExistingContainer(containerName)) {
                LOGGER.error(ErrorMessage.CONTAINER_NOT_FOUND.getMessage() + containerName);
                throw new ContentAddressableStorageNotFoundException(ErrorMessage.CONTAINER_NOT_FOUND.getMessage() + containerName);
            }
            String nextMarker = null;
            do {
                ListContainerOptions options = new ListContainerOptions();
                options.maxResults(100);
                if (nextMarker != null) {
                    options.afterMarker(nextMarker);
                }
                pageSet = blobStore.list(containerName, options);
                for (StorageMetadata storageMetadata : pageSet) {
                    objectListingListener.handleObjectEntry(new ObjectEntry(storageMetadata.getName(), storageMetadata.getSize().longValue()));
                }
            } while ((nextMarker = pageSet.getNextMarker()) != null);
        }
        finally {
            this.closeContext();
        }
    }
}

