/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.storage.cas.container.api;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Stopwatch;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.digest.Digest;
import fr.gouv.vitam.common.digest.DigestType;
import fr.gouv.vitam.common.performance.PerformanceLogger;
import fr.gouv.vitam.common.storage.StorageConfiguration;
import fr.gouv.vitam.common.storage.cas.container.api.ContentAddressableStorage;
import fr.gouv.vitam.common.storage.constants.ErrorMessage;
import fr.gouv.vitam.common.stream.SizedInputStream;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.tuple.Pair;

public abstract class ContentAddressableStorageAbstract
implements ContentAddressableStorage {
    private static boolean disableContainerCaching = false;
    private final Set<String> existingContainer = Collections.synchronizedSet(new HashSet());
    private final StorageConfiguration configuration;
    public static final int LISTING_MAX_RESULTS = 100;

    protected ContentAddressableStorageAbstract(StorageConfiguration configuration) {
        this.configuration = configuration;
    }

    public StorageConfiguration getConfiguration() {
        return this.configuration;
    }

    protected String computeObjectDigest(String containerName, String objectName, DigestType algo) throws ContentAddressableStorageException {
        return (String)this.computeObjectDigestAndSize(containerName, objectName, algo).getLeft();
    }

    protected Pair<String, Long> computeObjectDigestAndSize(String containerName, String objectName, DigestType algo) throws ContentAddressableStorageException {
        ParametersChecker.checkParameter((String)ErrorMessage.ALGO_IS_A_MANDATORY_PARAMETER.getMessage(), (Object[])new Object[]{algo});
        Stopwatch sw = Stopwatch.createStarted();
        try {
            Pair pair;
            block11: {
                InputStream stream = this.getObject(containerName, objectName).getInputStream();
                try {
                    SizedInputStream sizedInputStream = new SizedInputStream(stream);
                    Digest digest = new Digest(algo);
                    digest.update((InputStream)sizedInputStream);
                    pair = Pair.of((Object)digest.toString(), (Object)sizedInputStream.getSize());
                    if (stream == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new ContentAddressableStorageException((Throwable)e);
                    }
                }
                stream.close();
            }
            return pair;
        }
        finally {
            PerformanceLogger.getInstance().log("STP_Offer_" + this.configuration.getProvider(), containerName, "COMPUTE_DIGEST_FROM_STREAM", sw.elapsed(TimeUnit.MILLISECONDS));
        }
    }

    protected boolean isExistingContainerInCache(String containerName) {
        return this.existingContainer.contains(containerName);
    }

    protected void cacheExistsContainer(String containerName, boolean exists) {
        if (exists && !disableContainerCaching) {
            this.existingContainer.add(containerName);
        }
    }

    @VisibleForTesting
    public static void disableContainerCaching() {
        disableContainerCaching = true;
    }
}

