/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.scheduler.server.job;

import com.google.common.base.Stopwatch;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.MetadataType;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.thread.VitamThreadPoolExecutor;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import fr.gouv.vitam.logbook.common.exception.LogbookClientServerException;
import fr.gouv.vitam.logbook.common.model.LifecycleTraceabilityStatus;
import fr.gouv.vitam.logbook.common.model.TraceabilityType;
import fr.gouv.vitam.logbook.operations.client.LogbookOperationsClient;
import fr.gouv.vitam.logbook.operations.client.LogbookOperationsClientFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.StringUtils;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

@DisallowConcurrentExecution
public class TraceabilityLFCJob
implements Job {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(TraceabilityLFCJob.class);
    private static final String ITEM = "item";
    private final LogbookOperationsClientFactory logbookOperationsClientFactory;

    public TraceabilityLFCJob() {
        this(LogbookOperationsClientFactory.getInstance());
    }

    public TraceabilityLFCJob(LogbookOperationsClientFactory logbookOperationsClientFactory) {
        this.logbookOperationsClientFactory = logbookOperationsClientFactory;
    }

    private boolean secureAllTenants(MetadataType metadataType) {
        List tenants = VitamConfiguration.getTenants();
        VitamThreadPoolExecutor defaultExecutor = VitamThreadPoolExecutor.getDefaultExecutor();
        ArrayList<CompletableFuture<Void>> completableFutures = new ArrayList<CompletableFuture<Void>>();
        AtomicBoolean atLeastOneTenantReachedMaxCapacity = new AtomicBoolean();
        for (Integer tenant : tenants) {
            completableFutures.add(CompletableFuture.runAsync(() -> {
                if (this.secureByTenantId(tenant, metadataType)) {
                    atLeastOneTenantReachedMaxCapacity.set(true);
                }
            }, (Executor)defaultExecutor));
        }
        CompletableFuture.allOf(completableFutures.toArray(new CompletableFuture[0])).join();
        return atLeastOneTenantReachedMaxCapacity.get();
    }

    private boolean secureByTenantId(int tenantId, MetadataType metadataType) {
        String operationId = null;
        try {
            boolean bl;
            block18: {
                LogbookOperationsClient client;
                block16: {
                    boolean bl2;
                    block17: {
                        VitamThreadUtils.getVitamSession().setTenantId(Integer.valueOf(tenantId));
                        client = this.logbookOperationsClientFactory.getClient();
                        operationId = this.runLfcTraceability(tenantId, metadataType, client);
                        if (operationId != null) break block16;
                        LOGGER.info("No " + String.valueOf(metadataType) + " LFC traceability required for tenant " + tenantId);
                        bl2 = false;
                        if (client == null) break block17;
                        client.close();
                    }
                    return bl2;
                }
                try {
                    LifecycleTraceabilityStatus lifecycleTraceabilityStatus;
                    int timeSleep = 1000;
                    Stopwatch stopwatch = Stopwatch.createStarted();
                    do {
                        TimeUnit.MILLISECONDS.sleep(timeSleep);
                        timeSleep = Math.min(timeSleep * 2, 60000);
                        lifecycleTraceabilityStatus = client.checkLifecycleTraceabilityWorkflowStatus(operationId);
                        if (lifecycleTraceabilityStatus.isPaused()) {
                            LOGGER.error("LFC traceability operation on tenant {} for operationId {} is in PAUSE state", (Object)tenantId, (Object)operationId);
                            break;
                        }
                        LOGGER.info("Traceability operation status for tenant {}, operationId {}, status {})", new Object[]{tenantId, operationId, lifecycleTraceabilityStatus.toString()});
                    } while (!lifecycleTraceabilityStatus.isCompleted() && stopwatch.elapsed(TimeUnit.MINUTES) < 30L);
                    bl = lifecycleTraceabilityStatus.isMaxEntriesReached();
                    if (client == null) break block18;
                }
                catch (Throwable throwable) {
                    try {
                        if (client != null) {
                            try {
                                client.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (InvalidParseOperationException | LogbookClientServerException e) {
                        LOGGER.error(e);
                        throw new IllegalStateException("Error when securing Tenant  :  " + tenantId, e);
                    }
                    catch (InterruptedException e) {
                        LOGGER.error((Throwable)e);
                        throw new IllegalStateException("Error on Thread on Tenant: " + tenantId + " for operationId: " + operationId, e);
                    }
                }
                client.close();
            }
            return bl;
        }
        finally {
            VitamThreadUtils.getVitamSession().setTenantId(null);
        }
    }

    private String runLfcTraceability(int tenantId, MetadataType metadataType, LogbookOperationsClient client) throws LogbookClientServerException, InvalidParseOperationException {
        String operationId = TraceabilityLFCJob.getOperationId((RequestResponseOK<String>)(switch (metadataType) {
            case MetadataType.OBJECTGROUP -> client.traceabilityLfcObjectGroup();
            case MetadataType.UNIT -> client.traceabilityLfcUnit();
            default -> throw new IllegalStateException("Unknown metadata type " + String.valueOf(metadataType));
        }));
        if (operationId == null) {
            LOGGER.info("Traceability operation not required for tenant {}", (Object)tenantId);
        } else {
            LOGGER.info("Traceability operation for tenant started successfully ({})", (Object)tenantId, (Object)operationId);
        }
        return operationId;
    }

    private static String getOperationId(RequestResponseOK<String> response) {
        return (String)response.getFirstResult();
    }

    public void execute(JobExecutionContext context) throws JobExecutionException {
        try {
            JobDataMap jobDataMap = context.getJobDetail().getJobDataMap();
            MetadataType metadataType = MetadataType.fromName((String)jobDataMap.get((Object)ITEM).toString());
            while (true) {
                boolean atLeastOneTenantReachedMaxCapacity;
                if (!(atLeastOneTenantReachedMaxCapacity = this.secureAllTenants(metadataType))) break;
                LOGGER.warn("At least one traceability operation reached max capacity. Re-run traceability...");
            }
            LOGGER.info("Done !");
            LOGGER.info("Traceability LFC for " + metadataType.getName() + " operation is finished");
        }
        catch (IllegalArgumentException e) {
            LOGGER.error("Expecting traceability type argument. Valid values: {}", (Object)StringUtils.join((Object[])TraceabilityType.values(), (String)", "));
            throw new IllegalStateException("Invalid command arguments", e);
        }
        catch (Exception e) {
            throw new JobExecutionException((Throwable)e);
        }
    }
}

