/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.scheduler.server.job;

import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.guid.GUIDFactory;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import fr.gouv.vitam.logbook.common.exception.LogbookClientServerException;
import fr.gouv.vitam.logbook.operations.client.LogbookOperationsClient;
import fr.gouv.vitam.logbook.operations.client.LogbookOperationsClientFactory;
import java.util.List;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

@DisallowConcurrentExecution
public class TraceabilityJob
implements Job {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(TraceabilityJob.class);
    private final LogbookOperationsClientFactory logbookOperationsClientFactory;

    public TraceabilityJob() {
        this(LogbookOperationsClientFactory.getInstance());
    }

    public TraceabilityJob(LogbookOperationsClientFactory logbookOperationsClientFactory) {
        this.logbookOperationsClientFactory = logbookOperationsClientFactory;
    }

    public void execute(JobExecutionContext context) throws JobExecutionException {
        LOGGER.info("Traceability operation in progress...");
        Integer adminTenant = VitamConfiguration.getAdminTenant();
        List tenants = VitamConfiguration.getTenants();
        try {
            VitamThreadUtils.getVitamSession().setTenantId(adminTenant);
            VitamThreadUtils.getVitamSession().setRequestId(GUIDFactory.newOperationLogbookGUID((int)adminTenant));
            try (LogbookOperationsClient client = this.logbookOperationsClientFactory.getClient();){
                LOGGER.info("Start traceability");
                client.traceability(tenants);
                LOGGER.info("Traceability done successfully");
            }
        }
        catch (InvalidParseOperationException | LogbookClientServerException e) {
            throw new JobExecutionException(" Error when securing logbook operations  :  " + adminTenant, e);
        }
        LOGGER.info("Traceability operation is finished");
    }
}

