/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.scheduler.server.job;

import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import fr.gouv.vitam.logbook.common.exception.LogbookClientServerException;
import fr.gouv.vitam.logbook.common.model.AuditLogbookOptions;
import fr.gouv.vitam.logbook.common.parameters.Contexts;
import fr.gouv.vitam.logbook.operations.client.LogbookOperationsClient;
import fr.gouv.vitam.logbook.operations.client.LogbookOperationsClientFactory;
import java.time.temporal.ChronoUnit;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

@DisallowConcurrentExecution
public class TraceabilityAuditJob
implements Job {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(TraceabilityAuditJob.class);
    private static final String OPERATION_TRACEABILITY_MAX_RENEWALY_DElAY = "operationTraceabilityMaxRenewalDelay";
    private static final String OPERATION_TRACEABILITY_MAX_RENEWALY_DElAY_UNIT = "operationTraceabilityMaxRenewalDelayUnit";
    private static final String LIFECYCLE_TRACEABILITY_MAX_RENEWALY_DElAY = "lifecycleTraceabilityMaxRenewalDelay";
    private static final String LIFECYCLE_TRACEABILITY_MAX_RENEWALY_DElAY_Unit = "lifecycleTraceabilityMaxRenewalDelayUnit";
    public static final String OP_TYPE = "STP_OP_SECURISATION";
    private Integer operationTraceabilityMaxRenewalDelay;
    private ChronoUnit operationTraceabilityMaxRenewalDelayUnit;
    private Integer lifecycleTraceabilityMaxRenewalDelay;
    private ChronoUnit lifecycleTraceabilityMaxRenewalDelayUnit;

    private void auditByTenantId(int tenantId, String logbookType, int amount, ChronoUnit unit) {
        try {
            VitamThreadUtils.getVitamSession().setTenantId(Integer.valueOf(tenantId));
            LogbookOperationsClientFactory logbookOperationsClientFactory = LogbookOperationsClientFactory.getInstance();
            AuditLogbookOptions options = new AuditLogbookOptions(amount, unit, logbookType);
            try (LogbookOperationsClient client = logbookOperationsClientFactory.getClient();){
                client.traceabilityAudit(tenantId, options);
            }
        }
        catch (LogbookClientServerException e) {
            LOGGER.error((Throwable)e);
            throw new IllegalStateException(" Error when securing Tenant  :  " + tenantId, e);
        }
        finally {
            VitamThreadUtils.getVitamSession().setTenantId(null);
        }
    }

    private void loadConfiguration(JobDataMap jobDataMap) {
        this.operationTraceabilityMaxRenewalDelay = jobDataMap.getInt(OPERATION_TRACEABILITY_MAX_RENEWALY_DElAY);
        this.operationTraceabilityMaxRenewalDelayUnit = ChronoUnit.valueOf(jobDataMap.getString(OPERATION_TRACEABILITY_MAX_RENEWALY_DElAY_UNIT));
        this.lifecycleTraceabilityMaxRenewalDelay = jobDataMap.getInt(LIFECYCLE_TRACEABILITY_MAX_RENEWALY_DElAY);
        this.lifecycleTraceabilityMaxRenewalDelayUnit = ChronoUnit.valueOf(jobDataMap.getString(LIFECYCLE_TRACEABILITY_MAX_RENEWALY_DElAY_Unit));
    }

    public void execute(JobExecutionContext context) throws JobExecutionException {
        LOGGER.info("Traceability audit operation in progress...");
        this.loadConfiguration(context.getJobDetail().getJobDataMap());
        VitamConfiguration.getTenants().forEach(tenant -> {
            this.auditByTenantId((int)tenant, OP_TYPE, this.operationTraceabilityMaxRenewalDelay, this.operationTraceabilityMaxRenewalDelayUnit);
            this.auditByTenantId((int)tenant, Contexts.UNIT_LFC_TRACEABILITY.getEventType(), this.lifecycleTraceabilityMaxRenewalDelay, this.lifecycleTraceabilityMaxRenewalDelayUnit);
            this.auditByTenantId((int)tenant, Contexts.OBJECTGROUP_LFC_TRACEABILITY.getEventType(), this.lifecycleTraceabilityMaxRenewalDelay, this.lifecycleTraceabilityMaxRenewalDelayUnit);
        });
        LOGGER.info("Traceability audit operation is finished");
    }
}

