/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.scheduler.server.job;

import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.guid.GUIDFactory;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import fr.gouv.vitam.metadata.api.exception.MetaDataClientServerException;
import fr.gouv.vitam.metadata.api.exception.MetaDataNotFoundException;
import fr.gouv.vitam.metadata.client.MetaDataClient;
import fr.gouv.vitam.metadata.client.MetaDataClientFactory;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

@DisallowConcurrentExecution
public class ProcessObsoleteComputedInheritedRulesJob
implements Job {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(ProcessObsoleteComputedInheritedRulesJob.class);
    private final MetaDataClientFactory metaDataClientFactory;

    public ProcessObsoleteComputedInheritedRulesJob() {
        this.metaDataClientFactory = MetaDataClientFactory.getInstance();
    }

    @VisibleForTesting
    public ProcessObsoleteComputedInheritedRulesJob(MetaDataClientFactory metaDataClientFactory) {
        this.metaDataClientFactory = metaDataClientFactory;
    }

    public void execute(JobExecutionContext context) throws JobExecutionException {
        Integer adminTenant = VitamConfiguration.getAdminTenant();
        VitamThreadUtils.getVitamSession().setTenantId(adminTenant);
        VitamThreadUtils.getVitamSession().setRequestId(GUIDFactory.newOperationLogbookGUID((int)adminTenant));
        try (MetaDataClient metaDataClient = this.metaDataClientFactory.getClient();){
            LOGGER.info("Process Obsolete Computed Inherited Rules Job in progress...");
            metaDataClient.processObsoleteComputedInheritedRules();
            LOGGER.info("End of process Obsolete Computed Inherited Rules Job");
        }
        catch (InvalidParseOperationException | MetaDataClientServerException | MetaDataNotFoundException e) {
            LOGGER.error(e);
            throw new JobExecutionException(e);
        }
    }
}

