/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.scheduler.server;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.server.application.resources.ApplicationStatusResource;
import fr.gouv.vitam.scheduler.server.SchedulerListener;
import fr.gouv.vitam.scheduler.server.model.VitamJobDetail;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BinaryOperator;
import java.util.stream.Collectors;
import org.apache.commons.lang3.SerializationUtils;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.impl.matchers.GroupMatcher;

@Path(value="/scheduler/v1")
public class SchedulerResource
extends ApplicationStatusResource {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(SchedulerResource.class);
    private static final String REG_EXP_SEPARATOR = "\\.";

    @GET
    @Path(value="/current-jobs")
    @Produces(value={"application/json"})
    public Response getCurrentJobs() throws SchedulerException {
        List jobs = SchedulerListener.getInstance().getScheduler().getCurrentlyExecutingJobs();
        List vitamJobs = jobs.stream().map(job -> new VitamJobDetail(job.getJobDetail())).collect(Collectors.toList());
        try {
            List jsonNodes = JsonHandler.toArrayList((ArrayNode)((ArrayNode)JsonHandler.toJsonNode(vitamJobs)));
            return Response.ok((Object)new RequestResponseOK().addAllResults(jsonNodes)).build();
        }
        catch (InvalidParseOperationException e) {
            LOGGER.error((Throwable)e);
            return Response.serverError().build();
        }
    }

    @GET
    @Path(value="/jobs")
    @Produces(value={"application/json"})
    public Response getJobs() throws SchedulerException {
        Scheduler scheduler = SchedulerListener.getInstance().getScheduler();
        Set jobKeys = scheduler.getJobKeys(GroupMatcher.anyGroup());
        ArrayList<VitamJobDetail> vitamJobs = new ArrayList<VitamJobDetail>();
        for (JobKey jobKey : jobKeys) {
            JobDetail jobDetail = scheduler.getJobDetail(jobKey);
            vitamJobs.add(new VitamJobDetail(jobDetail));
        }
        try {
            List jsonNodes = JsonHandler.toArrayList((ArrayNode)((ArrayNode)JsonHandler.toJsonNode(vitamJobs)));
            return Response.ok((Object)new RequestResponseOK().addAllResults(jsonNodes)).build();
        }
        catch (InvalidParseOperationException e) {
            LOGGER.error((Throwable)e);
            return Response.serverError().build();
        }
    }

    @PUT
    @Path(value="/pause/{group}")
    @Produces(value={"application/json"})
    public Response pauseScheduling(@PathParam(value="group") String group) throws SchedulerException {
        Scheduler scheduler = SchedulerListener.getInstance().getScheduler();
        if (group.equals("ALL")) {
            scheduler.pauseAll();
        } else {
            scheduler.pauseJobs(GroupMatcher.groupEquals((String)group));
            scheduler.pauseTriggers(GroupMatcher.groupEquals((String)group));
        }
        return Response.accepted().build();
    }

    @PUT
    @Path(value="/resume/{group}")
    @Produces(value={"application/json"})
    public Response resumeScheduling(@PathParam(value="group") String group) throws SchedulerException {
        Scheduler scheduler = SchedulerListener.getInstance().getScheduler();
        if (group.equals("ALL")) {
            scheduler.resumeAll();
        } else {
            scheduler.resumeJobs(GroupMatcher.groupEquals((String)group));
            scheduler.resumeTriggers(GroupMatcher.groupEquals((String)group));
        }
        return Response.accepted().build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/job-state/{job-name}")
    public Response jobState(@PathParam(value="job-name") String jobName) throws SchedulerException {
        String[] jobKeyPath;
        JobKey jobKey;
        Scheduler scheduler = SchedulerListener.getInstance().getScheduler();
        List triggers = scheduler.getTriggersOfJob(jobKey = (jobKeyPath = jobName.split(REG_EXP_SEPARATOR)).length > 1 ? JobKey.jobKey((String)jobKeyPath[1], (String)jobKeyPath[0]) : JobKey.jobKey((String)jobKeyPath[0]));
        Optional<Trigger.TriggerState> reduce = triggers.stream().filter(Objects::nonNull).map(Trigger::getKey).map(e -> {
            try {
                return scheduler.getTriggerState(e);
            }
            catch (SchedulerException ex) {
                throw new RuntimeException(ex);
            }
        }).reduce(BinaryOperator.maxBy(Enum::compareTo));
        if (reduce.isPresent()) {
            return Response.ok((Object)new RequestResponseOK().addResult((Object)reduce.get())).build();
        }
        return Response.ok((Object)new RequestResponseOK()).build();
    }

    @POST
    @Path(value="/schedule-job")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response scheduleJob(byte[] jobByte) throws SchedulerException {
        Scheduler scheduler = SchedulerListener.getInstance().getScheduler();
        JobDetail job = (JobDetail)SerializationUtils.deserialize((byte[])jobByte);
        if (job.isDurable()) {
            scheduler.addJob(job, true);
        } else {
            scheduler.addJob(job, true, true);
        }
        return Response.accepted().build();
    }

    @POST
    @Path(value="/trigger-job")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response triggerJob(byte[] triggerByte) throws SchedulerException {
        Scheduler scheduler = SchedulerListener.getInstance().getScheduler();
        Trigger trigger = (Trigger)SerializationUtils.deserialize((byte[])triggerByte);
        scheduler.scheduleJob(trigger);
        return Response.accepted().build();
    }

    @POST
    @Path(value="/trigger-job/{job-name}")
    @Produces(value={"application/json"})
    public Response triggerJob(@PathParam(value="job-name") String jobName, JsonNode jobDataJson) throws SchedulerException {
        try {
            JobKey jobKey;
            Scheduler scheduler = SchedulerListener.getInstance().getScheduler();
            String[] jobKeyPath = jobName.split(REG_EXP_SEPARATOR);
            JobKey jobKey2 = jobKey = jobKeyPath.length > 1 ? JobKey.jobKey((String)jobKeyPath[1], (String)jobKeyPath[0]) : JobKey.jobKey((String)jobKeyPath[0]);
            if (jobDataJson != null) {
                JobDataMap jobDataMap = (JobDataMap)JsonHandler.getFromJsonNode((JsonNode)jobDataJson, JobDataMap.class);
                scheduler.triggerJob(jobKey, jobDataMap);
            } else {
                scheduler.triggerJob(jobKey);
            }
            return Response.accepted().build();
        }
        catch (InvalidParseOperationException e) {
            LOGGER.error((Throwable)e);
            return Response.serverError().build();
        }
    }
}

