/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.collect.external.external.service;

import fr.gouv.vitam.collect.common.enums.TransactionStatus;
import fr.gouv.vitam.collect.external.external.exception.CollectExternalException;
import fr.gouv.vitam.collect.external.external.exception.CollectExternalInvalidRequestException;
import fr.gouv.vitam.collect.external.external.exception.CollectExternalNotFoundException;
import fr.gouv.vitam.collect.external.external.exception.CollectExternalServerSideException;
import fr.gouv.vitam.collect.internal.client.CollectInternalClient;
import fr.gouv.vitam.collect.internal.client.exceptions.CollectInternalClientInvalidRequestException;
import fr.gouv.vitam.collect.internal.client.exceptions.CollectInternalClientNotFoundException;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ProcessAction;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.parameter.ParameterHelper;
import fr.gouv.vitam.ingest.external.api.exception.IngestExternalException;
import fr.gouv.vitam.ingest.external.client.IngestExternalClient;
import fr.gouv.vitam.logbook.common.parameters.Contexts;
import java.io.IOException;
import java.io.InputStream;

public class CollectExternalIngestService {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(CollectExternalIngestService.class);

    public String ingestSip(CollectInternalClient collectInternalClient, IngestExternalClient ingestExternalClient, String transactionId) throws CollectExternalException {
        try {
            String ingestOperationId;
            LOGGER.info("Waiting for SIP availability for transaction '" + transactionId + "'");
            collectInternalClient.awaitTransactionValidation(transactionId);
            LOGGER.info("Uploading transaction SIP");
            collectInternalClient.changeTransactionStatus(transactionId, TransactionStatus.SENDING);
            try (InputStream sipInputStream = collectInternalClient.downloadSIP(transactionId);){
                RequestResponse response = ingestExternalClient.ingest(new VitamContext(ParameterHelper.getTenantParameter()), sipInputStream, Contexts.DEFAULT_WORKFLOW.name(), ProcessAction.RESUME.name());
                ingestOperationId = response.getHeaderString("X-Request-Id");
            }
            LOGGER.info("Ingest uploaded to Vitam with id: " + ingestOperationId);
            collectInternalClient.attachVitamOperationId(transactionId, ingestOperationId);
            collectInternalClient.changeTransactionStatus(transactionId, TransactionStatus.SENT);
            LOGGER.info("SIP sent with success ");
            return ingestOperationId;
        }
        catch (CollectInternalClientNotFoundException e) {
            throw new CollectExternalNotFoundException("Cannot ingest SIP transaction " + transactionId + ". Bad Request", e);
        }
        catch (CollectInternalClientInvalidRequestException e) {
            throw new CollectExternalInvalidRequestException("Cannot ingest SIP transaction " + transactionId + ". Bad Request", e);
        }
        catch (VitamClientException | IngestExternalException | IOException e) {
            throw new CollectExternalServerSideException("An error occurred during transaction upload", e);
        }
    }
}

