/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.collect.external.external.rest;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.collect.common.dto.TransactionDto;
import fr.gouv.vitam.collect.common.exception.CollectRequestResponse;
import fr.gouv.vitam.collect.external.external.exception.CollectExternalInvalidRequestException;
import fr.gouv.vitam.collect.external.external.exception.CollectExternalNotFoundException;
import fr.gouv.vitam.collect.external.external.rest.CollectExternalConfiguration;
import fr.gouv.vitam.collect.external.external.service.CollectExternalIngestService;
import fr.gouv.vitam.collect.internal.client.CollectInternalClient;
import fr.gouv.vitam.collect.internal.client.CollectInternalClientFactory;
import fr.gouv.vitam.collect.internal.client.exceptions.CollectInternalClientInvalidRequestException;
import fr.gouv.vitam.collect.internal.client.exceptions.CollectInternalClientNotFoundException;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.dsl.schema.Dsl;
import fr.gouv.vitam.common.dsl.schema.DslSchema;
import fr.gouv.vitam.common.dsl.schema.ValidationException;
import fr.gouv.vitam.common.dsl.schema.validator.BatchProcessingQuerySchemaValidator;
import fr.gouv.vitam.common.dsl.schema.validator.SelectMultipleSchemaValidator;
import fr.gouv.vitam.common.error.VitamCode;
import fr.gouv.vitam.common.error.VitamCodeHelper;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.elimination.DeletionRequestBody;
import fr.gouv.vitam.common.security.SanityChecker;
import fr.gouv.vitam.common.security.rest.Secured;
import fr.gouv.vitam.common.server.application.resources.ApplicationStatusResource;
import fr.gouv.vitam.ingest.external.client.IngestExternalClient;
import fr.gouv.vitam.ingest.external.client.IngestExternalClientFactory;
import fr.gouv.vitam.utils.SecurityProfilePermissions;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.Nullable;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Objects;

@Path(value="/collect-external/v1/transactions")
@Tag(name="Collect-External")
public class TransactionExternalResource
extends ApplicationStatusResource {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(TransactionExternalResource.class);
    private static final String PREDICATES_FAILED_EXCEPTION = "Predicates Failed Exception ";
    private static final String YOU_MUST_SUPPLY_TRANSACTION_DATA = "You must supply transaction data!";
    public static final String ERROR_WHEN_UPDATE_TRANSACTION__ = "Error when update transaction  ";
    private static final String UNAUTHORIZED_DSL_PARAMETER = "DSL parameter is unauthorized";
    private final CollectInternalClientFactory collectInternalClientFactory;
    private final IngestExternalClientFactory ingestExternalClientFactory;
    private final CollectExternalIngestService collectExternalIngestService;
    private final CollectExternalConfiguration configuration;

    TransactionExternalResource(CollectExternalConfiguration configuration) {
        this(CollectInternalClientFactory.getInstance(), IngestExternalClientFactory.getInstance(), new CollectExternalIngestService(), configuration);
    }

    @VisibleForTesting
    TransactionExternalResource(CollectInternalClientFactory collectInternalClientFactory, IngestExternalClientFactory ingestExternalClientFactory, CollectExternalIngestService collectExternalIngestService, CollectExternalConfiguration configuration) {
        this.collectInternalClientFactory = collectInternalClientFactory;
        this.ingestExternalClientFactory = ingestExternalClientFactory;
        this.collectExternalIngestService = collectExternalIngestService;
        this.configuration = configuration;
    }

    @Path(value="/{transactionId}")
    @GET
    @Produces(value={"application/json"})
    @Secured(permission=SecurityProfilePermissions.TRANSACTION_ID_READ, description="retourner la transaction par son id")
    public Response getTransactionById(@PathParam(value="transactionId") String transactionId) {
        Response response;
        block9: {
            CollectInternalClient client = this.collectInternalClientFactory.getClient();
            try {
                SanityChecker.checkParameter((String[])new String[]{transactionId});
                ParametersChecker.checkParameter((String)"You must supply a transaction id !", (String[])new String[]{transactionId});
                RequestResponse response2 = client.getTransactionById(transactionId);
                response = Response.status((Response.Status)Response.Status.OK).entity((Object)response2).build();
                if (client == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (VitamClientException e) {
                    LOGGER.error("Error when getting transaction  ", (Throwable)e);
                    return CollectRequestResponse.toVitamError((Response.Status)Response.Status.BAD_REQUEST, (String)e.getLocalizedMessage());
                }
                catch (InvalidParseOperationException e) {
                    LOGGER.error(PREDICATES_FAILED_EXCEPTION, (Throwable)e);
                    return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).build();
                }
            }
            client.close();
        }
        return response;
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Secured(permission=SecurityProfilePermissions.TRANSACTION_UPDATE, description="Mise \u00e0 jour d'une transaction")
    public Response updateTransaction(TransactionDto transactionDto) {
        Response response;
        block8: {
            CollectInternalClient client = this.collectInternalClientFactory.getClient();
            try {
                ParametersChecker.checkParameter((String)YOU_MUST_SUPPLY_TRANSACTION_DATA, (Object[])new Object[]{transactionDto});
                RequestResponse response2 = client.updateTransaction(transactionDto);
                response = Response.status((Response.Status)Response.Status.OK).entity((Object)response2).build();
                if (client == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (VitamClientException e) {
                    LOGGER.error(ERROR_WHEN_UPDATE_TRANSACTION__, (Throwable)e);
                    return CollectRequestResponse.toVitamError((Response.Status)Response.Status.BAD_REQUEST, (String)e.getLocalizedMessage());
                }
            }
            client.close();
        }
        return response;
    }

    @Path(value="/{transactionId}")
    @DELETE
    @Produces(value={"application/json"})
    @Secured(permission=SecurityProfilePermissions.TRANSACTION_ID_DELETE, description="Supprime une transaction par son id")
    public Response deleteTransactionById(@PathParam(value="transactionId") String transactionId) {
        Response response;
        block9: {
            CollectInternalClient client = this.collectInternalClientFactory.getClient();
            try {
                SanityChecker.checkParameter((String[])new String[]{transactionId});
                client.deleteTransactionById(transactionId);
                response = Response.status((Response.Status)Response.Status.OK).build();
                if (client == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (VitamClientException e) {
                    LOGGER.error("Error when delete transaction   ", (Throwable)e);
                    return CollectRequestResponse.toVitamError((Response.Status)Response.Status.BAD_REQUEST, (String)e.getLocalizedMessage());
                }
                catch (InvalidParseOperationException e) {
                    LOGGER.error(PREDICATES_FAILED_EXCEPTION, (Throwable)e);
                    return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).build();
                }
            }
            client.close();
        }
        return response;
    }

    @Path(value="/{transactionId}/units")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Secured(permission=SecurityProfilePermissions.TRANSACTION_UNIT_CREATE, description="Cr\u00e9e une unit\u00e9 archivistique et la rattache \u00e0 la transaction courante")
    public Response uploadArchiveUnit(@PathParam(value="transactionId") String transactionId, JsonNode unitJsonNode) {
        Response response;
        block9: {
            CollectInternalClient client = this.collectInternalClientFactory.getClient();
            try {
                SanityChecker.checkParameter((String[])new String[]{transactionId});
                SanityChecker.checkJsonAll((JsonNode)unitJsonNode);
                RequestResponseOK response2 = client.uploadArchiveUnit(unitJsonNode, transactionId);
                response = Response.status((Response.Status)Response.Status.OK).entity((Object)response2).build();
                if (client == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (VitamClientException e) {
                    LOGGER.error("Error when uploading unit   ", (Throwable)e);
                    return CollectRequestResponse.toVitamError((Response.Status)Response.Status.BAD_REQUEST, (String)e.getLocalizedMessage());
                }
                catch (InvalidParseOperationException e) {
                    LOGGER.error(PREDICATES_FAILED_EXCEPTION, (Throwable)e);
                    return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).build();
                }
            }
            client.close();
        }
        return response;
    }

    @Path(value="/{transactionId}/units")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Secured(permission=SecurityProfilePermissions.TRANSACTION_UNIT_READ, description="R\u00e9cup\u00e8re toutes les unit\u00e9s archivistique")
    public Response selectUnits(@PathParam(value="transactionId") String transactionId, @Dsl(value=DslSchema.SELECT_MULTIPLE) JsonNode jsonQuery) {
        Response response;
        block10: {
            CollectInternalClient client = this.collectInternalClientFactory.getClient();
            try {
                SanityChecker.checkParameter((String[])new String[]{transactionId});
                SanityChecker.checkJsonAll((JsonNode)jsonQuery);
                SelectMultipleSchemaValidator.checkAuthorizeTrackTotalHits((JsonNode)jsonQuery, (boolean)this.configuration.isAuthorizeTrackTotalHits());
                RequestResponseOK response2 = client.getUnitsByTransaction(transactionId, jsonQuery);
                response = Response.ok((Object)response2).build();
                if (client == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (VitamClientException e) {
                    LOGGER.error("Error when selecting units by transaction   ", (Throwable)e);
                    return CollectRequestResponse.toVitamError((Response.Status)Response.Status.BAD_REQUEST, (String)e.getLocalizedMessage());
                }
                catch (InvalidParseOperationException e) {
                    LOGGER.error(PREDICATES_FAILED_EXCEPTION, (Throwable)e);
                    return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).build();
                }
                catch (ValidationException e) {
                    LOGGER.error(UNAUTHORIZED_DSL_PARAMETER, (Throwable)e);
                    return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)VitamCodeHelper.toVitamError((VitamCode)VitamCode.COLLECT_EXTERNAL_SELECT_UNITS_ERROR, (String)e.getLocalizedMessage()).setHttpCode(Response.Status.UNAUTHORIZED.getStatusCode())).build();
                }
            }
            client.close();
        }
        return response;
    }

    @Path(value="/{transactionId}/close")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Secured(permission=SecurityProfilePermissions.TRANSACTION_CLOSE, description="Ferme une transaction")
    public Response closeTransaction(@PathParam(value="transactionId") String transactionId) {
        Response response;
        block9: {
            CollectInternalClient client = this.collectInternalClientFactory.getClient();
            try {
                SanityChecker.checkParameter((String[])new String[]{transactionId});
                client.closeTransaction(transactionId);
                response = Response.status((Response.Status)Response.Status.OK).build();
                if (client == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (VitamClientException e) {
                    LOGGER.error("Error when closing transaction   ", (Throwable)e);
                    return CollectRequestResponse.toVitamError((Response.Status)Response.Status.BAD_REQUEST, (String)e.getLocalizedMessage());
                }
                catch (InvalidParseOperationException e) {
                    LOGGER.error(PREDICATES_FAILED_EXCEPTION, (Throwable)e);
                    return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).build();
                }
            }
            client.close();
        }
        return response;
    }

    @Path(value="/{transactionId}/abort")
    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Secured(permission=SecurityProfilePermissions.TRANSACTION_ABORT, description="Abandonner une transaction")
    public Response abortTransaction(@PathParam(value="transactionId") String transactionId) {
        Response response;
        block9: {
            CollectInternalClient client = this.collectInternalClientFactory.getClient();
            try {
                SanityChecker.checkParameter((String[])new String[]{transactionId});
                client.abortTransaction(transactionId);
                response = Response.status((Response.Status)Response.Status.OK).build();
                if (client == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (VitamClientException e) {
                    LOGGER.error("Error when abort transaction   ", (Throwable)e);
                    return CollectRequestResponse.toVitamError((Response.Status)Response.Status.BAD_REQUEST, (String)e.getLocalizedMessage());
                }
                catch (InvalidParseOperationException e) {
                    LOGGER.error(PREDICATES_FAILED_EXCEPTION, (Throwable)e);
                    return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).build();
                }
            }
            client.close();
        }
        return response;
    }

    @Path(value="/{transactionId}/reopen")
    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Secured(permission=SecurityProfilePermissions.TRANSACTION_REOPEN, description="Rouvrir une transaction")
    public Response reopenTransaction(@PathParam(value="transactionId") String transactionId) {
        Response response;
        block9: {
            CollectInternalClient client = this.collectInternalClientFactory.getClient();
            try {
                SanityChecker.checkParameter((String[])new String[]{transactionId});
                client.reopenTransaction(transactionId);
                response = Response.status((Response.Status)Response.Status.OK).build();
                if (client == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (VitamClientException e) {
                    LOGGER.error("Error when reopen transaction   ", (Throwable)e);
                    return CollectRequestResponse.toVitamError((Response.Status)Response.Status.BAD_REQUEST, (String)e.getLocalizedMessage());
                }
                catch (InvalidParseOperationException e) {
                    LOGGER.error(PREDICATES_FAILED_EXCEPTION, (Throwable)e);
                    return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).build();
                }
            }
            client.close();
        }
        return response;
    }

    @Path(value="/{transactionId}/downloadSIP")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/octet-stream"})
    @Secured(permission=SecurityProfilePermissions.TRANSACTION_SIP_READ, description="T\u00e9l\u00e9charge le SIP d'une transaction")
    public Response downloadSIP(@PathParam(value="transactionId") String transactionId) {
        Response response;
        block10: {
            CollectInternalClient client = this.collectInternalClientFactory.getClient();
            try {
                SanityChecker.checkParameter((String[])new String[]{transactionId});
                InputStream responseStream = client.downloadSIP(transactionId);
                response = Response.status((Response.Status)Response.Status.OK).entity((Object)responseStream).build();
                if (client == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (CollectInternalClientNotFoundException e) {
                    LOGGER.error("Error when downloading transaction SIP - Not found", (Throwable)e);
                    return CollectRequestResponse.toVitamError((Response.Status)Response.Status.NOT_FOUND, (String)e.getLocalizedMessage());
                }
                catch (CollectInternalClientInvalidRequestException | InvalidParseOperationException e) {
                    LOGGER.error("Error when downloading transaction SIP - Bad request", e);
                    return CollectRequestResponse.toVitamError((Response.Status)Response.Status.BAD_REQUEST, (String)e.getLocalizedMessage());
                }
                catch (Exception e) {
                    LOGGER.error("Error when downloading transaction SIP - Internal Server Error", (Throwable)e);
                    return CollectRequestResponse.toVitamError((Response.Status)Response.Status.INTERNAL_SERVER_ERROR, (String)e.getLocalizedMessage());
                }
            }
            client.close();
        }
        return response;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Path(value="/{transactionId}/send")
    @POST
    @Consumes(value={"application/json"})
    @Secured(permission=SecurityProfilePermissions.TRANSACTION_SEND, description="Envoi vers VITAM la transaction")
    public Response sendSip(@PathParam(value="transactionId") String transactionId) {
        try (CollectInternalClient collectClient = this.collectInternalClientFactory.getClient();){
            Response response;
            block16: {
                IngestExternalClient clientIngest = this.ingestExternalClientFactory.getClient();
                try {
                    SanityChecker.checkParameter((String[])new String[]{transactionId});
                    this.collectExternalIngestService.ingestSip(collectClient, clientIngest, transactionId);
                    response = Response.ok().build();
                    if (clientIngest == null) break block16;
                }
                catch (Throwable throwable) {
                    if (clientIngest != null) {
                        try {
                            clientIngest.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                clientIngest.close();
            }
            return response;
        }
        catch (CollectExternalNotFoundException e) {
            LOGGER.error("Error while ingesting transaction SIP to Vitam - Not found", (Throwable)((Object)e));
            return CollectRequestResponse.toVitamError((Response.Status)Response.Status.NOT_FOUND, (String)e.getLocalizedMessage());
        }
        catch (CollectExternalInvalidRequestException | InvalidParseOperationException e) {
            LOGGER.error("Error while ingesting transaction SIP to Vitam - Bad request", (Throwable)e);
            return CollectRequestResponse.toVitamError((Response.Status)Response.Status.BAD_REQUEST, (String)e.getLocalizedMessage());
        }
        catch (Exception e) {
            LOGGER.error("Error while ingesting transaction SIP to Vitam - Internal Server Error", (Throwable)e);
            return CollectRequestResponse.toVitamError((Response.Status)Response.Status.INTERNAL_SERVER_ERROR, (String)e.getLocalizedMessage());
        }
    }

    @Path(value="/{transactionId}/units")
    @PUT
    @Consumes(value={"application/octet-stream"})
    @Produces(value={"application/json"})
    @Secured(permission=SecurityProfilePermissions.TRANSACTION_ID_UNITS_UPDATE, description="Mettre \u00e0 jour les unit\u00e9s archivistiques via fichier CSV de m\u00e9tadonn\u00e9es (d\u00e9pr\u00e9ci\u00e9)")
    @Deprecated(forRemoval=true, since="Vitam 7.1")
    public Response updateUnits(@PathParam(value="transactionId") String transactionId, InputStream inputStream) {
        LOGGER.warn("Deprecated API (/collect-external/v1/transactions/{transactionId}/units). Will be removed in next releases.");
        return this.updateUnitsWithMetadataCsv(transactionId, inputStream);
    }

    @Path(value="/{transactionId}/units/metadata/csv")
    @PUT
    @Consumes(value={"text/csv"})
    @Produces(value={"application/json"})
    @Secured(permission=SecurityProfilePermissions.TRANSACTION_ID_UNITS_METADATA_CSV_UPDATE, description="Mettre \u00e0 jour les unit\u00e9s archivistiques via fichier CSV de m\u00e9tadonn\u00e9es")
    public Response updateUnitsWithMetadataCsv(@PathParam(value="transactionId") String transactionId, InputStream metadataCsvInputStream) {
        Response response;
        block9: {
            CollectInternalClient client = this.collectInternalClientFactory.getClient();
            try {
                SanityChecker.checkParameter((String[])new String[]{transactionId});
                ParametersChecker.checkParameter((String)"You must supply a file!", (Object[])new Object[]{metadataCsvInputStream});
                RequestResponseOK response2 = client.updateUnitsWithCsvMetadata(transactionId, metadataCsvInputStream);
                response = Response.status((Response.Status)Response.Status.OK).entity((Object)response2).build();
                if (client == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (CollectInternalClientInvalidRequestException | InvalidParseOperationException | IllegalArgumentException e) {
                    LOGGER.error("Bad request: " + e.getLocalizedMessage(), e);
                    return CollectRequestResponse.toVitamError((Response.Status)Response.Status.BAD_REQUEST, (String)e.getLocalizedMessage());
                }
                catch (VitamClientException e) {
                    LOGGER.error("Error when updating units   ", (Throwable)e);
                    return CollectRequestResponse.toVitamError((Response.Status)Response.Status.INTERNAL_SERVER_ERROR, (String)e.getLocalizedMessage());
                }
            }
            client.close();
        }
        return response;
    }

    @Path(value="/{transactionId}/units/metadata/jsonl")
    @PUT
    @Consumes(value={"application/octet-stream"})
    @Produces(value={"application/json"})
    @Secured(permission=SecurityProfilePermissions.TRANSACTION_ID_UNITS_METADATA_JSONL_UPDATE, description="Mettre \u00e0 jour les unit\u00e9s archivistiques via fichier JSON-Lines de m\u00e9tadonn\u00e9es")
    public Response updateUnitsWithMetadataJsonl(@PathParam(value="transactionId") String transactionId, InputStream metadataJsonlInputStream) {
        Response response;
        block9: {
            CollectInternalClient client = this.collectInternalClientFactory.getClient();
            try {
                SanityChecker.checkParameter((String[])new String[]{transactionId});
                ParametersChecker.checkParameter((String)"You must supply a file!", (Object[])new Object[]{metadataJsonlInputStream});
                RequestResponse response2 = client.updateUnitsWithJsonlMetadata(transactionId, metadataJsonlInputStream);
                response = Response.status((Response.Status)Response.Status.OK).entity((Object)response2).build();
                if (client == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (CollectInternalClientInvalidRequestException | InvalidParseOperationException | IllegalArgumentException e) {
                    LOGGER.error("Bad request: " + e.getLocalizedMessage(), e);
                    return CollectRequestResponse.toVitamError((Response.Status)Response.Status.BAD_REQUEST, (String)e.getLocalizedMessage());
                }
                catch (VitamClientException e) {
                    LOGGER.error("Error when updating units   ", (Throwable)e);
                    return CollectRequestResponse.toVitamError((Response.Status)Response.Status.INTERNAL_SERVER_ERROR, (String)e.getLocalizedMessage());
                }
            }
            client.close();
        }
        return response;
    }

    @POST
    @Path(value="/{transactionId}/units/bulk")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Secured(permission=SecurityProfilePermissions.TRANSACTION_ID_UNITS_BULK_UPDATE, description="Mise \u00e0 jour par lot de requ\u00eates unitaires des unit\u00e9s archivistiques d'une transaction")
    public Response bulkAtomicUpdateUnits(@PathParam(value="transactionId") String transactionId, @Dsl(value=DslSchema.BULK_UPDATE) JsonNode updateQueriesJson) {
        Response response;
        block9: {
            CollectInternalClient client = this.collectInternalClientFactory.getClient();
            try {
                SanityChecker.checkParameter((String[])new String[]{transactionId});
                ParametersChecker.checkParameter((String)"Required query", (Object[])new Object[]{updateQueriesJson});
                SanityChecker.checkJsonAll((JsonNode)updateQueriesJson);
                RequestResponseOK response2 = client.bulkAtomicUpdateUnits(transactionId, updateQueriesJson);
                response = Response.accepted((Object)response2).build();
                if (client == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (CollectInternalClientInvalidRequestException | InvalidParseOperationException | IllegalArgumentException e) {
                    LOGGER.error("Bulk atomic update failed - Bad request", e);
                    return CollectRequestResponse.toVitamError((Response.Status)Response.Status.BAD_REQUEST, (String)e.getLocalizedMessage());
                }
                catch (Exception e) {
                    LOGGER.error("Bulk atomic update failed - Internal server error", (Throwable)e);
                    return CollectRequestResponse.toVitamError((Response.Status)Response.Status.INTERNAL_SERVER_ERROR, (String)e.getLocalizedMessage());
                }
            }
            client.close();
        }
        return response;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Path(value="/{transactionId}/upload")
    @POST
    @Consumes(value={"application/zip"})
    @Produces(value={"application/json"})
    @Secured(permission=SecurityProfilePermissions.TRANSACTION_ZIP_CREATE, description="Charge les binaires d'une transaction")
    public Response uploadTransactionZip(@PathParam(value="transactionId") String transactionId, InputStream inputStreamObject, @HeaderParam(value="X-Encoding") @Nullable String encoding, @HeaderParam(value="X-Attachement-Id") @Nullable String attachementId) {
        try (CollectInternalClient client = this.collectInternalClientFactory.getClient();){
            SanityChecker.checkParameter((String[])new String[]{transactionId});
            ParametersChecker.checkParameter((String)"You must supply a file!", (Object[])new Object[]{inputStreamObject});
            if (Objects.nonNull(encoding)) {
                SanityChecker.checkParameter((String[])new String[]{encoding});
                if (!Charset.isSupported(encoding)) {
                    Response response2 = CollectRequestResponse.toVitamError((Response.Status)Response.Status.BAD_REQUEST, (String)("Unsupported encoding " + encoding));
                    return response2;
                }
            }
            client.uploadZipToTransaction(transactionId, inputStreamObject, encoding, attachementId);
            Response response = Response.ok().build();
            return response;
        }
        catch (CollectInternalClientInvalidRequestException e) {
            LOGGER.error("Error when uploading transaction Zip - BAD REQUEST ", (Throwable)e);
            return CollectRequestResponse.toVitamError((Response.Status)Response.Status.BAD_REQUEST, (String)e.getLocalizedMessage());
        }
        catch (VitamClientException e) {
            LOGGER.error("Error when uploading transaction Zip   ", (Throwable)e);
            return CollectRequestResponse.toVitamError((Response.Status)Response.Status.INTERNAL_SERVER_ERROR, (String)e.getLocalizedMessage());
        }
        catch (InvalidParseOperationException e) {
            LOGGER.error(PREDICATES_FAILED_EXCEPTION, (Throwable)e);
            return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).build();
        }
    }

    @Path(value="/{transactionId}/unitsWithInheritedRules")
    @GET
    @Produces(value={"application/json"})
    @Secured(permission=SecurityProfilePermissions.TRANSACTION_UNIT_WITH_INHERITED_RULES_READ, description="R\u00e9cup\u00e9rer la liste des unit\u00e9s archivistiques avec leurs r\u00e8gles de gestion h\u00e9rit\u00e9es")
    public Response selectUnitsWithInheritedRules(@PathParam(value="transactionId") String transactionId, @Dsl(value=DslSchema.SELECT_MULTIPLE) JsonNode queryJson) {
        Response response;
        block9: {
            CollectInternalClient client = this.collectInternalClientFactory.getClient();
            try {
                SanityChecker.checkParameter((String[])new String[]{transactionId});
                RequestResponse result = client.selectUnitsWithInheritedRules(transactionId, queryJson);
                int st = result.isOk() ? Response.Status.OK.getStatusCode() : result.getHttpCode();
                response = Response.status((int)st).entity((Object)result).build();
                if (client == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (InvalidParseOperationException e) {
                    LOGGER.error(PREDICATES_FAILED_EXCEPTION, (Throwable)e);
                    return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).build();
                }
                catch (VitamClientException e) {
                    LOGGER.error("Error when selecting Units With Inherited Rules ", (Throwable)e);
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
                }
            }
            client.close();
        }
        return response;
    }

    @POST
    @Path(value="/{transactionId}/reclassification")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Secured(permission=SecurityProfilePermissions.TRANSACTION_RECLASSIFICATION, description="Reclassification d'unit\u00e9s archivistiques d'une transaction")
    public Response reclassification(@PathParam(value="transactionId") String transactionId, @Dsl(value=DslSchema.RECLASSIFICATION_QUERY) JsonNode queryJson) {
        Response response;
        block9: {
            CollectInternalClient client = this.collectInternalClientFactory.getClient();
            try {
                SanityChecker.checkParameter((String[])new String[]{transactionId});
                ParametersChecker.checkParameter((String)"Missing reclassification request", (Object[])new Object[]{queryJson});
                RequestResponse result = client.reclassification(transactionId, queryJson);
                int status = result.isOk() ? Response.Status.OK.getStatusCode() : result.getHttpCode();
                response = Response.status((int)status).entity((Object)result).build();
                if (client == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (InvalidParseOperationException e) {
                    LOGGER.error(PREDICATES_FAILED_EXCEPTION, (Throwable)e);
                    return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).build();
                }
                catch (VitamClientException e) {
                    LOGGER.error("Error when launching reclassification", (Throwable)e);
                    return CollectRequestResponse.toVitamError((Response.Status)Response.Status.BAD_REQUEST, (String)e.getLocalizedMessage());
                }
            }
            client.close();
        }
        return response;
    }

    @POST
    @Path(value="/{transactionId}/deletion/action")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Secured(permission=SecurityProfilePermissions.TRANSACTION_DELETION, description="Suppression d'unit\u00e9s archivistiques d'une transaction")
    public Response startDeletionAction(@PathParam(value="transactionId") String transactionId, DeletionRequestBody deletionRequestBody) {
        Response response;
        block9: {
            CollectInternalClient client = this.collectInternalClientFactory.getClient();
            try {
                SanityChecker.checkParameter((String[])new String[]{transactionId});
                ParametersChecker.checkParameter((String)"Missing dslRequest request", (Object[])new Object[]{deletionRequestBody.getDslRequest()});
                BatchProcessingQuerySchemaValidator validator = new BatchProcessingQuerySchemaValidator();
                validator.validate(deletionRequestBody.getDslRequest());
                RequestResponse response2 = client.startDeletion(transactionId, deletionRequestBody);
                int status = response2.isOk() ? Response.Status.OK.getStatusCode() : response2.getHttpCode();
                response = Response.status((int)status).entity((Object)response2).build();
                if (client == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (InvalidParseOperationException e) {
                    LOGGER.error(PREDICATES_FAILED_EXCEPTION, (Throwable)e);
                    return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).build();
                }
                catch (Exception e) {
                    LOGGER.error("Error when launching deletion", (Throwable)e);
                    return CollectRequestResponse.toVitamError((Response.Status)Response.Status.BAD_REQUEST, (String)e.getLocalizedMessage());
                }
            }
            client.close();
        }
        return response;
    }

    @Path(value="/{transactionId}/uploadSip")
    @POST
    @Consumes(value={"application/octet-stream"})
    @Produces(value={"application/json"})
    @Secured(permission=SecurityProfilePermissions.TRANSACTION_SIP_UPLOAD, description="Envoyer un SIP \u00e0 une transaction")
    public Response uploadSipToTransaction(@PathParam(value="transactionId") String transactionId, InputStream inputStream) {
        Response response;
        block11: {
            CollectInternalClient client = this.collectInternalClientFactory.getClient();
            try {
                SanityChecker.checkParameter((String[])new String[]{transactionId});
                ParametersChecker.checkParameter((String)"You must supply a file!", (Object[])new Object[]{inputStream});
                RequestResponse response2 = client.uploadSipToTransaction(transactionId, inputStream);
                response = Response.status((int)Response.Status.OK.getStatusCode()).entity((Object)response2).build();
                if (client == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (InvalidParseOperationException e) {
                    LOGGER.error(PREDICATES_FAILED_EXCEPTION, (Throwable)e);
                    return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).build();
                }
                catch (CollectInternalClientNotFoundException e) {
                    LOGGER.error("Error when uploading SIP to transaction - Not Found", (Throwable)e);
                    return CollectRequestResponse.toVitamError((Response.Status)Response.Status.NOT_FOUND, (String)e.getLocalizedMessage());
                }
                catch (CollectInternalClientInvalidRequestException e) {
                    LOGGER.error("Error when uploading SIP to transaction - BAD REQUEST ", (Throwable)e);
                    return CollectRequestResponse.toVitamError((Response.Status)Response.Status.BAD_REQUEST, (String)e.getLocalizedMessage());
                }
                catch (Exception e) {
                    LOGGER.error("Error when uploading SIP to transaction - Internal Server Error", (Throwable)e);
                    return CollectRequestResponse.toVitamError((Response.Status)Response.Status.INTERNAL_SERVER_ERROR, (String)e.getLocalizedMessage());
                }
            }
            client.close();
        }
        return response;
    }
}

