/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.collect.external.external.rest;

import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.collect.common.dto.ObjectDto;
import fr.gouv.vitam.collect.common.exception.CollectRequestResponse;
import fr.gouv.vitam.collect.internal.client.CollectInternalClient;
import fr.gouv.vitam.collect.internal.client.CollectInternalClientFactory;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.security.SanityChecker;
import fr.gouv.vitam.common.security.rest.Secured;
import fr.gouv.vitam.common.server.application.resources.ApplicationStatusResource;
import fr.gouv.vitam.utils.SecurityProfilePermissions;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.io.InputStream;

@Path(value="/collect-external/v1")
@Tag(name="Collect-External")
public class CollectMetadataExternalResource
extends ApplicationStatusResource {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(CollectMetadataExternalResource.class);
    private static final String PREDICATES_FAILED_EXCEPTION = "Predicates Failed Exception ";
    public static final String ERROR_WHEN_CREATING_AN_OBJECT_GROUP_UNIT_BY_ID = "Error when creating an object group unit by id    ";
    public static final String ERROR_WHEN_FETCHING_OBJECT_BY_IF = "Error when fetching object by if    ";
    private final CollectInternalClientFactory collectInternalClientFactory;

    CollectMetadataExternalResource() {
        this(CollectInternalClientFactory.getInstance());
    }

    @VisibleForTesting
    CollectMetadataExternalResource(CollectInternalClientFactory collectInternalClientFactory) {
        this.collectInternalClientFactory = collectInternalClientFactory;
    }

    @Path(value="/units/{unitId}")
    @GET
    @Produces(value={"application/json"})
    @Secured(permission=SecurityProfilePermissions.TRANSACTION_UNIT_ID_READ, description="R\u00e9cup\u00e8re une unit\u00e9 archivistique par ID")
    public Response getUnitById(@PathParam(value="unitId") String unitId) {
        Response response;
        block9: {
            CollectInternalClient client = this.collectInternalClientFactory.getClient();
            try {
                SanityChecker.checkParameter((String[])new String[]{unitId});
                RequestResponseOK response2 = client.getUnitById(unitId);
                response = Response.status((Response.Status)Response.Status.OK).entity((Object)response2).build();
                if (client == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (VitamClientException e) {
                    LOGGER.error("Error when fetching unit by id    ", (Throwable)e);
                    return CollectRequestResponse.toVitamError((Response.Status)Response.Status.BAD_REQUEST, (String)e.getLocalizedMessage());
                }
                catch (InvalidParseOperationException e) {
                    LOGGER.error(PREDICATES_FAILED_EXCEPTION, (Throwable)e);
                    return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).build();
                }
            }
            client.close();
        }
        return response;
    }

    @Path(value="/units/{unitId}/objects/{usage}/{version}")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Secured(permission=SecurityProfilePermissions.TRANSACTION_OBJECT_UPSERT, description="Upload un groupe d'objet")
    public Response createObjectGroup(@PathParam(value="unitId") String unitId, @PathParam(value="usage") String usageString, @PathParam(value="version") Integer version, ObjectDto objectDto) {
        Response response;
        block9: {
            CollectInternalClient client = this.collectInternalClientFactory.getClient();
            try {
                SanityChecker.checkParameter((String[])new String[]{unitId});
                SanityChecker.checkParameter((String[])new String[]{usageString});
                ParametersChecker.checkParameter((String)"You must supply object data !", (Object[])new Object[]{objectDto});
                RequestResponseOK response2 = client.addObjectGroup(unitId, version, JsonHandler.toJsonNode((Object)objectDto), usageString);
                response = Response.status((Response.Status)Response.Status.OK).entity((Object)response2).build();
                if (client == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (VitamClientException e) {
                    LOGGER.error(ERROR_WHEN_CREATING_AN_OBJECT_GROUP_UNIT_BY_ID, (Throwable)e);
                    return CollectRequestResponse.toVitamError((Response.Status)Response.Status.INTERNAL_SERVER_ERROR, (String)e.getLocalizedMessage());
                }
                catch (InvalidParseOperationException e) {
                    LOGGER.error(PREDICATES_FAILED_EXCEPTION, (Throwable)e);
                    return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).build();
                }
            }
            client.close();
        }
        return response;
    }

    @Path(value="/objects/{gotId}")
    @GET
    @Produces(value={"application/json"})
    @Secured(permission=SecurityProfilePermissions.TRANSACTION_OBJECT_READ, description="R\u00e9cup\u00e8re un groupe d'objet")
    public Response getObjectById(@PathParam(value="gotId") String gotId) {
        Response response;
        block9: {
            CollectInternalClient client = this.collectInternalClientFactory.getClient();
            try {
                SanityChecker.checkParameter((String[])new String[]{gotId});
                RequestResponseOK response2 = client.getObjectById(gotId);
                response = Response.status((Response.Status)Response.Status.OK).entity((Object)response2).build();
                if (client == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (VitamClientException e) {
                    LOGGER.error(ERROR_WHEN_FETCHING_OBJECT_BY_IF, (Throwable)e);
                    return CollectRequestResponse.toVitamError((Response.Status)Response.Status.BAD_REQUEST, (String)e.getLocalizedMessage());
                }
                catch (InvalidParseOperationException e) {
                    LOGGER.error(PREDICATES_FAILED_EXCEPTION, (Throwable)e);
                    return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).build();
                }
            }
            client.close();
        }
        return response;
    }

    @Path(value="/units/{unitId}/objects/{usage}/{version}/binary")
    @POST
    @Consumes(value={"application/octet-stream"})
    @Produces(value={"application/json"})
    @Secured(permission=SecurityProfilePermissions.TRANSACTION_BINARY_UPSERT, description="Cr\u00e9e ou met \u00e0 jour un binaire d'un usage/version")
    public Response upload(@PathParam(value="unitId") String unitId, @PathParam(value="usage") String usageString, @PathParam(value="version") Integer version, InputStream uploadedInputStream) {
        Response response;
        block9: {
            CollectInternalClient client = this.collectInternalClientFactory.getClient();
            try {
                SanityChecker.checkParameter((String[])new String[]{unitId});
                SanityChecker.checkParameter((String[])new String[]{usageString});
                SanityChecker.checkParameter((String[])new String[]{String.valueOf(version)});
                ParametersChecker.checkParameter((String)"usage({}), unitId({}) or version({}) can't be null", (Object[])new Object[]{unitId, usageString, version});
                ParametersChecker.checkParameter((String)"You must supply a file!", (Object[])new Object[]{uploadedInputStream});
                RequestResponse requestResponse = client.addBinary(unitId, version, uploadedInputStream, usageString);
                response = Response.status((Response.Status)Response.Status.OK).entity((Object)requestResponse).build();
                if (client == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (VitamClientException e) {
                    LOGGER.error("Error when adding binary    ", (Throwable)e);
                    return CollectRequestResponse.toVitamError((Response.Status)Response.Status.INTERNAL_SERVER_ERROR, (String)e.getLocalizedMessage());
                }
                catch (InvalidParseOperationException e) {
                    LOGGER.error(PREDICATES_FAILED_EXCEPTION, (Throwable)e);
                    return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).build();
                }
            }
            client.close();
        }
        return response;
    }

    @Path(value="/units/{unitId}/objects/{usage}/{version}/binary")
    @GET
    @Produces(value={"application/octet-stream"})
    @Secured(permission=SecurityProfilePermissions.TRANSACTION_BINARY_READ, description="T\u00e9l\u00e9charge un usage/version du binaire d'un groupe d'objets")
    public Response download(@PathParam(value="unitId") String unitId, @PathParam(value="usage") String usageString, @PathParam(value="version") Integer version) {
        Response response;
        block9: {
            CollectInternalClient client = this.collectInternalClientFactory.getClient();
            try {
                SanityChecker.checkParameter((String[])new String[]{unitId});
                SanityChecker.checkParameter((String[])new String[]{usageString});
                SanityChecker.checkParameter((String[])new String[]{String.valueOf(version)});
                ParametersChecker.checkParameter((String)"usage({}), unitId({}) or version({}) can't be null", (Object[])new Object[]{unitId, usageString, version});
                response = client.getObjectStreamByUnitId(unitId, usageString, version.intValue());
                if (client == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (VitamClientException e) {
                    LOGGER.error("Error when downloading object ", (Throwable)e);
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
                }
                catch (InvalidParseOperationException e) {
                    LOGGER.error(PREDICATES_FAILED_EXCEPTION, (Throwable)e);
                    return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).build();
                }
            }
            client.close();
        }
        return response;
    }
}

