/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.collect.external.external.rest;

import com.google.common.base.Throwables;
import fr.gouv.vitam.collect.external.external.rest.AutomaticIngestThread;
import fr.gouv.vitam.collect.external.external.rest.CollectExternalConfiguration;
import fr.gouv.vitam.collect.external.external.rest.CollectExternalResource;
import fr.gouv.vitam.collect.external.external.rest.CollectMetadataExternalResource;
import fr.gouv.vitam.collect.external.external.rest.ProjectExternalResource;
import fr.gouv.vitam.collect.external.external.rest.TransactionExternalResource;
import fr.gouv.vitam.common.PropertiesUtils;
import fr.gouv.vitam.common.dsl.schema.DslDynamicFeature;
import fr.gouv.vitam.common.security.rest.SecureEndpointRegistry;
import fr.gouv.vitam.common.security.rest.SecureEndpointScanner;
import fr.gouv.vitam.common.security.waf.SanityCheckerCommonFilter;
import fr.gouv.vitam.common.security.waf.SanityDynamicFeature;
import fr.gouv.vitam.common.server.application.GenericBusinessApplication;
import fr.gouv.vitam.common.serverv2.application.CommonBusinessApplication;
import fr.gouv.vitam.security.internal.filter.AuthorizationFilter;
import fr.gouv.vitam.security.internal.filter.InternalSecurityFilter;
import jakarta.servlet.ServletConfig;
import jakarta.ws.rs.core.Context;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;

public class BusinessApplication
extends GenericBusinessApplication {
    private final Set<Object> singletons;
    private final CommonBusinessApplication commonBusinessApplication;

    public BusinessApplication(@Context ServletConfig servletConfig) {
        String configurationFile = servletConfig.getInitParameter("vitam.configurationFile");
        this.singletons = new HashSet<Object>();
        SecureEndpointRegistry secureEndpointRegistry = new SecureEndpointRegistry();
        SecureEndpointScanner secureEndpointScanner = new SecureEndpointScanner(secureEndpointRegistry);
        try (InputStream yamlIS = PropertiesUtils.getConfigAsStream((String)configurationFile);){
            CollectExternalConfiguration configuration = (CollectExternalConfiguration)((Object)PropertiesUtils.readYaml((InputStream)yamlIS, CollectExternalConfiguration.class));
            this.commonBusinessApplication = new CommonBusinessApplication(true);
            CollectExternalResource collectExternalResource = new CollectExternalResource(secureEndpointRegistry);
            CollectMetadataExternalResource collectMetadataExternalResource = new CollectMetadataExternalResource();
            ProjectExternalResource projectExternalResource = new ProjectExternalResource();
            TransactionExternalResource transactionExternalResource = new TransactionExternalResource(configuration);
            new AutomaticIngestThread(configuration);
            this.singletons.add(new InternalSecurityFilter(configuration.isAllowSslClientHeader()));
            this.singletons.add(new AuthorizationFilter());
            this.singletons.addAll(this.commonBusinessApplication.getResources());
            this.singletons.add((Object)collectExternalResource);
            this.singletons.add((Object)projectExternalResource);
            this.singletons.add((Object)collectMetadataExternalResource);
            this.singletons.add((Object)transactionExternalResource);
            this.singletons.add(new SanityCheckerCommonFilter());
            this.singletons.add(new DslDynamicFeature());
            this.singletons.add(new SanityDynamicFeature());
            this.singletons.add(secureEndpointScanner);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public Set<Object> getSingletons() {
        return this.singletons;
    }
}

