/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.collect.external.external.rest;

import fr.gouv.vitam.collect.external.external.exception.CollectExternalException;
import fr.gouv.vitam.collect.external.external.rest.CollectExternalConfiguration;
import fr.gouv.vitam.collect.external.external.service.CollectExternalIngestService;
import fr.gouv.vitam.collect.internal.client.CollectInternalClient;
import fr.gouv.vitam.collect.internal.client.CollectInternalClientFactory;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.guid.GUIDFactory;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.thread.ExecutorUtils;
import fr.gouv.vitam.common.thread.VitamThreadFactory;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import fr.gouv.vitam.ingest.external.client.IngestExternalClient;
import fr.gouv.vitam.ingest.external.client.IngestExternalClientFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public class AutomaticIngestThread
implements Runnable {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(AutomaticIngestThread.class);
    private static final int INITIAL_DELAY = 5;
    private final CollectInternalClientFactory collectInternalClientFactory = CollectInternalClientFactory.getInstance();
    private final int threadPoolSize;
    private final CollectExternalIngestService collectExternalIngestService;

    public AutomaticIngestThread(CollectExternalConfiguration collectExternalConfiguration) {
        this.threadPoolSize = collectExternalConfiguration.getIngestionThreadPoolSize();
        this.collectExternalIngestService = new CollectExternalIngestService();
        long delay = collectExternalConfiguration.getIngestionThreadFrequencySeconds();
        Executors.newScheduledThreadPool(1, (ThreadFactory)VitamThreadFactory.getInstance()).scheduleAtFixedRate(this, Math.min(5L, delay), delay, TimeUnit.SECONDS);
    }

    @Override
    public void run() {
        try {
            this.process();
        }
        catch (Exception e) {
            LOGGER.error("Error when executing threads:", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process() throws VitamClientException {
        Thread.currentThread().setName(AutomaticIngestThread.class.getName());
        VitamThreadUtils.getVitamSession().setRequestId(GUIDFactory.newRequestIdGUID((int)VitamConfiguration.getAdminTenant()));
        ThreadPoolExecutor executorService = ExecutorUtils.createScalableBatchExecutorService((int)this.threadPoolSize);
        try (CollectInternalClient client = this.collectInternalClientFactory.getClient();){
            RequestResponse requestResponse = client.getTransactionsToAutomaticallyIngest();
            List results = ((RequestResponseOK)requestResponse).getResults();
            if (results.isEmpty()) {
                return;
            }
            Map<String, Integer> transactionsModel = results.stream().collect(Collectors.toMap(transactionNode -> transactionNode.get("#id").asText(), transactionNode -> Integer.parseInt(transactionNode.get("#tenant").asText())));
            ArrayList<CompletableFuture<Void>> completableFuturesList = new ArrayList<CompletableFuture<Void>>();
            for (Map.Entry<String, Integer> transaction : transactionsModel.entrySet()) {
                CompletableFuture<Void> completableFuture = CompletableFuture.runAsync(() -> {
                    String transactionId = (String)transaction.getKey();
                    int tenantId = (Integer)transaction.getValue();
                    Thread.currentThread().setName(AutomaticIngestThread.class.getName() + "-" + transactionId);
                    VitamThreadUtils.getVitamSession().setTenantId(Integer.valueOf(tenantId));
                    try {
                        this.sendSip(transactionId, tenantId);
                    }
                    catch (Exception e) {
                        LOGGER.error("Error when sending automatic transaction " + transactionId, (Throwable)e);
                    }
                }, executorService);
                completableFuturesList.add(completableFuture);
            }
            CompletableFuture<Void> combinedFuture = CompletableFuture.allOf(completableFuturesList.toArray(new CompletableFuture[0]));
            combinedFuture.join();
        }
        finally {
            executorService.shutdown();
        }
    }

    private void sendSip(String transactionId, Integer tenantId) throws CollectExternalException {
        try (CollectInternalClient client = CollectInternalClientFactory.getInstance().getClient();
             IngestExternalClient ingestExternalClient = IngestExternalClientFactory.getInstance().getClient();){
            LOGGER.info("Sending SIP for transaction " + transactionId + " for tenant " + tenantId);
            String ingestOperationId = this.collectExternalIngestService.ingestSip(client, ingestExternalClient, transactionId);
            LOGGER.info("SIP sent successfully with id " + ingestOperationId);
        }
    }
}

