/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.ingest.internal.client;

import fr.gouv.vitam.common.PropertiesUtils;
import fr.gouv.vitam.common.client.VitamClientFactory;
import fr.gouv.vitam.common.client.VitamClientFactoryInterface;
import fr.gouv.vitam.common.client.configuration.ClientConfiguration;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.processing.WorkFlowExecutionContext;
import fr.gouv.vitam.ingest.internal.client.IngestInternalClient;
import fr.gouv.vitam.ingest.internal.client.IngestInternalClientConfiguration;
import fr.gouv.vitam.ingest.internal.client.IngestInternalClientMock;
import fr.gouv.vitam.ingest.internal.client.IngestInternalClientRest;
import java.io.File;
import java.io.IOException;

public class IngestInternalClientFactory
extends VitamClientFactory<IngestInternalClient> {
    private static final String CONFIGURATION_FILENAME = "ingest-internal-client.conf";
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(IngestInternalClientFactory.class);
    private static final IngestInternalClientFactory INGEST_INTERNAL_CLIENT_FACTORY = new IngestInternalClientFactory();
    private static final String RESOURCE_PATH = "/ingest/v1";

    private IngestInternalClientFactory() {
        super((ClientConfiguration)IngestInternalClientFactory.changeConfigurationFile(CONFIGURATION_FILENAME), RESOURCE_PATH);
    }

    public static final IngestInternalClientFactory getInstance() {
        return IngestInternalClientFactory.getInstance(WorkFlowExecutionContext.VITAM);
    }

    public static IngestInternalClientFactory getInstance(WorkFlowExecutionContext executionContext) {
        switch (executionContext) {
            default: {
                throw new MatchException(null, null);
            }
            case VITAM: {
                break;
            }
            case COLLECT: {
                throw new IllegalStateException("call not allowed from Collect to Ingest internal ");
            }
        }
        return INGEST_INTERNAL_CLIENT_FACTORY;
    }

    public IngestInternalClient getClient() {
        return switch (this.getVitamClientType()) {
            default -> throw new MatchException(null, null);
            case VitamClientFactoryInterface.VitamClientType.MOCK -> new IngestInternalClientMock();
            case VitamClientFactoryInterface.VitamClientType.PRODUCTION -> new IngestInternalClientRest(this);
        };
    }

    static final IngestInternalClientConfiguration changeConfigurationFile(String configurationPath) {
        IngestInternalClientConfiguration configuration = null;
        try {
            configuration = (IngestInternalClientConfiguration)((Object)PropertiesUtils.readYaml((File)PropertiesUtils.findFile((String)configurationPath), IngestInternalClientConfiguration.class));
        }
        catch (IOException fnf) {
            LOGGER.debug("Error when retrieving configuration file {}, using mock", (Object)CONFIGURATION_FILENAME, (Object)fnf);
        }
        if (configuration == null) {
            LOGGER.error("Error when retrieving configuration file {}, using mock", (Object)CONFIGURATION_FILENAME);
        }
        return configuration;
    }

    static final void changeMode(IngestInternalClientConfiguration configuration) {
        IngestInternalClientFactory.getInstance().initialisation((ClientConfiguration)configuration, IngestInternalClientFactory.getInstance().getResourcePath());
    }
}

