/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.metadata.rest;

import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.exception.DatabaseException;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.parameter.ParameterHelper;
import fr.gouv.vitam.metadata.api.model.PersistentIdentifierReconstructionRequest;
import fr.gouv.vitam.metadata.core.config.MetaDataConfiguration;
import fr.gouv.vitam.metadata.core.reconstruction.domain.OffsetManager;
import fr.gouv.vitam.metadata.core.reconstruction.domain.PersistentIdentifierReconstructionManager;
import fr.gouv.vitam.metadata.core.reconstruction.repository.PersistentIdentifierRepository;
import fr.gouv.vitam.metadata.core.reconstruction.repository.ReconstructionResponse;
import fr.gouv.vitam.metadata.core.reconstruction.service.PersistentIdentifierReconstructionService;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.Nullable;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.util.List;

@Path(value="/v1")
@Tag(name="Metadata")
public class PersistentIdentifierResource {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(PersistentIdentifierResource.class);
    private static final String PERSISTENT_IDENTIFIER_RECONSTRUCTION_URI = "/reconstruction-persistent-identifier";
    private static final String PERSISTENT_IDENTIFIER_URI = "/persistentIdentifier";
    private static final String PERSISTENT_IDENTIFIER_RECONSTRUCTION_JSON_MANDATORY_PARAMETERS_MSG = "the Json input of persistent identifier reconstruction's parameters is mandatory.";
    private final PersistentIdentifierReconstructionService persistentIdentifierReconstructionService;
    private final PersistentIdentifierRepository persistentIdentifierRepository;

    PersistentIdentifierResource(PersistentIdentifierReconstructionManager persistentIdentifierReconstructionManager, OffsetManager offsetManager, MetaDataConfiguration metaDataConfiguration, PersistentIdentifierRepository persistentIdentifierRepository) {
        this.persistentIdentifierRepository = persistentIdentifierRepository;
        this.persistentIdentifierReconstructionService = new PersistentIdentifierReconstructionService(offsetManager, persistentIdentifierReconstructionManager, metaDataConfiguration);
    }

    @Path(value="/reconstruction-persistent-identifier")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response reconstructPersistentIdentifiers(PersistentIdentifierReconstructionRequest requestItem) {
        ReconstructionResponse reconstructionResponse;
        ParametersChecker.checkParameter((String)PERSISTENT_IDENTIFIER_RECONSTRUCTION_JSON_MANDATORY_PARAMETERS_MSG, (Object[])new Object[]{requestItem});
        LOGGER.debug(String.format("Starting reconstruction Vitam service with the json parameters : (%s)", requestItem));
        try {
            reconstructionResponse = this.persistentIdentifierReconstructionService.reconstruct(requestItem);
        }
        catch (IllegalArgumentException e) {
            LOGGER.error("Persistent identifier reconstruction failed", (Throwable)e);
            reconstructionResponse = new ReconstructionResponse.Builder().status(ReconstructionResponse.ReconstructionStatus.FAILURE).build();
        }
        switch (reconstructionResponse.status) {
            case SUCCESS: {
                return Response.ok((Object)new RequestResponseOK().addResult((Object)reconstructionResponse)).build();
            }
        }
        return Response.serverError().entity((Object)new RequestResponseOK().addResult((Object)reconstructionResponse)).build();
    }

    @Path(value="/purgedPersistentIdentifier/{persistentIdentifier:.+}")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getPersistentIdentifiers(@PathParam(value="persistentIdentifier") String persistentIdentifier, @QueryParam(value="type") @Nullable String type) {
        ParametersChecker.checkParameter((String)PERSISTENT_IDENTIFIER_RECONSTRUCTION_JSON_MANDATORY_PARAMETERS_MSG, (String[])new String[]{persistentIdentifier});
        Integer tenant = ParameterHelper.getTenantParameter();
        try {
            List purgedPersistentIdentifiers = this.persistentIdentifierRepository.findByPersistentIdentifierAndTenant(persistentIdentifier, tenant, type);
            return Response.ok().entity((Object)purgedPersistentIdentifiers).build();
        }
        catch (DatabaseException e) {
            LOGGER.error("Internal Server error : cannot retrieve persistent identifiers > persistent identifier : {}, tenant {} ", (Object)persistentIdentifier, (Object)tenant);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }
}

