/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.metadata.rest;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.common.database.api.VitamRepositoryProvider;
import fr.gouv.vitam.common.error.VitamCode;
import fr.gouv.vitam.common.error.VitamCodeHelper;
import fr.gouv.vitam.common.exception.DatabaseException;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.parameter.ParameterHelper;
import fr.gouv.vitam.metadata.api.exception.MetaDataNotFoundException;
import fr.gouv.vitam.metadata.core.database.collections.MetadataCollections;
import fr.gouv.vitam.metadata.core.database.collections.MetadataRepositoryService;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.Collection;
import java.util.List;

@Path(value="/v1")
@Tag(name="Metadata")
public class MetadataRawResource {
    private MetadataRepositoryService metadataRepositoryService;

    public MetadataRawResource(VitamRepositoryProvider vitamRepositoryProvider) {
        this.metadataRepositoryService = new MetadataRepositoryService(vitamRepositoryProvider);
    }

    @Path(value="/raw/units/{id_unit}")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getUnitById(@PathParam(value="id_unit") String unitId) {
        return this.getById(MetadataCollections.UNIT, unitId);
    }

    @Path(value="/raw/objectgroups/{id_og}")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getObjectGroupById(@PathParam(value="id_og") String objectGroupId) {
        return this.getById(MetadataCollections.OBJECTGROUP, objectGroupId);
    }

    private Response getById(MetadataCollections collection, String id) {
        try {
            Integer tenant = ParameterHelper.getTenantParameter();
            JsonNode document = this.metadataRepositoryService.getDocumentById(collection, id, tenant);
            RequestResponseOK responseOK = new RequestResponseOK().addResult((Object)document).setHttpCode(Response.Status.OK.getStatusCode());
            return Response.status((Response.Status)Response.Status.OK).entity((Object)responseOK).build();
        }
        catch (MetaDataNotFoundException e) {
            return VitamCodeHelper.toVitamError((VitamCode)VitamCode.METADATA_NOT_FOUND, (String)String.format("Could not find document of type %s", collection.getName())).toResponse();
        }
        catch (DatabaseException e) {
            return VitamCodeHelper.toVitamError((VitamCode)VitamCode.METADATA_REPOSITORY_DATABASE_ERROR, (String)String.format("Technical error while trying to find document of type %s", collection.getName())).toResponse();
        }
        catch (InvalidParseOperationException e) {
            return VitamCodeHelper.toVitamError((VitamCode)VitamCode.METADATA_REPOSITORY_DATABASE_ERROR, (String)String.format("Technical error while trying to parse document of type %s", collection.getName())).toResponse();
        }
    }

    @Path(value="/raw/units")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getBulkRawUnitByIds(JsonNode body) {
        return this.getByIds(MetadataCollections.UNIT, body);
    }

    @Path(value="/raw/objectgroups")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getBulkRawObjectGroupsByIds(JsonNode body) {
        return this.getByIds(MetadataCollections.OBJECTGROUP, body);
    }

    private Response getByIds(MetadataCollections collection, JsonNode idsJson) {
        try {
            Integer tenant = ParameterHelper.getTenantParameter();
            List ids = (List)JsonHandler.getFromJsonNode((JsonNode)idsJson, List.class);
            List documents = this.metadataRepositoryService.getDocumentsByIds(collection, (Collection)ids, tenant);
            RequestResponseOK responseOK = new RequestResponseOK().addAllResults(documents).setHttpCode(Response.Status.OK.getStatusCode());
            return Response.status((Response.Status)Response.Status.OK).entity((Object)responseOK).build();
        }
        catch (InvalidParseOperationException e) {
            return VitamCodeHelper.toVitamError((VitamCode)VitamCode.METADATA_REPOSITORY_DATABASE_ERROR, (String)String.format("Technical error while trying to parse document of type %s", collection.getName())).toResponse();
        }
    }
}

