/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.metadata.rest;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.database.api.VitamRepositoryProvider;
import fr.gouv.vitam.common.database.builder.query.BooleanQuery;
import fr.gouv.vitam.common.database.builder.query.Query;
import fr.gouv.vitam.common.database.builder.query.QueryHelper;
import fr.gouv.vitam.common.database.builder.query.VitamFieldsHelper;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.multiple.SelectMultiQuery;
import fr.gouv.vitam.common.error.ServiceName;
import fr.gouv.vitam.common.error.VitamCode;
import fr.gouv.vitam.common.error.VitamCodeHelper;
import fr.gouv.vitam.common.error.VitamError;
import fr.gouv.vitam.common.guid.GUIDFactory;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.AuthenticationLevel;
import fr.gouv.vitam.common.model.GraphComputeResponse;
import fr.gouv.vitam.common.model.RequestResponseError;
import fr.gouv.vitam.common.model.processing.WorkFlowExecutionContext;
import fr.gouv.vitam.common.security.rest.VitamAuthentication;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import fr.gouv.vitam.logbook.operations.client.LogbookOperationsClientFactory;
import fr.gouv.vitam.metadata.api.model.ReclassificationChildNodeExportRequest;
import fr.gouv.vitam.metadata.core.ExportsPurge.ExportsPurgeService;
import fr.gouv.vitam.metadata.core.MetaDataImpl;
import fr.gouv.vitam.metadata.core.config.ElasticsearchMetadataIndexManager;
import fr.gouv.vitam.metadata.core.config.MetaDataConfiguration;
import fr.gouv.vitam.metadata.core.database.collections.MetadataCollections;
import fr.gouv.vitam.metadata.core.graph.GraphComputeServiceImpl;
import fr.gouv.vitam.metadata.core.graph.ReclassificationDistributionService;
import fr.gouv.vitam.metadata.core.graph.api.GraphComputeService;
import fr.gouv.vitam.processing.management.client.ProcessingManagementClientFactory;
import fr.gouv.vitam.workspace.client.WorkspaceClientFactory;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.Iterator;
import java.util.Set;

@Path(value="/v1")
@Tag(name="Metadata")
public class MetadataManagementResource {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(MetadataManagementResource.class);
    public static final String OBJECTGROUP = "OBJECTGROUP";
    public static final String UNIT = "UNIT";
    private static final String CODE_VITAM = "code_vitam";
    private static final String UNIT_OBJECTGROUP = "UNIT_OBJECTGROUP";
    private static final String EXPORT_RECLASSIFICATION_CHILD_NODES = "exportReclassificationChildNodes";
    private static final String COMPUTE_GRAPH_URI = "/computegraph";
    private static final String COMPUTE_GRAPH_PROGRESS_URI = "/computegraph/progress";
    private static final String COMPUTED_INHERITED_RULES_OBSOLETE_URI = "/units/computedInheritedRules/processObsoletes";
    private static final String PURGE_EXPIRED_DIP_FILES_URI = "/purgeDIP";
    private static final String PURGE_EXPIRED_TRANSFER_SIP_FILES_URI = "/purgeTransfersSIP";
    private static final String MIGRATION_PURGE_EXPIRED_FROM_OFFERS = "/migrationDeleteDipFromOffers";
    private static final String COMPUTE_GRAPH_EXCEPTION_MSG = "ERROR: Exception has been thrown when compute graph: ";
    private static final String ERROR_MSG = "{\"ErrorMsg\":\"";
    private final GraphComputeService graphComputeService;
    private final ReclassificationDistributionService reclassificationDistributionService;
    private final ProcessingManagementClientFactory processingManagementClientFactory;
    private final LogbookOperationsClientFactory logbookOperationsClientFactory;
    private final WorkspaceClientFactory workspaceClientFactory;
    private final ExportsPurgeService exportsPurgeService;

    MetadataManagementResource(VitamRepositoryProvider vitamRepositoryProvider, MetaDataImpl metadata, MetaDataConfiguration configuration, ElasticsearchMetadataIndexManager indexManager) {
        this(GraphComputeServiceImpl.initialize((VitamRepositoryProvider)vitamRepositoryProvider, (MetaDataImpl)metadata, (ElasticsearchMetadataIndexManager)indexManager), new ReclassificationDistributionService(metadata), ProcessingManagementClientFactory.getInstance(), LogbookOperationsClientFactory.getInstance(), WorkspaceClientFactory.getInstance((WorkFlowExecutionContext)WorkFlowExecutionContext.VITAM), configuration, new ExportsPurgeService(configuration.getTimeToLiveConfiguration()));
    }

    @VisibleForTesting
    MetadataManagementResource(GraphComputeService graphComputeService, ReclassificationDistributionService reclassificationDistributionService, ProcessingManagementClientFactory processingManagementClientFactory, LogbookOperationsClientFactory logbookOperationsClientFactory, WorkspaceClientFactory workspaceClientFactory, MetaDataConfiguration configuration, ExportsPurgeService exportsPurgeService) {
        this.graphComputeService = graphComputeService;
        this.reclassificationDistributionService = reclassificationDistributionService;
        this.processingManagementClientFactory = processingManagementClientFactory;
        this.logbookOperationsClientFactory = logbookOperationsClientFactory;
        this.workspaceClientFactory = workspaceClientFactory;
        this.exportsPurgeService = exportsPurgeService;
        ProcessingManagementClientFactory.changeConfigurationUrl((String)configuration.getUrlProcessing());
    }

    @Path(value="/computegraph")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @VitamAuthentication(authentLevel=AuthenticationLevel.BASIC_AUTHENT)
    public Response computeGraphByDSL(@HeaderParam(value="X-Tenant-Id") Integer xTenantId, JsonNode queryDsl) {
        try {
            ParametersChecker.checkParameter((String)"X_TENANT_ID header is required and mustn't be null", (Object[])new Object[]{xTenantId});
            VitamThreadUtils.getVitamSession().setTenantId(xTenantId);
            VitamThreadUtils.getVitamSession().initIfAbsent(xTenantId);
            GraphComputeResponse response = this.graphComputeService.computeGraph(queryDsl);
            return Response.ok().header("X-Request-Id", (Object)VitamThreadUtils.getVitamSession().getRequestId()).entity((Object)response).build();
        }
        catch (Exception e) {
            LOGGER.error(COMPUTE_GRAPH_EXCEPTION_MSG, (Throwable)e);
            return Response.serverError().entity((Object)(ERROR_MSG + e.getMessage() + "\"}")).build();
        }
    }

    @Path(value="/computegraph/progress")
    @GET
    @Produces(value={"application/json"})
    @VitamAuthentication(authentLevel=AuthenticationLevel.BASIC_AUTHENT)
    public Response computeGraphByDSLInProgress(@HeaderParam(value="X-Tenant-Id") Integer xTenantId) {
        ParametersChecker.checkParameter((String)"X_TENANT_ID header is required and mustn't be null", (Object[])new Object[]{xTenantId});
        VitamThreadUtils.getVitamSession().setTenantId(xTenantId);
        VitamThreadUtils.getVitamSession().initIfAbsent(xTenantId);
        boolean inProgress = this.graphComputeService.isInProgress();
        if (inProgress) {
            LOGGER.info("Graph compute in progress ...");
            return Response.ok((Object)"{\"msg\": \"Graph compute in progress ...\"}").build();
        }
        LOGGER.info("No active graph builder");
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"{\"msg\": \"No active graph compute service\"}").build();
    }

    @Path(value="/computegraph/{collection:UNIT|OBJECTGROUP|UNIT_OBJECTGROUP}")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response computeGraph(@PathParam(value="collection") GraphComputeResponse.GraphComputeAction action, Set<String> documentsId) {
        try {
            VitamThreadUtils.getVitamSession().initIfAbsent(VitamConfiguration.getAdminTenant());
            MetadataCollections metadataCollections = MetadataCollections.UNIT;
            boolean computeObjectGroupGraph = GraphComputeResponse.GraphComputeAction.UNIT_OBJECTGROUP.equals((Object)action);
            if (GraphComputeResponse.GraphComputeAction.OBJECTGROUP.equals((Object)action)) {
                metadataCollections = MetadataCollections.OBJECTGROUP;
            }
            GraphComputeResponse response = this.graphComputeService.computeGraph(metadataCollections, documentsId, computeObjectGroupGraph, true);
            return Response.ok().entity((Object)response).build();
        }
        catch (Exception e) {
            LOGGER.error(COMPUTE_GRAPH_EXCEPTION_MSG, (Throwable)e);
            return Response.serverError().entity((Object)(ERROR_MSG + e.getMessage() + "\"}")).build();
        }
    }

    @Path(value="exportReclassificationChildNodes")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response exportReclassificationChildNodes(ReclassificationChildNodeExportRequest request) {
        try {
            this.reclassificationDistributionService.exportReclassificationChildNodes(request.getUnitIds(), request.getUnitsToUpdateJsonLineFileName(), request.getObjectGroupsToUpdateJsonLineFileName());
            return Response.ok().build();
        }
        catch (Exception e) {
            LOGGER.error("Could not export child nodes for reclassification graph update", (Throwable)e);
            return Response.serverError().entity((Object)(ERROR_MSG + e.getMessage() + "\"}")).build();
        }
    }

    @Path(value="/units/computedInheritedRules/processObsoletes")
    @POST
    @Produces(value={"application/json"})
    @VitamAuthentication(authentLevel=AuthenticationLevel.BASIC_AUTHENT)
    public Response processObsoleteComputedInheritedRules() {
        try {
            boolean isError = false;
            Iterator iterator = VitamConfiguration.getTenants().iterator();
            while (iterator.hasNext()) {
                int tenant = (Integer)iterator.next();
                VitamThreadUtils.getVitamSession().setTenantId(Integer.valueOf(tenant));
                JsonNode dslQuery = this.getObsoleteComputedInheritedRulesDsl();
                Response response = this.computedInheritedRulesCalculation(dslQuery);
                if (response.getStatusInfo().equals((Object)Response.Status.ACCEPTED)) continue;
                isError = true;
            }
            if (isError) {
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
            }
            return Response.status((Response.Status)Response.Status.ACCEPTED).build();
        }
        catch (InvalidCreateOperationException e) {
            LOGGER.error((Throwable)e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)(ERROR_MSG + e.getMessage() + "\"}")).build();
        }
    }

    @Path(value="/purgeDIP")
    @DELETE
    @Produces(value={"application/json"})
    @VitamAuthentication(authentLevel=AuthenticationLevel.BASIC_AUTHENT)
    public Response purgeExpiredDipFiles() {
        try {
            VitamThreadUtils.getVitamSession().initIfAbsent(VitamConfiguration.getAdminTenant());
            this.exportsPurgeService.purgeExpiredFiles("DIP");
            return Response.status((Response.Status)Response.Status.OK).build();
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
            return VitamCodeHelper.toVitamError((VitamCode)VitamCode.METADATA_INTERNAL_SERVER_ERROR, (String)e.getMessage()).toResponse();
        }
    }

    @Path(value="/purgeTransfersSIP")
    @DELETE
    @Produces(value={"application/json"})
    @VitamAuthentication(authentLevel=AuthenticationLevel.BASIC_AUTHENT)
    public Response purgeExpiredTransfersSIPFiles() {
        try {
            VitamThreadUtils.getVitamSession().initIfAbsent(VitamConfiguration.getAdminTenant());
            this.exportsPurgeService.purgeExpiredFiles("TRANSFER");
            return Response.status((Response.Status)Response.Status.OK).build();
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
            return VitamCodeHelper.toVitamError((VitamCode)VitamCode.METADATA_INTERNAL_SERVER_ERROR, (String)e.getMessage()).toResponse();
        }
    }

    @Path(value="/migrationDeleteDipFromOffers")
    @DELETE
    @Produces(value={"application/json"})
    @VitamAuthentication(authentLevel=AuthenticationLevel.BASIC_AUTHENT)
    public Response migrationPurgeDipFilesFromOffers() {
        try {
            for (Integer tenant : VitamConfiguration.getTenants()) {
                LOGGER.info("Running DIP cleanup from offers for tenant " + tenant);
                VitamThreadUtils.getVitamSession().setTenantId(tenant);
                VitamThreadUtils.getVitamSession().setRequestId(GUIDFactory.newRequestIdGUID((int)tenant));
                this.exportsPurgeService.migrationPurgeDipFilesFromOffers();
                LOGGER.info("Running DIP finished successfully");
            }
            return Response.status((Response.Status)Response.Status.OK).build();
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
            return VitamCodeHelper.toVitamError((VitamCode)VitamCode.METADATA_INTERNAL_SERVER_ERROR, (String)e.getMessage()).toResponse();
        }
    }

    private JsonNode getObsoleteComputedInheritedRulesDsl() throws InvalidCreateOperationException {
        SelectMultiQuery selectMultiQuery = new SelectMultiQuery();
        BooleanQuery obsoleteQuery = QueryHelper.or();
        obsoleteQuery.add(new Query[]{QueryHelper.eq((String)VitamFieldsHelper.validComputedInheritedRules(), (boolean)false)});
        BooleanQuery incoherentValuesQuery = QueryHelper.and();
        incoherentValuesQuery.add(new Query[]{QueryHelper.not().add(new Query[]{QueryHelper.exists((String)VitamFieldsHelper.computedInheritedRules())})});
        incoherentValuesQuery.add(new Query[]{QueryHelper.exists((String)VitamFieldsHelper.validComputedInheritedRules())});
        obsoleteQuery.add(new Query[]{incoherentValuesQuery});
        selectMultiQuery.setQuery((Query)obsoleteQuery);
        selectMultiQuery.setThreshold(Long.valueOf(VitamConfiguration.getComputedInheritedRulesThreshold()));
        return selectMultiQuery.getFinalSelect();
    }

    /*
     * Exception decompiling
     */
    private Response computedInheritedRulesCalculation(JsonNode dslQuery) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private VitamError getErrorEntity(Response.Status status, String message) {
        String msg = this.getErrorStreamMessage(status, message);
        return new VitamError(status.name()).setHttpCode(status.getStatusCode()).setContext(ServiceName.METADATA.getName()).setState(CODE_VITAM).setMessage(msg);
    }

    private String getErrorStreamMessage(Response.Status status, String message) {
        if (message != null && !message.trim().isEmpty()) {
            return message;
        }
        if (status.getReasonPhrase() != null) {
            return status.getReasonPhrase();
        }
        return status.name();
    }

    private Response buildErrorResponse(VitamCode vitamCode, String description) {
        if (description == null) {
            description = vitamCode.getMessage();
        }
        return Response.status((Response.Status)vitamCode.getStatus()).entity((Object)new RequestResponseError().setError(new VitamError(VitamCodeHelper.getCode((VitamCode)vitamCode)).setContext(vitamCode.getService().getName()).setState(vitamCode.getDomain().getName()).setMessage(vitamCode.getMessage()).setDescription(description)).toString()).build();
    }
}

