/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.metadata.rest;

import com.google.common.base.Throwables;
import fr.gouv.vitam.common.PropertiesUtils;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.database.api.VitamRepositoryFactory;
import fr.gouv.vitam.common.database.api.VitamRepositoryProvider;
import fr.gouv.vitam.common.model.processing.WorkFlowExecutionContext;
import fr.gouv.vitam.common.server.application.configuration.DefaultVitamApplicationConfiguration;
import fr.gouv.vitam.common.serverv2.application.AdminApplication;
import fr.gouv.vitam.metadata.core.MetaDataImpl;
import fr.gouv.vitam.metadata.core.MongoDbAccessMetadataFactory;
import fr.gouv.vitam.metadata.core.config.ElasticsearchMetadataIndexManager;
import fr.gouv.vitam.metadata.core.config.MetaDataConfiguration;
import fr.gouv.vitam.metadata.core.config.MetaDataConfigurationValidator;
import fr.gouv.vitam.metadata.core.database.collections.MongoDbAccessMetadataImpl;
import fr.gouv.vitam.metadata.core.migration.UnitsWithTransferRequestsMigrationService;
import fr.gouv.vitam.metadata.rest.AdminMetadataManagementResource;
import fr.gouv.vitam.metadata.rest.MetadataAdminMigrationResource;
import fr.gouv.vitam.metadata.rest.MetadataAuditResource;
import fr.gouv.vitam.security.internal.filter.AdminRequestIdFilter;
import fr.gouv.vitam.security.internal.filter.BasicAuthenticationFilter;
import fr.gouv.vitam.workspace.client.WorkspaceClientFactory;
import jakarta.servlet.ServletConfig;
import jakarta.ws.rs.core.Application;
import jakarta.ws.rs.core.Context;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;

public class AdminMetadataApplication
extends Application {
    private final AdminApplication adminApplication;
    private final Set<Object> singletons;

    public AdminMetadataApplication(@Context ServletConfig servletConfig) {
        String configurationFile = servletConfig.getInitParameter("vitam.configurationFile");
        try (InputStream yamlIS = PropertiesUtils.getConfigAsStream((String)configurationFile);){
            MetaDataConfiguration metaDataConfiguration = (MetaDataConfiguration)PropertiesUtils.readYaml((InputStream)yamlIS, MetaDataConfiguration.class);
            MetaDataConfigurationValidator.validateConfiguration((MetaDataConfiguration)metaDataConfiguration);
            ElasticsearchMetadataIndexManager indexManager = new ElasticsearchMetadataIndexManager(metaDataConfiguration, VitamConfiguration.getTenants());
            this.adminApplication = new AdminApplication();
            MongoDbAccessMetadataImpl mongoDbAccessMetadata = MongoDbAccessMetadataFactory.create((MetaDataConfiguration)metaDataConfiguration, (ElasticsearchMetadataIndexManager)indexManager);
            WorkspaceClientFactory.changeMode((String)metaDataConfiguration.getWorkspaceUrl(), (WorkFlowExecutionContext)WorkFlowExecutionContext.VITAM);
            VitamRepositoryFactory vitamRepositoryProvider = VitamRepositoryFactory.get();
            MetaDataImpl metadata = MetaDataImpl.newMetadata((MongoDbAccessMetadataImpl)mongoDbAccessMetadata, (int)VitamConfiguration.getOntologyCacheMaxEntries(), (int)VitamConfiguration.getOntologyCacheTimeoutInSeconds(), (ElasticsearchMetadataIndexManager)indexManager, (MetaDataConfiguration)metaDataConfiguration);
            AdminMetadataManagementResource adminMetadataReconstructionResource = new AdminMetadataManagementResource((VitamRepositoryProvider)vitamRepositoryProvider, metadata, metaDataConfiguration, indexManager);
            MetadataAuditResource metadataAuditResource = new MetadataAuditResource(metaDataConfiguration);
            this.singletons = new HashSet<Object>();
            this.singletons.addAll(this.adminApplication.getSingletons());
            this.singletons.add(adminMetadataReconstructionResource);
            this.singletons.add(new BasicAuthenticationFilter((DefaultVitamApplicationConfiguration)metaDataConfiguration));
            this.singletons.add(new AdminRequestIdFilter());
            this.singletons.add(metadataAuditResource);
            if (!metaDataConfiguration.getCollectModule().booleanValue()) {
                this.singletons.add(new MetadataAdminMigrationResource(new UnitsWithTransferRequestsMigrationService(metadata)));
            }
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public Set<Object> getSingletons() {
        return this.singletons;
    }
}

