/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.access.external.client;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.access.external.api.AdminCollections;
import fr.gouv.vitam.access.external.client.AdminExternalClient;
import fr.gouv.vitam.access.external.client.AdminExternalClientFactory;
import fr.gouv.vitam.access.external.client.exception.AdminExternalClientException;
import fr.gouv.vitam.access.external.common.exception.AccessExternalClientException;
import fr.gouv.vitam.access.external.common.exception.AccessExternalClientNotFoundException;
import fr.gouv.vitam.access.external.common.exception.AccessExternalClientServerException;
import fr.gouv.vitam.access.external.common.exception.AccessExternalNotFoundException;
import fr.gouv.vitam.access.external.common.exception.LogbookExternalClientException;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.client.VitamClientFactoryInterface;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.client.VitamRequestBuilder;
import fr.gouv.vitam.common.error.VitamCode;
import fr.gouv.vitam.common.error.VitamError;
import fr.gouv.vitam.common.exception.AccessUnauthorizedException;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.exception.VitamClientInternalException;
import fr.gouv.vitam.common.external.client.DefaultClient;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.ProbativeValueRequest;
import fr.gouv.vitam.common.model.ProcessQuery;
import fr.gouv.vitam.common.model.ProcessState;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.model.administration.AccessContractModel;
import fr.gouv.vitam.common.model.administration.AccessionRegisterDetailModel;
import fr.gouv.vitam.common.model.administration.AccessionRegisterSummaryModel;
import fr.gouv.vitam.common.model.administration.AccessionRegisterSymbolicModel;
import fr.gouv.vitam.common.model.administration.AgenciesModel;
import fr.gouv.vitam.common.model.administration.ArchiveUnitProfileModel;
import fr.gouv.vitam.common.model.administration.CombinedSchemaModel;
import fr.gouv.vitam.common.model.administration.ContextModel;
import fr.gouv.vitam.common.model.administration.FileFormatModel;
import fr.gouv.vitam.common.model.administration.FileRulesModel;
import fr.gouv.vitam.common.model.administration.IngestContractModel;
import fr.gouv.vitam.common.model.administration.ManagementContractModel;
import fr.gouv.vitam.common.model.administration.OntologyModel;
import fr.gouv.vitam.common.model.administration.SecurityProfileModel;
import fr.gouv.vitam.common.model.administration.preservation.GriffinModel;
import fr.gouv.vitam.common.model.administration.preservation.PreservationScenarioModel;
import fr.gouv.vitam.common.model.administration.profile.ProfileModel;
import fr.gouv.vitam.common.model.administration.schema.SchemaResponse;
import fr.gouv.vitam.common.model.configuration.PublicConfiguration;
import fr.gouv.vitam.common.model.processing.ProcessDetail;
import fr.gouv.vitam.common.model.processing.WorkFlow;
import fr.gouv.vitam.logbook.common.parameters.LogbookOperationParameters;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.io.InputStream;
import java.util.List;

public class AdminExternalClientRest
extends DefaultClient
implements AdminExternalClient {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(AdminExternalClientRest.class);
    private static final String ACCESS_EXTERNAL_MODULE = "AccessExternalModule";
    private static final String UPDATE_ACCESS_CONTRACT = "/accesscontracts/";
    private static final String UPDATE_INGEST_CONTRACT = "/ingestcontracts/";
    private static final String UPDATE_MANAGEMENT_CONTRACT = "/managementcontracts/";
    private static final String UPDATE_CONTEXT = "contexts/";
    private static final String UPDATE_PROFILE = "profiles/";
    private static final String UPDATE_AU_PROFILE = "archiveunitprofiles/";
    private static final String UPDATE_SECURITY_PROFILE = "securityprofiles/";
    private static final String BLANK_OPERATION_ID = "Operation identifier should be filled";
    private static final String BLANK_TENANT_ID = "Tenant identifier should be filled";
    private static final String BLANK_ACTION_ID = "Action should be filled";
    private static final String BLANK_OBJECT_ID = "object identifier should be filled";

    AdminExternalClientRest(AdminExternalClientFactory factory) {
        super((VitamClientFactoryInterface)factory);
    }

    @Override
    public RequestResponse<FileFormatModel> findFormats(VitamContext vitamContext, JsonNode select) throws VitamClientException {
        return this.internalFindDocuments(vitamContext, AdminCollections.FORMATS, select, FileFormatModel.class);
    }

    @Override
    public RequestResponse<FileRulesModel> findRules(VitamContext vitamContext, JsonNode select) throws VitamClientException {
        return this.internalFindDocuments(vitamContext, AdminCollections.RULES, select, FileRulesModel.class);
    }

    @Override
    public RequestResponse<IngestContractModel> findIngestContracts(VitamContext vitamContext, JsonNode select) throws VitamClientException {
        return this.internalFindDocuments(vitamContext, AdminCollections.INGEST_CONTRACTS, select, IngestContractModel.class);
    }

    @Override
    public RequestResponse<AccessContractModel> findAccessContracts(VitamContext vitamContext, JsonNode select) throws VitamClientException {
        return this.internalFindDocuments(vitamContext, AdminCollections.ACCESS_CONTRACTS, select, AccessContractModel.class);
    }

    @Override
    public RequestResponse<ManagementContractModel> findManagementContracts(VitamContext vitamContext, JsonNode select) throws VitamClientException {
        return this.internalFindDocuments(vitamContext, AdminCollections.MANAGEMENT_CONTRACTS, select, ManagementContractModel.class);
    }

    @Override
    public RequestResponse<ContextModel> findContexts(VitamContext vitamContext, JsonNode select) throws VitamClientException {
        return this.internalFindDocuments(vitamContext, AdminCollections.CONTEXTS, select, ContextModel.class);
    }

    @Override
    public RequestResponse<ProfileModel> findProfiles(VitamContext vitamContext, JsonNode select) throws VitamClientException {
        return this.internalFindDocuments(vitamContext, AdminCollections.PROFILE, select, ProfileModel.class);
    }

    @Override
    public RequestResponse<AccessionRegisterSummaryModel> findAccessionRegister(VitamContext vitamContext, JsonNode select) throws VitamClientException {
        return this.internalFindDocuments(vitamContext, AdminCollections.ACCESSION_REGISTERS, select, AccessionRegisterSummaryModel.class);
    }

    @Override
    public RequestResponse<AccessionRegisterDetailModel> findAccessionRegisterDetails(VitamContext vitamContext, JsonNode select) throws VitamClientException {
        return this.internalFindDocuments(vitamContext, AdminCollections.ACCESSION_REGISTER_DETAILS, select, AccessionRegisterDetailModel.class);
    }

    @Override
    public RequestResponse<AccessionRegisterSymbolicModel> findAccessionRegisterSymbolic(VitamContext vitamContext, JsonNode select) throws VitamClientException {
        return this.internalFindDocuments(vitamContext, AdminCollections.ACCESSION_REGISTERS_SYMBOLIC, select, AccessionRegisterSymbolicModel.class);
    }

    @Override
    public RequestResponse<SecurityProfileModel> findSecurityProfiles(VitamContext vitamContext, JsonNode select) throws VitamClientException {
        return this.internalFindDocuments(vitamContext, AdminCollections.SECURITY_PROFILES, select, SecurityProfileModel.class);
    }

    private <T> RequestResponse<T> internalFindDocuments(VitamContext vitamContext, AdminCollections documentType, JsonNode select, Class<T> clazz) throws VitamClientException {
        RequestResponse requestResponse;
        block8: {
            VitamRequestBuilder request = VitamRequestBuilder.get().withPath(documentType.getName()).withHeaders(vitamContext.getHeaders()).withBody((Object)select).withJson();
            Response response = this.make(request);
            try {
                this.check(response);
                requestResponse = RequestResponse.parseFromResponse((Response)response, clazz);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (AdminExternalClientException e) {
                    LOGGER.error((Throwable)((Object)e));
                    return e.getVitamError();
                }
            }
            response.close();
        }
        return requestResponse;
    }

    @Override
    public RequestResponse getAccessionRegisterDetail(VitamContext vitamContext, String id, JsonNode query) throws InvalidParseOperationException, AccessExternalClientServerException, AccessExternalClientNotFoundException {
        RequestResponse requestResponse;
        block9: {
            VitamRequestBuilder request = VitamRequestBuilder.post().withPath("/accessionregisters/" + id + "/accessionregisterdetails").withHeaders(vitamContext.getHeaders()).withHeader("X-Http-Method-Override", (Object)"GET").withBody((Object)query).withJson();
            Response response = this.make(request);
            try {
                this.check(response);
                requestResponse = RequestResponse.parseFromResponse((Response)response);
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (VitamClientInternalException e) {
                    throw new AccessExternalClientServerException((Throwable)e);
                }
                catch (AdminExternalClientException e) {
                    LOGGER.error((Throwable)((Object)e));
                    return e.getVitamError().setMessage(VitamCode.ACCESS_EXTERNAL_GET_ACCESSION_REGISTER_DETAIL_ERROR.getMessage()).setDescription(VitamCode.ACCESS_EXTERNAL_GET_ACCESSION_REGISTER_DETAIL_ERROR.getMessage());
                }
            }
            response.close();
        }
        return requestResponse;
    }

    @Override
    public RequestResponse updateAccessContract(VitamContext vitamContext, String id, JsonNode queryDsl) throws AccessExternalClientException {
        RequestResponse requestResponse;
        block9: {
            VitamRequestBuilder request = VitamRequestBuilder.put().withPath(UPDATE_ACCESS_CONTRACT + id).withHeaders(vitamContext.getHeaders()).withBody((Object)queryDsl).withJson();
            Response response = this.make(request);
            try {
                this.check(response);
                requestResponse = RequestResponse.parseFromResponse((Response)response);
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (VitamClientInternalException e) {
                    throw new AccessExternalClientException((Throwable)e);
                }
                catch (AdminExternalClientException e) {
                    LOGGER.error((Throwable)((Object)e));
                    return e.getVitamError();
                }
            }
            response.close();
        }
        return requestResponse;
    }

    @Override
    public RequestResponse updateIngestContract(VitamContext vitamContext, String id, JsonNode queryDsl) throws InvalidParseOperationException, AccessExternalClientException {
        RequestResponse requestResponse;
        block9: {
            VitamRequestBuilder request = VitamRequestBuilder.put().withPath(UPDATE_INGEST_CONTRACT + id).withHeaders(vitamContext.getHeaders()).withBody((Object)queryDsl).withJson();
            Response response = this.make(request);
            try {
                this.check(response);
                requestResponse = RequestResponse.parseFromResponse((Response)response);
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (VitamClientInternalException e) {
                    throw new AccessExternalClientException((Throwable)e);
                }
                catch (AdminExternalClientException e) {
                    LOGGER.error((Throwable)((Object)e));
                    return e.getVitamError();
                }
            }
            response.close();
        }
        return requestResponse;
    }

    @Override
    public RequestResponse updateManagementContract(VitamContext vitamContext, String id, JsonNode queryDsl) throws AccessExternalClientException {
        RequestResponse requestResponse;
        block9: {
            VitamRequestBuilder request = VitamRequestBuilder.put().withPath(UPDATE_MANAGEMENT_CONTRACT + id).withHeaders(vitamContext.getHeaders()).withBody((Object)queryDsl).withJson();
            Response response = this.make(request);
            try {
                this.check(response);
                requestResponse = RequestResponse.parseFromResponse((Response)response);
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (VitamClientInternalException e) {
                    throw new AccessExternalClientException((Throwable)e);
                }
                catch (AdminExternalClientException e) {
                    LOGGER.error((Throwable)((Object)e));
                    return e.getVitamError();
                }
            }
            response.close();
        }
        return requestResponse;
    }

    @Override
    public RequestResponse createProfiles(VitamContext vitamContext, InputStream profiles) throws InvalidParseOperationException, AccessExternalClientException {
        RequestResponse requestResponse;
        block9: {
            ParametersChecker.checkParameter((String)"The input profile json is mandatory", (Object[])new Object[]{profiles, AdminCollections.PROFILE});
            VitamRequestBuilder request = VitamRequestBuilder.post().withPath(AdminCollections.PROFILE.getName()).withHeaders(vitamContext.getHeaders()).withBody((Object)profiles).withOctetContentType().withJsonAccept();
            Response response = this.make(request);
            try {
                this.check(response);
                requestResponse = RequestResponse.parseFromResponse((Response)response);
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (VitamClientInternalException e) {
                    throw new AccessExternalClientException((Throwable)e);
                }
                catch (AdminExternalClientException e) {
                    LOGGER.error((Throwable)((Object)e));
                    return e.getVitamError();
                }
            }
            response.close();
        }
        return requestResponse;
    }

    @Override
    public RequestResponse createProfileFile(VitamContext vitamContext, String profileMetadataId, InputStream profile) throws InvalidParseOperationException, AccessExternalClientException {
        RequestResponse requestResponse;
        block9: {
            ParametersChecker.checkParameter((String)profileMetadataId, (String[])new String[]{"The profile id is mandatory"});
            VitamRequestBuilder request = VitamRequestBuilder.put().withPath(AdminCollections.PROFILE.getName() + "/" + profileMetadataId).withHeaders(vitamContext.getHeaders()).withBody((Object)profile, "The input profile stream is mandatory").withOctetContentType().withJsonAccept();
            Response response = this.make(request);
            try {
                this.check(response);
                requestResponse = RequestResponse.parseFromResponse((Response)response);
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (VitamClientInternalException e) {
                    throw new AccessExternalClientException((Throwable)e);
                }
                catch (AdminExternalClientException e) {
                    LOGGER.error((Throwable)((Object)e));
                    return e.getVitamError();
                }
            }
            response.close();
        }
        return requestResponse;
    }

    @Override
    public Response downloadProfileFile(VitamContext vitamContext, String profileMetadataId) throws AccessExternalClientException, AccessExternalNotFoundException {
        ParametersChecker.checkParameter((String)"Profile is is required", (String[])new String[]{profileMetadataId});
        VitamRequestBuilder request = VitamRequestBuilder.get().withPath(AdminCollections.PROFILE.getName() + "/" + profileMetadataId).withHeaders(vitamContext.getHeaders()).withOctetAccept();
        Response response = null;
        try {
            response = this.make(request);
            this.check(response);
            Response response2 = response;
            return response2;
        }
        catch (VitamClientInternalException e) {
            throw new AccessExternalClientException((Throwable)e);
        }
        catch (AdminExternalClientException e) {
            throw new AccessExternalNotFoundException("Error while download profile file : " + profileMetadataId, (Throwable)((Object)e));
        }
        finally {
            if (response != null && !Response.Status.Family.SUCCESSFUL.equals((Object)response.getStatusInfo().getFamily())) {
                response.close();
            }
        }
    }

    @Override
    public RequestResponse createContexts(VitamContext vitamContext, InputStream contexts) throws InvalidParseOperationException, AccessExternalClientServerException {
        RequestResponse requestResponse;
        block9: {
            VitamRequestBuilder request = VitamRequestBuilder.post().withPath(AdminCollections.CONTEXTS.getName()).withHeaders(vitamContext.getHeaders()).withBody((Object)contexts).withJson();
            Response response = this.make(request);
            try {
                this.check(response);
                requestResponse = new RequestResponseOK().setHttpCode(Response.Status.OK.getStatusCode()).addHeader("X-Request-Id", response.getHeaderString("X-Request-Id"));
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (VitamClientInternalException e) {
                    throw new AccessExternalClientServerException((Throwable)e);
                }
                catch (AdminExternalClientException e) {
                    LOGGER.error((Throwable)((Object)e));
                    return e.getVitamError();
                }
            }
            response.close();
        }
        return requestResponse;
    }

    @Override
    public RequestResponse updateContext(VitamContext vitamContext, String id, JsonNode queryDsl) throws AccessExternalClientException {
        RequestResponse requestResponse;
        block9: {
            VitamRequestBuilder request = VitamRequestBuilder.put().withPath(UPDATE_CONTEXT + id).withHeaders(vitamContext.getHeaders()).withBody((Object)queryDsl).withJson();
            Response response = this.make(request);
            try {
                this.check(response);
                requestResponse = RequestResponse.parseFromResponse((Response)response);
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (VitamClientInternalException e) {
                    throw new AccessExternalClientServerException((Throwable)e);
                }
                catch (AdminExternalClientException e) {
                    LOGGER.error((Throwable)((Object)e));
                    return e.getVitamError();
                }
            }
            response.close();
        }
        return requestResponse;
    }

    @Override
    public RequestResponse updateProfile(VitamContext vitamContext, String profileMetadataId, JsonNode queryDsl) throws AccessExternalClientException {
        RequestResponse requestResponse;
        block9: {
            VitamRequestBuilder request = VitamRequestBuilder.put().withPath(UPDATE_PROFILE + profileMetadataId).withHeaders(vitamContext.getHeaders()).withBody((Object)queryDsl).withJson();
            Response response = this.make(request);
            try {
                this.check(response);
                requestResponse = RequestResponse.parseFromResponse((Response)response);
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (VitamClientInternalException e) {
                    throw new AccessExternalClientServerException((Throwable)e);
                }
                catch (AdminExternalClientException e) {
                    LOGGER.error((Throwable)((Object)e));
                    return e.getVitamError();
                }
            }
            response.close();
        }
        return requestResponse;
    }

    @Override
    @Deprecated
    public RequestResponse checkTraceabilityOperation(VitamContext vitamContext, JsonNode query) throws AccessExternalClientServerException {
        RequestResponse requestResponse;
        block9: {
            VitamRequestBuilder request = VitamRequestBuilder.post().withPath(AdminCollections.TRACEABILITY.getCheckURI()).withHeaders(vitamContext.getHeaders()).withBody((Object)query).withJson();
            Response response = this.make(request);
            try {
                this.check(response);
                requestResponse = RequestResponse.parseFromResponse((Response)response);
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (VitamClientInternalException e) {
                    throw new AccessExternalClientServerException((Throwable)e);
                }
                catch (AdminExternalClientException e) {
                    LOGGER.error((Throwable)((Object)e));
                    return e.getVitamError().setMessage(VitamCode.ACCESS_EXTERNAL_CHECK_TRACEABILITY_OPERATION_ERROR.getMessage());
                }
            }
            response.close();
        }
        return requestResponse;
    }

    @Override
    public RequestResponse<JsonNode> checkTraceabilityOperations(VitamContext vitamContext, JsonNode query) throws AccessExternalClientServerException {
        RequestResponse requestResponse;
        block9: {
            VitamRequestBuilder request = VitamRequestBuilder.post().withPath("/traceability/linkedchecks").withHeaders(vitamContext.getHeaders()).withBody((Object)query).withJson();
            Response response = this.make(request);
            try {
                this.check(response);
                requestResponse = RequestResponse.parseFromResponse((Response)response);
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (VitamClientInternalException e) {
                    throw new AccessExternalClientServerException((Throwable)e);
                }
                catch (AdminExternalClientException e) {
                    LOGGER.error((Throwable)((Object)e));
                    return e.getVitamError().setMessage(VitamCode.ACCESS_EXTERNAL_CHECK_TRACEABILITY_OPERATION_ERROR.getMessage());
                }
            }
            response.close();
        }
        return requestResponse;
    }

    @Override
    public Response downloadTraceabilityOperationFile(VitamContext vitamContext, String operationId) throws AccessExternalClientServerException, AccessUnauthorizedException {
        Response response = null;
        try {
            VitamRequestBuilder request = VitamRequestBuilder.get().withPath("/traceability/" + operationId + "/datafiles").withHeaders(vitamContext.getHeaders()).withOctetAccept();
            response = this.make(request);
            this.check(response);
            Response response2 = response;
            return response2;
        }
        catch (VitamClientInternalException e) {
            throw new AccessExternalClientServerException((Throwable)e);
        }
        catch (AdminExternalClientException e) {
            if (e.getStatus().equals((Object)Response.Status.UNAUTHORIZED)) {
                throw new AccessUnauthorizedException((Throwable)((Object)e));
            }
            throw new AccessExternalClientServerException((Throwable)((Object)e));
        }
        finally {
            if (response != null && !Response.Status.Family.SUCCESSFUL.equals((Object)response.getStatusInfo().getFamily())) {
                response.close();
            }
        }
    }

    @Override
    public RequestResponse launchAudit(VitamContext vitamContext, JsonNode auditOption) throws AccessExternalClientServerException {
        RequestResponse requestResponse;
        block9: {
            VitamRequestBuilder post = VitamRequestBuilder.post().withPath("/audits").withHeaders(vitamContext.getHeaders()).withBody((Object)auditOption).withJson();
            Response response = this.make(post);
            try {
                this.check(response);
                requestResponse = RequestResponse.parseFromResponse((Response)response);
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (AdminExternalClientException e) {
                    LOGGER.error((Throwable)((Object)e));
                    return e.getVitamError();
                }
                catch (VitamClientInternalException e) {
                    throw new AccessExternalClientServerException((Throwable)e);
                }
            }
            response.close();
        }
        return requestResponse;
    }

    private <T> RequestResponse<T> internalFindDocumentById(VitamContext vitamContext, AdminCollections documentType, String documentId, Class<T> clazz) throws VitamClientException {
        RequestResponse requestResponse;
        block9: {
            VitamRequestBuilder request = VitamRequestBuilder.get().withPath(documentType.getName() + "/" + documentId).withHeaders(vitamContext.getHeaders()).withJsonAccept();
            Response response = this.make(request);
            try {
                this.check(response);
                requestResponse = RequestResponse.parseFromResponse((Response)response, clazz);
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (AdminExternalClientException e) {
                    LOGGER.error((Throwable)((Object)e));
                    return e.getVitamError();
                }
                catch (VitamClientInternalException e) {
                    throw new VitamClientException((Throwable)e);
                }
            }
            response.close();
        }
        return requestResponse;
    }

    @Override
    public RequestResponse<FileFormatModel> findFormatById(VitamContext vitamContext, String formatId) throws VitamClientException {
        return this.internalFindDocumentById(vitamContext, AdminCollections.FORMATS, formatId, FileFormatModel.class);
    }

    @Override
    public RequestResponse<FileRulesModel> findRuleById(VitamContext vitamContext, String ruleId) throws VitamClientException {
        return this.internalFindDocumentById(vitamContext, AdminCollections.RULES, ruleId, FileRulesModel.class);
    }

    @Override
    public RequestResponse<IngestContractModel> findIngestContractById(VitamContext vitamContext, String contractId) throws VitamClientException {
        return this.internalFindDocumentById(vitamContext, AdminCollections.INGEST_CONTRACTS, contractId, IngestContractModel.class);
    }

    @Override
    public RequestResponse<AccessContractModel> findAccessContractById(VitamContext vitamContext, String contractId) throws VitamClientException {
        return this.internalFindDocumentById(vitamContext, AdminCollections.ACCESS_CONTRACTS, contractId, AccessContractModel.class);
    }

    @Override
    public RequestResponse<ManagementContractModel> findManagementContractById(VitamContext vitamContext, String contractId) throws VitamClientException {
        return this.internalFindDocumentById(vitamContext, AdminCollections.MANAGEMENT_CONTRACTS, contractId, ManagementContractModel.class);
    }

    @Override
    public RequestResponse<ContextModel> findContextById(VitamContext vitamContext, String contextId) throws VitamClientException {
        return this.internalFindDocumentById(vitamContext, AdminCollections.CONTEXTS, contextId, ContextModel.class);
    }

    @Override
    public RequestResponse<ProfileModel> findProfileById(VitamContext vitamContext, String profileId) throws VitamClientException {
        return this.internalFindDocumentById(vitamContext, AdminCollections.PROFILE, profileId, ProfileModel.class);
    }

    @Override
    public RequestResponse<AccessionRegisterSummaryModel> findAccessionRegisterById(VitamContext vitamContext, String accessionRegisterId) throws VitamClientException {
        return this.internalFindDocumentById(vitamContext, AdminCollections.ACCESSION_REGISTERS, accessionRegisterId, AccessionRegisterSummaryModel.class);
    }

    @Override
    public RequestResponse<AgenciesModel> findAgencies(VitamContext vitamContext, JsonNode query) throws VitamClientException {
        return this.internalFindDocuments(vitamContext, AdminCollections.AGENCIES, query, AgenciesModel.class);
    }

    @Override
    public RequestResponse<AgenciesModel> findAgencyByID(VitamContext vitamContext, String agencyId) throws VitamClientException {
        return this.internalFindDocumentById(vitamContext, AdminCollections.AGENCIES, agencyId, AgenciesModel.class);
    }

    @Override
    public RequestResponse<SecurityProfileModel> findSecurityProfileById(VitamContext vitamContext, String identifier) throws VitamClientException {
        return this.internalFindDocumentById(vitamContext, AdminCollections.SECURITY_PROFILES, identifier, SecurityProfileModel.class);
    }

    @Override
    public RequestResponse updateSecurityProfile(VitamContext vitamContext, String identifier, JsonNode queryDsl) throws VitamClientException {
        RequestResponse requestResponse;
        block8: {
            VitamRequestBuilder request = VitamRequestBuilder.put().withPath(UPDATE_SECURITY_PROFILE + identifier).withHeaders(vitamContext.getHeaders()).withBody((Object)queryDsl).withJson();
            Response response = this.make(request);
            try {
                this.check(response);
                requestResponse = RequestResponse.parseFromResponse((Response)response);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (AdminExternalClientException e) {
                    LOGGER.error((Throwable)((Object)e));
                    return e.getVitamError();
                }
            }
            response.close();
        }
        return requestResponse;
    }

    @Override
    public RequestResponse<ProcessDetail> listOperationsDetails(VitamContext vitamContext, ProcessQuery query) throws VitamClientException {
        RequestResponse requestResponse;
        block9: {
            VitamRequestBuilder request = VitamRequestBuilder.get().withPath("/operations").withHeaders(vitamContext.getHeaders()).withBody((Object)query).withJson();
            Response response = this.make(request);
            try {
                this.check(response);
                requestResponse = RequestResponse.parseFromResponse((Response)response, ProcessDetail.class);
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (AdminExternalClientException e) {
                    LOGGER.error((Throwable)((Object)e));
                    return e.getVitamError();
                }
                catch (VitamClientInternalException e) {
                    throw new VitamClientException((Throwable)e);
                }
            }
            response.close();
        }
        return requestResponse;
    }

    @Override
    public RequestResponse<ItemStatus> updateOperationActionProcess(VitamContext vitamContext, String actionId, String operationId) throws VitamClientException {
        RequestResponse requestResponse;
        block9: {
            ParametersChecker.checkParameter((String)BLANK_OPERATION_ID, (String[])new String[]{operationId});
            ParametersChecker.checkParameter((String)BLANK_TENANT_ID, (Object[])new Object[]{vitamContext.getTenantId()});
            ParametersChecker.checkParameter((String)BLANK_ACTION_ID, (String[])new String[]{actionId});
            VitamRequestBuilder request = VitamRequestBuilder.put().withPath("/operations/" + operationId).withHeaders(vitamContext.getHeaders()).withHeader("X-ACTION", (Object)actionId).withJsonAccept();
            Response response = this.make(request);
            try {
                this.check(response);
                requestResponse = RequestResponse.parseFromResponse((Response)response, ItemStatus.class);
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (AdminExternalClientException e) {
                    LOGGER.error((Throwable)((Object)e));
                    return e.getVitamError();
                }
                catch (VitamClientInternalException e) {
                    throw new VitamClientException((Throwable)e);
                }
            }
            response.close();
        }
        return requestResponse;
    }

    @Override
    public RequestResponse<ItemStatus> getOperationProcessStatus(VitamContext vitamContext, String id) throws VitamClientException {
        RequestResponseOK requestResponseOK;
        block9: {
            ParametersChecker.checkParameter((String)BLANK_OPERATION_ID, (String[])new String[]{id});
            VitamRequestBuilder request = VitamRequestBuilder.head().withPath("/operations/" + id).withHeaders(vitamContext.getHeaders()).withJsonAccept();
            Response response = this.make(request);
            try {
                this.check(response);
                ItemStatus itemStatus = new ItemStatus().setGlobalState(ProcessState.valueOf((String)response.getHeaderString("X-Global-Execution-State"))).setLogbookTypeProcess(response.getHeaderString("X-Context-Id")).increment(StatusCode.valueOf((String)response.getHeaderString("X-Global-Execution-Status")));
                requestResponseOK = new RequestResponseOK().addResult((Object)itemStatus).setHttpCode(response.getStatus());
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (VitamClientInternalException e) {
                    throw new VitamClientException((Throwable)e);
                }
                catch (AdminExternalClientException e) {
                    LOGGER.error((Throwable)((Object)e));
                    return e.getVitamError();
                }
            }
            response.close();
        }
        return requestResponseOK;
    }

    @Override
    public RequestResponse<ItemStatus> cancelOperationProcessExecution(VitamContext vitamContext, String id, boolean force) throws VitamClientException, IllegalArgumentException {
        RequestResponse requestResponse;
        block9: {
            ParametersChecker.checkParameter((String)BLANK_OPERATION_ID, (String[])new String[]{id});
            ParametersChecker.checkParameter((String)BLANK_TENANT_ID, (Object[])new Object[]{vitamContext.getTenantId()});
            VitamRequestBuilder request = VitamRequestBuilder.delete().withPath("/operations/" + id).withHeaders(vitamContext.getHeaders()).withHeader("X-Force", (Object)force).withJsonAccept();
            Response response = this.make(request);
            try {
                this.check(response);
                requestResponse = RequestResponse.parseFromResponse((Response)response, ItemStatus.class);
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (AdminExternalClientException e) {
                    LOGGER.error((Throwable)((Object)e));
                    return e.getVitamError();
                }
                catch (VitamClientInternalException e) {
                    throw new VitamClientException((Throwable)e);
                }
            }
            response.close();
        }
        return requestResponse;
    }

    @Override
    public RequestResponse<ItemStatus> getOperationProcessExecutionDetails(VitamContext vitamContext, String id) throws VitamClientException {
        RequestResponse requestResponse;
        block9: {
            ParametersChecker.checkParameter((String)BLANK_OPERATION_ID, (String[])new String[]{id});
            ParametersChecker.checkParameter((String)BLANK_TENANT_ID, (Object[])new Object[]{vitamContext.getTenantId()});
            VitamRequestBuilder request = VitamRequestBuilder.get().withPath("/operations/" + id).withHeaders(vitamContext.getHeaders()).withHeader("X-ACTION", (Object)id).withJsonAccept();
            Response response = this.make(request);
            try {
                this.check(response);
                requestResponse = RequestResponse.parseFromResponse((Response)response, ItemStatus.class);
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (AdminExternalClientException e) {
                    LOGGER.error((Throwable)((Object)e));
                    return e.getVitamError();
                }
                catch (VitamClientInternalException e) {
                    throw new VitamClientException((Throwable)e);
                }
            }
            response.close();
        }
        return requestResponse;
    }

    @Override
    public RequestResponse<WorkFlow> getWorkflowDefinitions(VitamContext vitamContext) throws VitamClientException {
        RequestResponse requestResponse;
        block9: {
            VitamRequestBuilder request = VitamRequestBuilder.get().withPath("/workflows").withHeaders(vitamContext.getHeaders()).withJsonAccept();
            Response response = this.make(request);
            try {
                this.check(response);
                requestResponse = RequestResponse.parseFromResponse((Response)response, WorkFlow.class);
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (AdminExternalClientException e) {
                    LOGGER.error((Throwable)((Object)e));
                    return e.getVitamError();
                }
                catch (VitamClientInternalException e) {
                    throw new VitamClientException((Throwable)e);
                }
            }
            response.close();
        }
        return requestResponse;
    }

    private RequestResponse internalCreateDocument(VitamContext vitamContext, AdminCollections documentType, InputStream stream, String filename, MediaType type) throws AccessExternalClientException {
        RequestResponse requestResponse;
        block9: {
            ParametersChecker.checkParameter((String)"The document type is mandatory", (Object[])new Object[]{documentType});
            VitamRequestBuilder request = VitamRequestBuilder.post().withPath(documentType.getName()).withHeaders(vitamContext.getHeaders()).withHeader("X-Filename", (Object)filename).withBody((Object)stream).withContentType(type).withJsonAccept();
            Response response = this.make(request);
            try {
                this.check(response);
                requestResponse = new RequestResponseOK().setHttpCode(Response.Status.CREATED.getStatusCode()).addHeader("X-Request-Id", response.getHeaderString("X-Request-Id"));
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (AdminExternalClientException e) {
                    LOGGER.error((Throwable)((Object)e));
                    return e.getVitamError();
                }
                catch (VitamClientInternalException e) {
                    throw new AccessExternalClientException((Throwable)e);
                }
            }
            response.close();
        }
        return requestResponse;
    }

    @Override
    public RequestResponse createAgencies(VitamContext vitamContext, InputStream agencies, String filename) throws AccessExternalClientException {
        return this.internalCreateDocument(vitamContext, AdminCollections.AGENCIES, agencies, filename, MediaType.APPLICATION_OCTET_STREAM_TYPE);
    }

    @Override
    public RequestResponse createFormats(VitamContext vitamContext, InputStream formats, String filename) throws AccessExternalClientException {
        return this.internalCreateDocument(vitamContext, AdminCollections.FORMATS, formats, filename, MediaType.APPLICATION_OCTET_STREAM_TYPE);
    }

    @Override
    public RequestResponse createRules(VitamContext vitamContext, InputStream rules, String filename) throws AccessExternalClientException {
        return this.internalCreateDocument(vitamContext, AdminCollections.RULES, rules, filename, MediaType.APPLICATION_OCTET_STREAM_TYPE);
    }

    @Override
    public RequestResponse createSecurityProfiles(VitamContext vitamContext, InputStream securityProfiles, String filename) throws AccessExternalClientException {
        return this.internalCreateDocument(vitamContext, AdminCollections.SECURITY_PROFILES, securityProfiles, filename, MediaType.APPLICATION_JSON_TYPE);
    }

    @Override
    public Response checkRules(VitamContext vitamContext, InputStream rules) throws VitamClientException {
        return this.internalCheckDocuments(vitamContext, AdminCollections.RULES, rules);
    }

    @Override
    public Response checkFormats(VitamContext vitamContext, InputStream formats) throws VitamClientException {
        return this.internalCheckDocuments(vitamContext, AdminCollections.FORMATS, formats);
    }

    @Override
    public Response checkAgencies(VitamContext vitamContext, InputStream agencies) throws VitamClientException {
        return this.internalCheckDocuments(vitamContext, AdminCollections.AGENCIES, agencies);
    }

    private Response internalCheckDocuments(VitamContext vitamContext, AdminCollections documentType, InputStream stream) throws VitamClientException {
        VitamRequestBuilder request = VitamRequestBuilder.post().withPath(documentType.getCheckURI()).withHeaders(vitamContext.getHeaders()).withBody((Object)stream).withOctet();
        Response response = null;
        try {
            response = this.make(request);
            this.check(response);
            Response response2 = response;
            return response2;
        }
        catch (AdminExternalClientException e) {
            LOGGER.error((Throwable)((Object)e));
            Response response3 = response;
            return response3;
        }
        catch (VitamClientInternalException e) {
            throw new VitamClientException((Throwable)e);
        }
        finally {
            if (response != null && !Response.Status.Family.SUCCESSFUL.equals((Object)response.getStatusInfo().getFamily())) {
                response.close();
            }
        }
    }

    private RequestResponse internalCreateContracts(VitamContext vitamContext, InputStream contracts, AdminCollections collection) throws AccessExternalClientException {
        RequestResponse requestResponse;
        block9: {
            ParametersChecker.checkParameter((String)"The collection parameter is mandatory", (Object[])new Object[]{collection});
            VitamRequestBuilder request = VitamRequestBuilder.post().withPath(collection.getName()).withHeaders(vitamContext.getHeaders()).withBody((Object)contracts, "The input contracts json is mandatory").withJson();
            Response response = this.make(request);
            try {
                this.check(response);
                requestResponse = new RequestResponseOK().setHttpCode(Response.Status.OK.getStatusCode()).addHeader("X-Request-Id", response.getHeaderString("X-Request-Id"));
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (VitamClientInternalException e) {
                    throw new AccessExternalClientException((Throwable)e);
                }
                catch (AdminExternalClientException e) {
                    LOGGER.error((Throwable)((Object)e));
                    return e.getVitamError();
                }
            }
            response.close();
        }
        return requestResponse;
    }

    @Override
    public RequestResponse createIngestContracts(VitamContext vitamContext, InputStream ingestContracts) throws InvalidParseOperationException, AccessExternalClientException {
        return this.internalCreateContracts(vitamContext, ingestContracts, AdminCollections.INGEST_CONTRACTS);
    }

    @Override
    public RequestResponse createAccessContracts(VitamContext vitamContext, InputStream accessContracts) throws InvalidParseOperationException, AccessExternalClientException {
        return this.internalCreateContracts(vitamContext, accessContracts, AdminCollections.ACCESS_CONTRACTS);
    }

    @Override
    public RequestResponse createManagementContracts(VitamContext vitamContext, InputStream managementContracts) throws InvalidParseOperationException, AccessExternalClientException {
        return this.internalCreateContracts(vitamContext, managementContracts, AdminCollections.MANAGEMENT_CONTRACTS);
    }

    @Override
    public Response downloadDistributionReport(VitamContext vitamContext, String opId) throws VitamClientException {
        ParametersChecker.checkParameter((String)BLANK_OBJECT_ID, (String[])new String[]{opId});
        VitamRequestBuilder request = VitamRequestBuilder.get().withPath("/distributionreport/" + opId).withHeaders(vitamContext.getHeaders()).withOctetAccept();
        Response response = null;
        try {
            response = this.make(request);
            this.check(response);
            Response response2 = response;
            return response2;
        }
        catch (VitamClientInternalException e) {
            throw new VitamClientException((Throwable)e);
        }
        finally {
            if (response != null && !Response.Status.Family.SUCCESSFUL.equals((Object)response.getStatusInfo().getFamily())) {
                response.close();
            }
        }
    }

    @Override
    public Response downloadBatchReport(VitamContext vitamContext, String opId) throws VitamClientException {
        ParametersChecker.checkParameter((String)BLANK_OBJECT_ID, (String[])new String[]{opId});
        VitamRequestBuilder request = VitamRequestBuilder.get().withPath("/batchreport/" + opId).withHeaders(vitamContext.getHeaders()).withOctetAccept();
        Response response = null;
        try {
            response = this.make(request);
            this.check(response);
            Response response2 = response;
            return response2;
        }
        catch (VitamClientInternalException e) {
            throw new VitamClientException((Throwable)e);
        }
        finally {
            if (response != null && !Response.Status.Family.SUCCESSFUL.equals((Object)response.getStatusInfo().getFamily())) {
                response.close();
            }
        }
    }

    @Override
    public Response downloadRulesReport(VitamContext vitamContext, String opId) throws VitamClientException {
        ParametersChecker.checkParameter((String)BLANK_OBJECT_ID, (String[])new String[]{opId});
        VitamRequestBuilder request = VitamRequestBuilder.get().withPath("/rulesreport/" + opId).withHeaders(vitamContext.getHeaders()).withOctetAccept();
        Response response = null;
        try {
            response = this.make(request);
            this.check(response);
            return response;
        }
        catch (AdminExternalClientException e) {
            LOGGER.error((Throwable)((Object)e));
            return response;
        }
        catch (VitamClientInternalException e) {
            throw new VitamClientException((Throwable)e);
        }
    }

    @Override
    public Response downloadAgenciesCsvAsStream(VitamContext vitamContext, String opId) throws VitamClientException {
        ParametersChecker.checkParameter((String)BLANK_OBJECT_ID, (String[])new String[]{opId});
        VitamRequestBuilder request = VitamRequestBuilder.get().withPath("/agenciesreferential/" + opId).withHeaders(vitamContext.getHeaders()).withOctetAccept();
        Response response = null;
        try {
            response = this.make(request);
            this.check(response);
            Response response2 = response;
            return response2;
        }
        catch (VitamClientInternalException e) {
            throw new VitamClientException((Throwable)e);
        }
        finally {
            if (response != null && !Response.Status.Family.SUCCESSFUL.equals((Object)response.getStatusInfo().getFamily())) {
                response.close();
            }
        }
    }

    @Override
    public Response downloadRulesCsvAsStream(VitamContext vitamContext, String opId) throws VitamClientException {
        ParametersChecker.checkParameter((String)BLANK_OBJECT_ID, (String[])new String[]{opId});
        VitamRequestBuilder request = VitamRequestBuilder.get().withPath("/rulesreferential/" + opId).withHeaders(vitamContext.getHeaders()).withOctetAccept();
        Response response = null;
        try {
            response = this.make(request);
            this.check(response);
            Response response2 = response;
            return response2;
        }
        catch (VitamClientInternalException e) {
            throw new VitamClientException((Throwable)e);
        }
        finally {
            if (response != null && !Response.Status.Family.SUCCESSFUL.equals((Object)response.getStatusInfo().getFamily())) {
                response.close();
            }
        }
    }

    public RequestResponse evidenceAudit(VitamContext vitamContext, JsonNode dslQuery) throws VitamClientException {
        RequestResponse requestResponse;
        block9: {
            VitamRequestBuilder request = VitamRequestBuilder.post().withPath("/evidenceaudit").withHeaders(vitamContext.getHeaders()).withBody((Object)dslQuery).withJson();
            Response response = this.make(request);
            try {
                this.check(response);
                requestResponse = RequestResponse.parseFromResponse((Response)response);
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (AdminExternalClientException e) {
                    LOGGER.error((Throwable)((Object)e));
                    return e.getVitamError();
                }
                catch (VitamClientInternalException e) {
                    throw new VitamClientException((Throwable)e);
                }
            }
            response.close();
        }
        return requestResponse;
    }

    @Override
    public RequestResponse rectificationAudit(VitamContext vitamContext, String operationId) throws VitamClientException {
        RequestResponse requestResponse;
        block9: {
            VitamRequestBuilder request = VitamRequestBuilder.post().withPath("/rectificationaudit").withHeaders(vitamContext.getHeaders()).withBody((Object)operationId).withJson();
            Response response = this.make(request);
            try {
                this.check(response);
                requestResponse = RequestResponse.parseFromResponse((Response)response);
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (AdminExternalClientException e) {
                    LOGGER.error((Throwable)((Object)e));
                    return e.getVitamError();
                }
                catch (VitamClientInternalException e) {
                    throw new VitamClientException((Throwable)e);
                }
            }
            response.close();
        }
        return requestResponse;
    }

    @Override
    public RequestResponse exportProbativeValue(VitamContext vitamContext, ProbativeValueRequest probativeValueRequest) throws VitamClientException {
        RequestResponse requestResponse;
        block9: {
            VitamRequestBuilder request = VitamRequestBuilder.post().withPath("/probativevalueexport").withHeaders(vitamContext.getHeaders()).withBody((Object)probativeValueRequest).withJson();
            Response response = this.make(request);
            try {
                this.check(response);
                requestResponse = RequestResponse.parseFromResponse((Response)response);
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (AdminExternalClientException e) {
                    LOGGER.error((Throwable)((Object)e));
                    return e.getVitamError();
                }
                catch (VitamClientInternalException e) {
                    throw new VitamClientException((Throwable)e);
                }
            }
            response.close();
        }
        return requestResponse;
    }

    @Override
    public RequestResponse createArchiveUnitProfile(VitamContext vitamContext, InputStream archiveUnitProfiles) throws InvalidParseOperationException, AccessExternalClientException {
        RequestResponse requestResponse;
        block9: {
            VitamRequestBuilder request = VitamRequestBuilder.post().withPath(AdminCollections.ARCHIVE_UNIT_PROFILE.getName()).withHeaders(vitamContext.getHeaders()).withBody((Object)archiveUnitProfiles, "The input profile json is mandatory").withJson();
            Response response = this.make(request);
            try {
                this.check(response);
                requestResponse = RequestResponse.parseFromResponse((Response)response);
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (VitamClientInternalException e) {
                    throw new AccessExternalClientException((Throwable)e);
                }
                catch (AdminExternalClientException e) {
                    LOGGER.error((Throwable)((Object)e));
                    return e.getVitamError();
                }
            }
            response.close();
        }
        return requestResponse;
    }

    @Override
    public RequestResponse<ArchiveUnitProfileModel> findArchiveUnitProfileById(VitamContext vitamContext, String id) throws VitamClientException {
        return this.internalFindDocumentById(vitamContext, AdminCollections.ARCHIVE_UNIT_PROFILE, id, ArchiveUnitProfileModel.class);
    }

    @Override
    public RequestResponse<ArchiveUnitProfileModel> findArchiveUnitProfiles(VitamContext vitamContext, JsonNode query) throws VitamClientException {
        return this.internalFindDocuments(vitamContext, AdminCollections.ARCHIVE_UNIT_PROFILE, query, ArchiveUnitProfileModel.class);
    }

    @Override
    public RequestResponse updateArchiveUnitProfile(VitamContext vitamContext, String archiveUnitprofileId, JsonNode queryDSL) throws InvalidParseOperationException, AccessExternalClientException {
        RequestResponse requestResponse;
        block9: {
            VitamRequestBuilder request = VitamRequestBuilder.put().withPath(UPDATE_AU_PROFILE + archiveUnitprofileId).withHeaders(vitamContext.getHeaders()).withBody((Object)queryDSL).withJson();
            Response response = this.make(request);
            try {
                this.check(response);
                requestResponse = RequestResponse.parseFromResponse((Response)response);
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (VitamClientInternalException e) {
                    throw new AccessExternalClientException((Throwable)e);
                }
                catch (AdminExternalClientException e) {
                    LOGGER.error((Throwable)((Object)e));
                    return e.getVitamError();
                }
            }
            response.close();
        }
        return requestResponse;
    }

    @Override
    public RequestResponse importOntologies(boolean forceUpdate, VitamContext vitamContext, InputStream ontologies) throws InvalidParseOperationException, AccessExternalClientException {
        RequestResponse requestResponse;
        block9: {
            VitamRequestBuilder request = VitamRequestBuilder.post().withPath(AdminCollections.ONTOLOGY.getName()).withHeaders(vitamContext.getHeaders()).withHeader("Force-Update", (Object)forceUpdate).withBody((Object)ontologies, "The input ontologies json is mandatory").withJson();
            Response response = this.make(request);
            try {
                this.check(response);
                requestResponse = new RequestResponseOK().setHttpCode(Response.Status.OK.getStatusCode()).addHeader("X-Request-Id", response.getHeaderString("X-Request-Id"));
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (AdminExternalClientException e) {
                    LOGGER.error((Throwable)((Object)e));
                    return e.getVitamError();
                }
                catch (VitamClientInternalException e) {
                    throw new AccessExternalClientException((Throwable)e);
                }
            }
            response.close();
        }
        return requestResponse;
    }

    @Override
    public RequestResponse<OntologyModel> findOntologyById(VitamContext vitamContext, String id) throws VitamClientException {
        return this.internalFindDocumentById(vitamContext, AdminCollections.ONTOLOGY, id, OntologyModel.class);
    }

    @Override
    public RequestResponse<OntologyModel> findOntologies(VitamContext vitamContext, JsonNode query) throws VitamClientException {
        return this.internalFindDocuments(vitamContext, AdminCollections.ONTOLOGY, query, OntologyModel.class);
    }

    @Override
    public RequestResponse importGriffin(VitamContext vitamContext, InputStream griffinStream, String filename) throws AccessExternalClientException {
        return this.internalCreateDocument(vitamContext, AdminCollections.GRIFFIN, griffinStream, filename, MediaType.APPLICATION_JSON_TYPE);
    }

    @Override
    public RequestResponse importPreservationScenario(VitamContext vitamContext, InputStream scenarios, String fileName) throws AccessExternalClientException {
        return this.internalCreateDocument(vitamContext, AdminCollections.PRESERVATION_SCENARIO, scenarios, fileName, MediaType.APPLICATION_JSON_TYPE);
    }

    @Override
    public RequestResponse<GriffinModel> findGriffinById(VitamContext vitamContext, String id) throws VitamClientException {
        return this.internalFindDocumentById(vitamContext, AdminCollections.GRIFFIN, id, GriffinModel.class);
    }

    @Override
    public RequestResponse<PreservationScenarioModel> findPreservationScenarioById(VitamContext vitamContext, String id) throws VitamClientException {
        return this.internalFindDocumentById(vitamContext, AdminCollections.PRESERVATION_SCENARIO, id, PreservationScenarioModel.class);
    }

    @Override
    public RequestResponse<PreservationScenarioModel> findPreservationScenario(VitamContext vitamContext, JsonNode select) throws VitamClientException {
        return this.internalFindDocuments(vitamContext, AdminCollections.PRESERVATION_SCENARIO, select, PreservationScenarioModel.class);
    }

    @Override
    public RequestResponse<GriffinModel> findGriffin(VitamContext vitamContext, JsonNode select) throws VitamClientException {
        return this.internalFindDocuments(vitamContext, AdminCollections.GRIFFIN, select, GriffinModel.class);
    }

    @Override
    public RequestResponse createExternalOperation(VitamContext vitamContext, LogbookOperationParameters logbookOperationparams) throws LogbookExternalClientException {
        RequestResponse requestResponse;
        block9: {
            VitamRequestBuilder request = VitamRequestBuilder.post().withPath("/logbookoperations").withHeaders(vitamContext.getHeaders()).withBody((Object)logbookOperationparams).withJson();
            Response response = this.make(request);
            try {
                this.check(response);
                requestResponse = RequestResponse.parseFromResponse((Response)response);
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (VitamClientInternalException e) {
                    throw new LogbookExternalClientException((Throwable)e);
                }
                catch (AdminExternalClientException e) {
                    LOGGER.error((Throwable)((Object)e));
                    return e.getVitamError();
                }
            }
            response.close();
        }
        return requestResponse;
    }

    @Override
    public RequestResponse<SchemaResponse> getUnitSchema(VitamContext vitamContext) throws VitamClientException {
        VitamRequestBuilder request = VitamRequestBuilder.get().withPath("/schema/unit").withHeaders(vitamContext.getHeaders()).withJson();
        try (Response response = this.make(request);){
            this.check(response);
            RequestResponse requestResponse = RequestResponse.parseFromResponse((Response)response, SchemaResponse.class);
            return requestResponse;
        }
    }

    @Override
    public RequestResponse<CombinedSchemaModel> getArchiveUnitProfileSchema(VitamContext vitamContext, String archiveUnitId) throws VitamClientException {
        VitamRequestBuilder request = VitamRequestBuilder.get().withPath("/archiveunitprofiles/{id}/schema".replace("{id}", archiveUnitId)).withHeaders(vitamContext.getHeaders()).withJson();
        try (Response response = this.make(request);){
            this.check(response);
            RequestResponse requestResponse = RequestResponse.parseFromResponse((Response)response, CombinedSchemaModel.class);
            return requestResponse;
        }
    }

    @Override
    public RequestResponse<Void> importUnitExternalSchema(VitamContext vitamContext, InputStream externalSchema) throws AccessExternalClientException {
        RequestResponse requestResponse;
        block9: {
            VitamRequestBuilder request = VitamRequestBuilder.post().withPath(AdminCollections.UNIT_SCHEMA.getName()).withHeaders(vitamContext.getHeaders()).withBody((Object)externalSchema, "The input schema json is mandatory").withJson();
            Response response = this.make(request);
            try {
                this.check(response);
                requestResponse = new RequestResponseOK().setHttpCode(Response.Status.OK.getStatusCode()).addHeader("X-Request-Id", response.getHeaderString("X-Request-Id"));
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (AdminExternalClientException e) {
                    LOGGER.error((Throwable)((Object)e));
                    return e.getVitamError();
                }
                catch (VitamClientInternalException e) {
                    throw new AccessExternalClientException((Throwable)e);
                }
            }
            response.close();
        }
        return requestResponse;
    }

    @Override
    public RequestResponse<Void> deleteUnitExternalSchemas(VitamContext vitamContext, List<String> externalSchemaPaths) throws InvalidParseOperationException, AccessExternalClientException {
        RequestResponse requestResponse;
        block9: {
            VitamRequestBuilder request = VitamRequestBuilder.delete().withPath(AdminCollections.UNIT_SCHEMA.getName()).withHeaders(vitamContext.getHeaders()).withBody(externalSchemaPaths, "external schema paths is mandatory").withJson();
            Response response = this.make(request);
            try {
                this.check(response);
                requestResponse = new RequestResponseOK().setHttpCode(Response.Status.OK.getStatusCode()).addHeader("X-Request-Id", response.getHeaderString("X-Request-Id"));
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (AdminExternalClientException e) {
                    LOGGER.error((Throwable)((Object)e));
                    return e.getVitamError();
                }
                catch (VitamClientInternalException e) {
                    throw new AccessExternalClientException((Throwable)e);
                }
            }
            response.close();
        }
        return requestResponse;
    }

    @Override
    public RequestResponse<SchemaResponse> getObjectGroupSchema(VitamContext vitamContext) throws VitamClientException {
        VitamRequestBuilder request = VitamRequestBuilder.get().withPath("/schema/objectgroup").withHeaders(vitamContext.getHeaders()).withJson();
        try (Response response = this.make(request);){
            this.check(response);
            RequestResponse requestResponse = RequestResponse.parseFromResponse((Response)response, SchemaResponse.class);
            return requestResponse;
        }
    }

    @Override
    public RequestResponse<PublicConfiguration> getPublicConfiguration(VitamContext vitamContext) throws VitamClientException {
        VitamRequestBuilder request = VitamRequestBuilder.get().withPath("/configuration").withHeaders(vitamContext.getHeaders()).withJsonAccept();
        try (Response response = this.make(request);){
            this.check(response);
            RequestResponse requestResponse = RequestResponse.parseFromResponse((Response)response, PublicConfiguration.class);
            return requestResponse;
        }
    }

    private void check(Response response) throws AdminExternalClientException {
        Response.Status status = response.getStatusInfo().toEnum();
        if (Response.Status.Family.SUCCESSFUL.equals((Object)status.getFamily())) {
            return;
        }
        String message = String.format("Error with the response, get status: '%d' and reason '%s'.", response.getStatus(), Response.Status.fromStatusCode((int)response.getStatus()).getReasonPhrase());
        VitamError vitamError = new VitamError(message).setDescription(message).setHttpCode(status.getStatusCode()).setMessage(message).setState(StatusCode.KO.name()).setContext(ACCESS_EXTERNAL_MODULE);
        vitamError.parseHeadersFromResponse(response);
        throw new AdminExternalClientException(message, status, vitamError);
    }
}

