/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.access.external.client;

import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.access.external.client.AdminExternalClient;
import fr.gouv.vitam.access.external.client.AdminExternalClientMock;
import fr.gouv.vitam.access.external.client.AdminExternalClientRest;
import fr.gouv.vitam.common.PropertiesUtils;
import fr.gouv.vitam.common.client.VitamClientFactoryInterface;
import fr.gouv.vitam.common.client.configuration.ClientConfiguration;
import fr.gouv.vitam.common.external.client.VitamClientFactory;
import fr.gouv.vitam.common.external.client.configuration.SecureClientConfiguration;
import fr.gouv.vitam.common.external.client.configuration.SecureClientConfigurationImpl;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import java.io.File;
import java.io.IOException;

public class AdminExternalClientFactory
extends VitamClientFactory<AdminExternalClient> {
    private static final String CONFIGURATION_FILENAME = "access-external-client.conf";
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(AdminExternalClientFactory.class);
    private static final AdminExternalClientFactory ACCESS_CLIENT_FACTORY = new AdminExternalClientFactory();
    private static final String RESOURCE_PATH = "/admin-external/v1";

    private AdminExternalClientFactory() {
        super((ClientConfiguration)AdminExternalClientFactory.changeConfigurationFile(CONFIGURATION_FILENAME), RESOURCE_PATH);
    }

    public AdminExternalClientFactory(SecureClientConfiguration secureClientConfiguration) {
        super((ClientConfiguration)secureClientConfiguration, RESOURCE_PATH, false);
    }

    public static final AdminExternalClientFactory getInstance() {
        return ACCESS_CLIENT_FACTORY;
    }

    static final SecureClientConfiguration changeConfigurationFile(String configurationPath) {
        SecureClientConfiguration configuration = null;
        try {
            configuration = (SecureClientConfiguration)PropertiesUtils.readYaml((File)PropertiesUtils.findFile((String)configurationPath), SecureClientConfigurationImpl.class);
        }
        catch (IOException fnf) {
            LOGGER.debug("Error when retrieving configuration file {}, using mock", (Object)configurationPath, (Object)fnf);
        }
        if (configuration == null) {
            LOGGER.error("Error when retrieving configuration file {}, using mock", (Object)configurationPath);
        }
        return configuration;
    }

    public AdminExternalClient getClient() {
        return switch (this.getVitamClientType()) {
            case VitamClientFactoryInterface.VitamClientType.MOCK -> new AdminExternalClientMock();
            case VitamClientFactoryInterface.VitamClientType.PRODUCTION -> new AdminExternalClientRest(this);
            default -> throw new IllegalArgumentException("Log type unknown");
        };
    }

    static final void changeMode(ClientConfiguration configuration) {
        AdminExternalClientFactory.getInstance().initialisation(configuration, AdminExternalClientFactory.getInstance().getResourcePath());
    }

    @VisibleForTesting
    public static final void changeModeFromFile(String configurationFile) {
        SecureClientConfiguration configuration = AdminExternalClientFactory.changeConfigurationFile(configurationFile);
        AdminExternalClientFactory.getInstance().initialisation((ClientConfiguration)configuration, AdminExternalClientFactory.getInstance().getResourcePath());
    }
}

