/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.logbook.common.traceability;

import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.security.merkletree.MerkleTreeAlgo;
import fr.gouv.vitam.logbook.common.exception.TraceabilityException;
import fr.gouv.vitam.logbook.common.model.TraceabilityEvent;
import fr.gouv.vitam.logbook.common.model.TraceabilityFile;
import fr.gouv.vitam.logbook.common.model.TraceabilityStatistics;
import fr.gouv.vitam.logbook.common.model.TraceabilityType;
import java.io.File;
import java.io.IOException;
import java.time.LocalDateTime;

public interface LogbookTraceabilityHelper {
    public static final LocalDateTime INITIAL_START_DATE = LocalDateUtil.EPOCH;

    public void saveDataInZip(MerkleTreeAlgo var1, TraceabilityFile var2) throws IOException, TraceabilityException;

    public void startTraceability() throws TraceabilityException;

    public void createLogbookOperationEvent(Integer var1, String var2, StatusCode var3, TraceabilityEvent var4) throws TraceabilityException;

    public void storeAndDeleteZip(Integer var1, String var2, File var3, String var4, TraceabilityEvent var5) throws TraceabilityException;

    public TraceabilityType getTraceabilityType();

    public String getStepName();

    public String getTimestampStepName();

    public String getZipName();

    public String getTraceabilityStartDate() throws TraceabilityException;

    public String getTraceabilityEndDate() throws TraceabilityException;

    public long getDataSize() throws TraceabilityException;

    public byte[] getPreviousTimestampToken() throws InvalidParseOperationException;

    public byte[] getPreviousMonthTimestampToken() throws InvalidParseOperationException, TraceabilityException;

    public byte[] getPreviousYearTimestampToken() throws InvalidParseOperationException, TraceabilityException;

    public String getPreviousStartDate() throws InvalidParseOperationException;

    public String getPreviousMonthStartDate() throws InvalidParseOperationException, TraceabilityException;

    public String getPreviousYearStartDate() throws InvalidParseOperationException, TraceabilityException;

    public void saveEmpty(Integer var1) throws TraceabilityException;

    public boolean getMaxEntriesReached();

    public TraceabilityStatistics getTraceabilityStatistics();
}

