/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.logbook.common.parameters;

import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.guid.GUID;
import fr.gouv.vitam.common.i18n.VitamLogbookMessages;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.model.VitamSession;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import fr.gouv.vitam.logbook.common.parameters.LogbookLifeCycleObjectGroupParameters;
import fr.gouv.vitam.logbook.common.parameters.LogbookLifeCycleUnitParameters;
import fr.gouv.vitam.logbook.common.parameters.LogbookOperationParameters;
import fr.gouv.vitam.logbook.common.parameters.LogbookParameterName;
import fr.gouv.vitam.logbook.common.parameters.LogbookParametersFactory;
import fr.gouv.vitam.logbook.common.parameters.LogbookTypeProcess;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class LogbookParameterHelper {
    private static final String NO_PARAMETER_CAN_BE_NULL_OR_EMPTY = "No parameter can be null or empty";
    private static final Set<LogbookParameterName> genericMandatoryOperation;
    private static final Set<LogbookParameterName> genericMandatoryLifeCycle;

    private LogbookParameterHelper() {
    }

    static LogbookOperationParameters newLogbookOperationParameters(Set<LogbookParameterName> mandatoryFieldsToAdd) {
        return new LogbookOperationParameters(LogbookParameterHelper.initLogbookOperationMandatoriesParameters(mandatoryFieldsToAdd));
    }

    static LogbookLifeCycleUnitParameters newLogbookLifeCycleUnitParameters(Set<LogbookParameterName> mandatoryFieldsToAdd) {
        return new LogbookLifeCycleUnitParameters(LogbookParameterHelper.initLogbookLifeCycleMandatoriesParameters(mandatoryFieldsToAdd));
    }

    static LogbookLifeCycleObjectGroupParameters newLogbookLifeCycleObjectGroupParameters(Set<LogbookParameterName> mandatoryFieldsToAdd) {
        return new LogbookLifeCycleObjectGroupParameters(LogbookParameterHelper.initLogbookLifeCycleMandatoriesParameters(mandatoryFieldsToAdd));
    }

    public static LogbookOperationParameters newLogbookOperationParameters() {
        return new LogbookOperationParameters(LogbookParameterHelper.initLogbookOperationMandatoriesParameters(null));
    }

    public static LogbookLifeCycleUnitParameters newLogbookLifeCycleUnitParameters() {
        return new LogbookLifeCycleUnitParameters(LogbookParameterHelper.initLogbookLifeCycleMandatoriesParameters(null));
    }

    public static LogbookLifeCycleObjectGroupParameters newLogbookLifeCycleObjectGroupParameters() {
        return new LogbookLifeCycleObjectGroupParameters(LogbookParameterHelper.initLogbookLifeCycleMandatoriesParameters(null));
    }

    public static LogbookOperationParameters newLogbookOperationParameters(GUID eventIdentifier, String eventType, GUID eventIdentifierProcess, LogbookTypeProcess eventTypeProcess, StatusCode outcome, String outcomeDetailMessage, GUID eventIdentifierRequest) {
        return LogbookParameterHelper.newLogbookOperationParameters(eventIdentifier.getId(), eventType, eventIdentifierProcess != null ? eventIdentifierProcess.getId() : null, eventTypeProcess, outcome, outcomeDetailMessage, eventIdentifierRequest.getId());
    }

    public static LogbookOperationParameters newLogbookOperationParameters(String eventIdentifier, String eventType, String eventIdentifierProcess, LogbookTypeProcess eventTypeProcess, StatusCode outcome, String outcomeDetailMessage, String eventIdentifierRequest) {
        ParametersChecker.checkParameter((String)NO_PARAMETER_CAN_BE_NULL_OR_EMPTY, (Object[])new Object[]{eventIdentifier, eventIdentifierProcess, eventIdentifierRequest, outcome, eventTypeProcess});
        ParametersChecker.checkParameter((String)NO_PARAMETER_CAN_BE_NULL_OR_EMPTY, (String[])new String[]{eventType, outcomeDetailMessage});
        LogbookOperationParameters parameters = LogbookParameterHelper.newLogbookOperationParameters();
        VitamSession vitamSession = VitamThreadUtils.getVitamSession();
        String applicationSessionId = vitamSession.getApplicationSessionId();
        String contextId = vitamSession.getContextId();
        String personalCertificate = vitamSession.getPersonalCertificate();
        return (LogbookOperationParameters)parameters.putParameterValue(LogbookParameterName.eventIdentifier, eventIdentifier).putParameterValue(LogbookParameterName.eventType, eventType).putParameterValue(LogbookParameterName.eventIdentifierProcess, eventIdentifierProcess).setTypeProcess(eventTypeProcess).setStatus(outcome).putParameterValue(LogbookParameterName.outcomeDetailMessage, outcomeDetailMessage).putParameterValue(LogbookParameterName.eventIdentifierRequest, eventIdentifierRequest).putParameterValue(LogbookParameterName.outcomeDetail, VitamLogbookMessages.getOutcomeDetail((String)eventType, (StatusCode)outcome)).putParameterValue(LogbookParameterName.objectIdentifier, eventIdentifierProcess).putParameterValue(LogbookParameterName.agentIdentifierApplication, contextId).putParameterValue(LogbookParameterName.agentIdentifierApplicationSession, applicationSessionId).putParameterValue(LogbookParameterName.agentIdentifierPersonae, personalCertificate);
    }

    public static LogbookOperationParameters newLogbookOperationParameters(String eventIdentifier, String eventType, GUID eventIdentifierProcess, LogbookTypeProcess eventTypeProcess, StatusCode outcome, String outcomeDetailMessage, String eventIdentifierRequest) {
        ParametersChecker.checkParameter((String)NO_PARAMETER_CAN_BE_NULL_OR_EMPTY, (Object[])new Object[]{eventIdentifier, eventIdentifierProcess, eventIdentifierRequest, outcome, eventTypeProcess});
        ParametersChecker.checkParameter((String)NO_PARAMETER_CAN_BE_NULL_OR_EMPTY, (String[])new String[]{eventType, outcomeDetailMessage});
        LogbookOperationParameters parameters = LogbookParameterHelper.newLogbookOperationParameters();
        VitamSession vitamSession = VitamThreadUtils.getVitamSession();
        String applicationSessionId = vitamSession.getApplicationSessionId();
        String contextId = vitamSession.getContextId();
        String personalCertificate = vitamSession.getPersonalCertificate();
        return (LogbookOperationParameters)parameters.putParameterValue(LogbookParameterName.eventIdentifier, eventIdentifier).putParameterValue(LogbookParameterName.eventType, eventType).putParameterValue(LogbookParameterName.eventIdentifierProcess, eventIdentifierProcess.getId()).setTypeProcess(eventTypeProcess).setStatus(outcome).putParameterValue(LogbookParameterName.outcomeDetailMessage, outcomeDetailMessage).putParameterValue(LogbookParameterName.eventIdentifierRequest, eventIdentifierRequest).putParameterValue(LogbookParameterName.outcomeDetail, VitamLogbookMessages.getOutcomeDetail((String)eventType, (StatusCode)outcome)).putParameterValue(LogbookParameterName.objectIdentifier, eventIdentifierProcess.getId()).putParameterValue(LogbookParameterName.agentIdentifierApplication, contextId).putParameterValue(LogbookParameterName.agentIdentifierApplicationSession, applicationSessionId).putParameterValue(LogbookParameterName.agentIdentifierPersonae, personalCertificate);
    }

    public static LogbookOperationParameters newLogbookOperationParameters(GUID eventIdentifier, String eventType, GUID eventIdentifierProcess, LogbookTypeProcess eventTypeProcess, StatusCode outcome, String subtask, String appendedDetailMessage, GUID eventIdentifierRequest) {
        ParametersChecker.checkParameter((String)NO_PARAMETER_CAN_BE_NULL_OR_EMPTY, (Object[])new Object[]{eventIdentifier, eventIdentifierProcess, eventIdentifierRequest, outcome, eventTypeProcess});
        ParametersChecker.checkParameter((String)NO_PARAMETER_CAN_BE_NULL_OR_EMPTY, (String[])new String[]{eventType});
        VitamSession vitamSession = VitamThreadUtils.getVitamSession();
        String applicationSessionId = vitamSession.getApplicationSessionId();
        String contextId = vitamSession.getContextId();
        LogbookOperationParameters parameters = LogbookParameterHelper.newLogbookOperationParameters();
        parameters.putParameterValue(LogbookParameterName.eventIdentifier, eventIdentifier.getId()).putParameterValue(LogbookParameterName.eventIdentifierProcess, eventIdentifierProcess.getId()).setTypeProcess(eventTypeProcess).putParameterValue(LogbookParameterName.eventIdentifierRequest, eventIdentifierRequest.getId()).putParameterValue(LogbookParameterName.agentIdentifierApplication, contextId).putParameterValue(LogbookParameterName.agentIdentifierApplicationSession, applicationSessionId);
        parameters.setFinalStatus(eventType, subtask, outcome, appendedDetailMessage, new String[0]);
        return parameters;
    }

    public static LogbookLifeCycleUnitParameters newLogbookLifeCycleUnitParameters(GUID eventIdentifier, String eventType, GUID eventIdentifierProcess, LogbookTypeProcess eventTypeProcess, StatusCode outcome, String outcomeDetail, String outcomeDetailMessage, GUID objectIdentifier) {
        ParametersChecker.checkParameter((String)NO_PARAMETER_CAN_BE_NULL_OR_EMPTY, (Object[])new Object[]{eventIdentifier, eventIdentifierProcess, eventTypeProcess, outcome, objectIdentifier});
        ParametersChecker.checkParameter((String)NO_PARAMETER_CAN_BE_NULL_OR_EMPTY, (String[])new String[]{eventType, outcomeDetail, outcomeDetailMessage});
        LogbookLifeCycleUnitParameters parameters = LogbookParameterHelper.newLogbookLifeCycleUnitParameters();
        return (LogbookLifeCycleUnitParameters)parameters.putParameterValue(LogbookParameterName.eventIdentifier, eventIdentifier.getId()).putParameterValue(LogbookParameterName.eventType, eventType).putParameterValue(LogbookParameterName.eventIdentifierProcess, eventIdentifierProcess.getId()).setTypeProcess(eventTypeProcess).setStatus(outcome).putParameterValue(LogbookParameterName.outcomeDetail, outcomeDetail).putParameterValue(LogbookParameterName.outcomeDetailMessage, outcomeDetailMessage).putParameterValue(LogbookParameterName.objectIdentifier, objectIdentifier.getId());
    }

    public static LogbookLifeCycleObjectGroupParameters newLogbookLifeCycleObjectGroupParameters(GUID eventIdentifier, String eventType, GUID eventIdentifierProcess, LogbookTypeProcess eventTypeProcess, StatusCode outcome, String outcomeDetail, String outcomeDetailMessage, GUID objectIdentifier) {
        ParametersChecker.checkParameter((String)NO_PARAMETER_CAN_BE_NULL_OR_EMPTY, (Object[])new Object[]{eventIdentifier, eventIdentifierProcess, eventTypeProcess, outcome, objectIdentifier});
        ParametersChecker.checkParameter((String)NO_PARAMETER_CAN_BE_NULL_OR_EMPTY, (String[])new String[]{eventType, outcomeDetail, outcomeDetailMessage});
        LogbookLifeCycleObjectGroupParameters parameters = LogbookParameterHelper.newLogbookLifeCycleObjectGroupParameters();
        return (LogbookLifeCycleObjectGroupParameters)parameters.putParameterValue(LogbookParameterName.eventIdentifier, eventIdentifier.getId()).putParameterValue(LogbookParameterName.eventType, eventType).putParameterValue(LogbookParameterName.eventIdentifierProcess, eventIdentifierProcess.getId()).setTypeProcess(eventTypeProcess).setStatus(outcome).putParameterValue(LogbookParameterName.outcomeDetail, outcomeDetail).putParameterValue(LogbookParameterName.outcomeDetailMessage, outcomeDetailMessage).putParameterValue(LogbookParameterName.objectIdentifier, objectIdentifier.getId());
    }

    public static Set<LogbookParameterName> getDefaultLifeCycleMandatory() {
        return Collections.unmodifiableSet(new HashSet<LogbookParameterName>(genericMandatoryLifeCycle));
    }

    private static Set<LogbookParameterName> initLogbookOperationMandatoriesParameters(Set<LogbookParameterName> mandatoryFieldsToAdd) {
        HashSet<LogbookParameterName> mandatory = new HashSet<LogbookParameterName>(genericMandatoryOperation);
        if (mandatoryFieldsToAdd != null) {
            mandatory.addAll(mandatoryFieldsToAdd);
        }
        return Collections.unmodifiableSet(mandatory);
    }

    private static Set<LogbookParameterName> initLogbookLifeCycleMandatoriesParameters(Set<LogbookParameterName> mandatoryFieldsToAdd) {
        HashSet<LogbookParameterName> mandatory = new HashSet<LogbookParameterName>(genericMandatoryLifeCycle);
        if (mandatoryFieldsToAdd != null) {
            mandatory.addAll(mandatoryFieldsToAdd);
        }
        return Collections.unmodifiableSet(mandatory);
    }

    static {
        genericMandatoryLifeCycle = new HashSet<LogbookParameterName>();
        genericMandatoryOperation = LogbookParametersFactory.getDefaultOperationMandatory();
        genericMandatoryLifeCycle.add(LogbookParameterName.eventIdentifier);
        genericMandatoryLifeCycle.add(LogbookParameterName.eventType);
        genericMandatoryLifeCycle.add(LogbookParameterName.eventIdentifierProcess);
        genericMandatoryLifeCycle.add(LogbookParameterName.eventTypeProcess);
        genericMandatoryLifeCycle.add(LogbookParameterName.outcome);
        genericMandatoryLifeCycle.add(LogbookParameterName.outcomeDetail);
        genericMandatoryLifeCycle.add(LogbookParameterName.outcomeDetailMessage);
        genericMandatoryLifeCycle.add(LogbookParameterName.objectIdentifier);
    }
}

