/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.logbook.common.model;

import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.security.merkletree.MerkleTree;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;

public class TraceabilityFile
implements AutoCloseable {
    public static final String previousTimestampToken = "previousTimestampToken";
    public static final String previousTimestampTokenMinusOneMonth = "previousTimestampTokenMinusOneMonth";
    public static final String previousTimestampTokenMinusOneYear = "previousTimestampTokenMinusOneYear";
    public static final String currentHash = "currentHash";
    private static final String EXTRACT_FILENAME = "data.txt";
    private static final String ADDITIONAL_INFORMATION_FILENAME = "additional_information.txt";
    private static final String COMPUTING_INFORMATION_FILENAME = "computing_information.txt";
    private static final String MEKLE_TREE_FILENAME = "merkleTree.json";
    private static final String TIMESTAMP_FILENAME = "token.tsp";
    static final String SECURISATION_VERSION_LABEL = "securisationVersion";
    private static final String SECURISATION_VERSION = "V1";
    private static final byte[] LINE_SEPARATOR = "\n".getBytes();
    private final ZipArchiveOutputStream archive;
    private final String extractedDataFileName;

    public TraceabilityFile(File file) throws FileNotFoundException, ArchiveException {
        BufferedOutputStream archiveStream = new BufferedOutputStream(new FileOutputStream(file));
        this.archive = (ZipArchiveOutputStream)new ArchiveStreamFactory().createArchiveOutputStream("zip", (OutputStream)archiveStream);
        this.archive.setLevel(0);
        this.extractedDataFileName = EXTRACT_FILENAME;
    }

    public void storeMerkleTree(MerkleTree merkleTree) throws IOException {
        ZipArchiveEntry entry = new ZipArchiveEntry(MEKLE_TREE_FILENAME);
        this.archive.putArchiveEntry(entry);
        this.archive.write(JsonHandler.unprettyPrint((Object)merkleTree).getBytes(StandardCharsets.UTF_8));
        this.archive.closeArchiveEntry();
    }

    public void storeTimeStampToken(byte[] timestampToken) throws IOException {
        ZipArchiveEntry entry = new ZipArchiveEntry(TIMESTAMP_FILENAME);
        this.archive.putArchiveEntry(entry);
        byte[] encodeBase64 = Base64.encodeBase64((byte[])timestampToken);
        this.archive.write(encodeBase64);
        this.archive.closeArchiveEntry();
    }

    public void initStoreLog() throws IOException {
        ZipArchiveEntry entry = new ZipArchiveEntry(this.extractedDataFileName);
        this.archive.putArchiveEntry(entry);
    }

    public void storeLog(byte[] line) throws IOException {
        this.archive.write(line);
        this.archive.write(LINE_SEPARATOR);
    }

    public void closeStoreLog() throws IOException {
        this.archive.closeArchiveEntry();
    }

    public void storeAdditionalInformation(long numberOfLine, String startDate, String endDate) throws IOException {
        ZipArchiveEntry entry = new ZipArchiveEntry(ADDITIONAL_INFORMATION_FILENAME);
        this.archive.putArchiveEntry(entry);
        this.archive.write(String.format("numberOfElements=%d", numberOfLine).getBytes());
        this.archive.write(LINE_SEPARATOR);
        this.archive.write(String.format("startDate=%s", startDate).getBytes());
        this.archive.write(LINE_SEPARATOR);
        this.archive.write(String.format("endDate=%s", endDate).getBytes());
        this.archive.write(LINE_SEPARATOR);
        this.archive.write("securisationVersion=V1".getBytes());
        this.archive.write(LINE_SEPARATOR);
        this.archive.closeArchiveEntry();
    }

    public void storeComputedInformation(String currentHash, String previousHash, String currentHashMinusOneMonth, String currentHashMinusOneYear) throws IOException {
        ZipArchiveEntry entry = new ZipArchiveEntry(COMPUTING_INFORMATION_FILENAME);
        this.archive.putArchiveEntry(entry);
        this.archive.write(String.format("currentHash=%s", currentHash).getBytes());
        this.archive.write(LINE_SEPARATOR);
        this.archive.write(String.format("previousTimestampToken=%s", previousHash).getBytes());
        this.archive.write(LINE_SEPARATOR);
        this.archive.write(String.format("previousTimestampTokenMinusOneMonth=%s", currentHashMinusOneMonth).getBytes());
        this.archive.write(LINE_SEPARATOR);
        this.archive.write(String.format("previousTimestampTokenMinusOneYear=%s", currentHashMinusOneYear).getBytes());
        this.archive.write(LINE_SEPARATOR);
        this.archive.closeArchiveEntry();
    }

    @Override
    public void close() throws IOException {
        this.archive.flush();
        this.archive.close();
    }
}

