/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.logbook.operations.client;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.client.AbstractMockClient;
import fr.gouv.vitam.common.client.ClientMockResultHelper;
import fr.gouv.vitam.common.database.index.model.ReindexationOK;
import fr.gouv.vitam.common.database.index.model.ReindexationResult;
import fr.gouv.vitam.common.database.index.model.SwitchIndexResult;
import fr.gouv.vitam.common.database.parameter.IndexParameters;
import fr.gouv.vitam.common.database.parameter.SwitchIndexParameters;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.parameter.VitamParameter;
import fr.gouv.vitam.logbook.common.client.ErrorMessage;
import fr.gouv.vitam.logbook.common.exception.LogbookClientAlreadyExistsException;
import fr.gouv.vitam.logbook.common.exception.LogbookClientBadRequestException;
import fr.gouv.vitam.logbook.common.exception.LogbookClientException;
import fr.gouv.vitam.logbook.common.exception.LogbookClientNotFoundException;
import fr.gouv.vitam.logbook.common.exception.LogbookClientServerException;
import fr.gouv.vitam.logbook.common.model.AuditLogbookOptions;
import fr.gouv.vitam.logbook.common.model.LifecycleTraceabilityStatus;
import fr.gouv.vitam.logbook.common.model.TenantLogbookOperationTraceabilityResult;
import fr.gouv.vitam.logbook.common.model.coherence.LogbookCheckResult;
import fr.gouv.vitam.logbook.common.model.reconstruction.ReconstructionRequestItem;
import fr.gouv.vitam.logbook.common.parameters.LogbookOperationParameters;
import fr.gouv.vitam.logbook.common.parameters.LogbookOperationsClientHelper;
import fr.gouv.vitam.logbook.common.parameters.LogbookParameters;
import fr.gouv.vitam.logbook.operations.client.LogbookOperationsClient;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class LogbookOperationsClientMock
extends AbstractMockClient
implements LogbookOperationsClient {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(LogbookOperationsClientMock.class);
    private static final String UPDATE = "UPDATE";
    private static final String CREATE = "CREATE";
    private static final String GUID_EXAMPLE = "aeaqaaaaaeaaaaakaarp4akuuf2ldmyaaaaq";

    @Override
    public void create(LogbookOperationParameters ... parameters) throws LogbookClientBadRequestException, LogbookClientAlreadyExistsException, LogbookClientServerException {
        ParametersChecker.checkNullOrEmptyParameters((VitamParameter[])parameters);
        LogbookOperationsClientHelper.checkLogbookParameters((LogbookOperationParameters)parameters[0]);
        this.logInformation(CREATE, (LogbookParameters)parameters[0]);
    }

    @Override
    public void update(LogbookOperationParameters ... parameters) throws LogbookClientBadRequestException, LogbookClientNotFoundException, LogbookClientServerException {
        ParametersChecker.checkNullOrEmptyParameters((VitamParameter[])parameters);
        LogbookOperationsClientHelper.checkLogbookParameters((LogbookOperationParameters)parameters[0]);
        this.logInformation(UPDATE, (LogbookParameters)parameters[0]);
    }

    private void logInformation(String operation, LogbookParameters parameters) {
        String result;
        try {
            result = JsonHandler.writeAsString((Object)parameters);
        }
        catch (InvalidParseOperationException e) {
            LOGGER.error("Cannot serialize parameters", (Throwable)e);
            result = "{}";
        }
        LOGGER.info(operation + ":" + result);
    }

    @Override
    public JsonNode selectOperation(JsonNode select) throws LogbookClientException, InvalidParseOperationException {
        LOGGER.debug("Select request:" + String.valueOf(select));
        return ClientMockResultHelper.getLogbookResults();
    }

    @Override
    public JsonNode selectOperation(JsonNode select, boolean isSliced, boolean isCrossTenant) throws LogbookClientException, InvalidParseOperationException {
        return ClientMockResultHelper.getLogbookResults();
    }

    @Override
    public JsonNode selectOperationById(String processId, JsonNode query, boolean isSliced, boolean isCrossTenant) throws LogbookClientException, InvalidParseOperationException {
        return ClientMockResultHelper.getLogbookOperation();
    }

    @Override
    public JsonNode selectOperationById(String id) throws LogbookClientException, InvalidParseOperationException {
        LOGGER.debug("Select request with id:" + id);
        return ClientMockResultHelper.getLogbookOperation();
    }

    @Override
    public RequestResponseOK<TenantLogbookOperationTraceabilityResult> traceability(List<Integer> tenants) {
        return new RequestResponseOK();
    }

    @Override
    public void create(String eventIdProc, Iterable<LogbookOperationParameters> queue) throws LogbookClientBadRequestException {
        if (queue != null) {
            Iterator<LogbookOperationParameters> iterator = queue.iterator();
            if (iterator.hasNext()) {
                this.logInformation(CREATE, (LogbookParameters)iterator.next());
                while (iterator.hasNext()) {
                    this.logInformation(UPDATE, (LogbookParameters)iterator.next());
                }
            }
        } else {
            LOGGER.error(eventIdProc + " " + ErrorMessage.LOGBOOK_MISSING_MANDATORY_PARAMETER.getMessage());
            throw new LogbookClientBadRequestException(ErrorMessage.LOGBOOK_MISSING_MANDATORY_PARAMETER.getMessage());
        }
    }

    @Override
    public void update(String eventIdProc, Iterable<LogbookOperationParameters> queue) throws LogbookClientBadRequestException {
        if (queue != null) {
            for (LogbookOperationParameters logbookOperationParameters : queue) {
                this.logInformation(UPDATE, (LogbookParameters)logbookOperationParameters);
            }
        } else {
            LOGGER.error(eventIdProc + " " + ErrorMessage.LOGBOOK_MISSING_MANDATORY_PARAMETER.getMessage());
            throw new LogbookClientBadRequestException(ErrorMessage.LOGBOOK_MISSING_MANDATORY_PARAMETER.getMessage());
        }
    }

    @Override
    public RequestResponseOK<String> traceabilityLfcUnit() {
        LOGGER.debug("calling traceability LFC unit");
        ArrayList<String> resultAsJson = new ArrayList<String>();
        resultAsJson.add(GUID_EXAMPLE);
        return new RequestResponseOK().addAllResults(resultAsJson);
    }

    @Override
    public RequestResponseOK<String> traceabilityLfcObjectGroup() {
        LOGGER.debug("calling traceability LFC ObjectGroup");
        ArrayList<String> resultAsJson = new ArrayList<String>();
        resultAsJson.add(GUID_EXAMPLE);
        return new RequestResponseOK().addAllResults(resultAsJson);
    }

    @Override
    public ReindexationResult reindex(IndexParameters indexParam) throws InvalidParseOperationException {
        return new ReindexationResult().setCollectionName(indexParam.getCollectionName()).addIndexOK(new ReindexationOK("alias", "indexname", indexParam.getTenants(), ""));
    }

    @Override
    public SwitchIndexResult switchIndexes(SwitchIndexParameters switchIndexParam) throws InvalidParseOperationException {
        return new SwitchIndexResult().setAlias(switchIndexParam.getAlias()).setIndexName(switchIndexParam.getIndexName()).setStatusCode(StatusCode.OK);
    }

    @Override
    public void traceabilityAudit(int tenant, AuditLogbookOptions options) {
        LOGGER.info("audit traceability");
    }

    @Override
    public LogbookCheckResult checkLogbookCoherence() {
        return new LogbookCheckResult();
    }

    @Override
    public RequestResponse<JsonNode> getLastOperationByType(String operationType) {
        throw new IllegalStateException("Stop using mocks in production");
    }

    @Override
    public void reconstructCollection(List<ReconstructionRequestItem> reconstructionItems) throws LogbookClientServerException {
        throw new IllegalStateException("Stop using mocks in production");
    }

    @Override
    public LifecycleTraceabilityStatus checkLifecycleTraceabilityWorkflowStatus(String operationId) {
        throw new IllegalStateException("Stop using mocks in production");
    }
}

