/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.security.internal.rest.service;

import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.guid.GUIDFactory;
import fr.gouv.vitam.security.internal.common.model.CertificateStatus;
import fr.gouv.vitam.security.internal.common.model.IdentityInsertModel;
import fr.gouv.vitam.security.internal.common.model.IdentityModel;
import fr.gouv.vitam.security.internal.common.service.X509PKIUtil;
import fr.gouv.vitam.security.internal.rest.repository.CertificateRepository;
import fr.gouv.vitam.security.internal.rest.repository.IdentityRepository;
import fr.gouv.vitam.security.internal.rest.service.SecurityService;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;
import java.util.Optional;

public class IdentityService
extends SecurityService {
    private final IdentityRepository identityRepository;

    public IdentityService(IdentityRepository identityRepository) {
        this.identityRepository = identityRepository;
    }

    public void createIdentity(IdentityInsertModel identityInsertModel) throws CertificateException, InvalidParseOperationException {
        IdentityModel identityModel = new IdentityModel();
        identityModel.setId(GUIDFactory.newGUID().toString());
        identityModel.setContextId(identityInsertModel.getContextId());
        identityModel.setCertificate(identityInsertModel.getCertificate());
        identityModel.setCertificateStatus(CertificateStatus.VALID);
        X509Certificate certificate = X509PKIUtil.parseX509Certificate((byte[])identityInsertModel.getCertificate());
        identityModel.setSubjectDN(certificate.getSubjectDN().getName());
        identityModel.setIssuerDN(certificate.getIssuerDN().getName());
        identityModel.setSerialNumber(String.valueOf(certificate.getSerialNumber()));
        identityModel.setExpirationDate(LocalDateUtil.getFormattedDateTimeForMongo((LocalDateTime)LocalDateUtil.fromDate((Date)certificate.getNotAfter())));
        this.identityRepository.createIdentity(identityModel);
    }

    public Optional<IdentityModel> linkContextToIdentity(IdentityInsertModel identityInsertModel) throws CertificateException, InvalidParseOperationException {
        X509Certificate x509Certificate = X509PKIUtil.parseX509Certificate((byte[])identityInsertModel.getCertificate());
        Optional<IdentityModel> identityModel = this.identityRepository.findIdentity(x509Certificate.getSubjectDN().getName(), String.valueOf(x509Certificate.getSerialNumber()));
        identityModel.ifPresent(identity -> {
            identity.setContextId(identityInsertModel.getContextId());
            this.identityRepository.linkContextToIdentity(identity.getSubjectDN(), identity.getContextId(), identity.getSerialNumber());
        });
        return identityModel;
    }

    public Optional<IdentityModel> findIdentity(byte[] certificate) throws CertificateException, InvalidParseOperationException {
        X509Certificate x509Certificate = X509PKIUtil.parseX509Certificate((byte[])certificate);
        Optional<IdentityModel> identityModelOptional = this.identityRepository.findIdentity(x509Certificate.getSubjectDN().getName(), String.valueOf(x509Certificate.getSerialNumber()));
        if (identityModelOptional.isPresent()) {
            X509PKIUtil.parseX509Certificate((byte[])identityModelOptional.get().getCertificate());
        }
        return identityModelOptional;
    }

    public List<IdentityModel> findAllIdentities() throws InvalidParseOperationException {
        return this.identityRepository.findAll();
    }

    public boolean contextIsUsed(String contextId) {
        return this.identityRepository.contextIsUsed(contextId);
    }

    @Override
    public CertificateRepository getRepository() {
        return this.identityRepository;
    }
}

