/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.security.internal.rest.server;

import com.fasterxml.jackson.jakarta.rs.base.JsonParseExceptionMapper;
import com.mongodb.client.MongoClient;
import fr.gouv.vitam.common.PropertiesUtils;
import fr.gouv.vitam.common.database.server.mongodb.MongoDbAccess;
import fr.gouv.vitam.common.database.server.mongodb.SimpleMongoDBAccess;
import fr.gouv.vitam.common.server.application.configuration.DbConfiguration;
import fr.gouv.vitam.common.server.application.resources.ApplicationStatusResource;
import fr.gouv.vitam.common.serverv2.ConfigurationApplication;
import fr.gouv.vitam.common.serverv2.application.CommonBusinessApplication;
import fr.gouv.vitam.logbook.operations.client.LogbookOperationsClientFactory;
import fr.gouv.vitam.security.internal.rest.mapper.CertificateExceptionMapper;
import fr.gouv.vitam.security.internal.rest.mapper.IllegalArgumentExceptionMapper;
import fr.gouv.vitam.security.internal.rest.mapper.PersonalCertificateExceptionMapper;
import fr.gouv.vitam.security.internal.rest.repository.IdentityRepository;
import fr.gouv.vitam.security.internal.rest.repository.PersonalRepository;
import fr.gouv.vitam.security.internal.rest.resource.CertificateResource;
import fr.gouv.vitam.security.internal.rest.resource.IdentityResource;
import fr.gouv.vitam.security.internal.rest.resource.PersonalCertificateResource;
import fr.gouv.vitam.security.internal.rest.server.InternalSecurityConfiguration;
import fr.gouv.vitam.security.internal.rest.server.PersonalCertificatePermissionConfig;
import fr.gouv.vitam.security.internal.rest.server.PersonalCertificatePermissionConfigLoader;
import fr.gouv.vitam.security.internal.rest.service.IdentityService;
import fr.gouv.vitam.security.internal.rest.service.PermissionService;
import fr.gouv.vitam.security.internal.rest.service.PersonalCertificateService;
import jakarta.servlet.ServletConfig;
import jakarta.ws.rs.core.Context;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;

public class BusinessApplication
extends ConfigurationApplication {
    private final Set<Object> singletons;

    public BusinessApplication(@Context ServletConfig servletConfig) {
        String configurationFile = servletConfig.getInitParameter("vitam.configurationFile");
        this.singletons = new HashSet<Object>();
        try (InputStream yamlIS = PropertiesUtils.getConfigAsStream((String)configurationFile);){
            InternalSecurityConfiguration configuration = (InternalSecurityConfiguration)((Object)PropertiesUtils.readYaml((InputStream)yamlIS, InternalSecurityConfiguration.class));
            PersonalCertificatePermissionConfig personalCertificatePermissionConfig = PersonalCertificatePermissionConfigLoader.loadPersonalCertificatePermissionConfig(configuration.getPersonalCertificatePermissionConfig());
            MongoClient mongoClient = MongoDbAccess.createMongoClient((DbConfiguration)configuration);
            SimpleMongoDBAccess mongoDbAccess = new SimpleMongoDBAccess(mongoClient, configuration.getDbName());
            IdentityRepository identityRepository = new IdentityRepository((MongoDbAccess)mongoDbAccess);
            IdentityService identityService = new IdentityService(identityRepository);
            PersonalRepository personalRepository = new PersonalRepository((MongoDbAccess)mongoDbAccess);
            PersonalCertificateService personalCertificateService = new PersonalCertificateService(LogbookOperationsClientFactory.getInstance(), personalRepository);
            PermissionService permissionService = new PermissionService(personalCertificatePermissionConfig);
            CommonBusinessApplication commonBusinessApplication = new CommonBusinessApplication();
            this.singletons.addAll(commonBusinessApplication.getResources());
            this.singletons.add(new IdentityResource(identityService));
            this.singletons.add(new PersonalCertificateResource(permissionService, personalCertificateService));
            this.singletons.add(new CertificateResource(identityService, personalCertificateService));
            this.singletons.add(new CertificateExceptionMapper());
            this.singletons.add(new IllegalArgumentExceptionMapper());
            this.singletons.add(new JsonParseExceptionMapper());
            this.singletons.add(new PersonalCertificateExceptionMapper());
            this.singletons.add(new ApplicationStatusResource());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Set<Object> getSingletons() {
        return this.singletons;
    }
}

