/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.security.internal.rest.resource;

import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.security.internal.common.model.IdentityModel;
import fr.gouv.vitam.security.internal.rest.service.IdentityService;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.security.cert.CertificateException;
import java.text.ParseException;

@Path(value="/v1/api/identity")
@Tag(name="Security")
public class IdentityResource {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(IdentityResource.class);
    private final IdentityService identityService;

    public IdentityResource(IdentityService identityService) {
        this.identityService = identityService;
    }

    @GET
    @Consumes(value={"application/octet-stream"})
    @Produces(value={"application/json"})
    public IdentityModel findIdentityByCertificate(byte[] certificate) throws InvalidParseOperationException, CertificateException {
        return this.identityService.findIdentity(certificate).orElseThrow(NotFoundException::new);
    }

    @GET
    @Path(value="context/{contextId}")
    @Produces(value={"application/json"})
    public Response contextIsUsed(@PathParam(value="contextId") String contextId) {
        return Response.ok().entity((Object)this.identityService.contextIsUsed(contextId)).build();
    }

    @GET
    @Path(value="/check-expiration")
    @Produces(value={"application/json"})
    public Response checkCertificatesExpiration() {
        try {
            this.identityService.checkCertificates();
        }
        catch (InvalidParseOperationException | ParseException e) {
            LOGGER.error("cannot check certificate expiration date", e);
            return Response.serverError().build();
        }
        return Response.accepted().build();
    }
}

