/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.security.internal.rest.resource;

import fr.gouv.vitam.common.alert.AlertService;
import fr.gouv.vitam.common.alert.AlertServiceImpl;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.security.internal.rest.service.IdentityService;
import fr.gouv.vitam.security.internal.rest.service.PersonalCertificateService;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.text.ParseException;

@Path(value="/v1/api/certificate")
public class CertificateResource {
    private final IdentityService identityService;
    private final PersonalCertificateService personalCertificateService;
    private final AlertService alertService;

    public CertificateResource(IdentityService identityService, PersonalCertificateService personalCertificateService) {
        this(identityService, personalCertificateService, (AlertService)new AlertServiceImpl());
    }

    public CertificateResource(IdentityService identityService, PersonalCertificateService personalCertificateService, AlertService alertService) {
        this.identityService = identityService;
        this.personalCertificateService = personalCertificateService;
        this.alertService = alertService;
    }

    @GET
    @Path(value="/check-expiration")
    @Produces(value={"application/json"})
    public Response checkCertificatesExpiration() throws InvalidParseOperationException {
        try {
            this.identityService.checkCertificates();
            this.personalCertificateService.checkCertificates();
        }
        catch (ParseException e) {
            return Response.serverError().build();
        }
        return Response.accepted().build();
    }
}

