/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.security.internal.rest.resource;

import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.security.internal.common.model.IdentityInsertModel;
import fr.gouv.vitam.security.internal.common.model.IdentityModel;
import fr.gouv.vitam.security.internal.rest.service.IdentityService;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.net.URI;
import java.security.cert.CertificateException;
import java.util.Optional;

@Path(value="/v1/api/identity")
@Tag(name="Security")
public class AdminIdentityResource {
    private final IdentityService identityService;

    public AdminIdentityResource(IdentityService identityService) {
        this.identityService = identityService;
    }

    @POST
    @Consumes(value={"application/json"})
    public Response createIdentity(IdentityInsertModel identityInsertModel, @Context UriInfo uri) throws InvalidParseOperationException, CertificateException {
        ParametersChecker.checkParameter((String)"Certificate cannot be null", (Object[])new Object[]{identityInsertModel.getCertificate()});
        Optional<IdentityModel> identity = this.identityService.findIdentity(identityInsertModel.getCertificate());
        if (identity.isPresent()) {
            return Response.status((Response.Status)Response.Status.CONFLICT).build();
        }
        this.identityService.createIdentity(identityInsertModel);
        return Response.created((URI)uri.getRequestUri().normalize()).build();
    }

    @PUT
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public IdentityModel linkContextToIdentity(IdentityInsertModel identityInsertModel, @Context UriInfo uri) throws InvalidParseOperationException, CertificateException {
        ParametersChecker.checkParameter((String)"ContextId cannot be null", (String[])new String[]{identityInsertModel.getContextId()});
        ParametersChecker.checkParameter((String)"Certificate cannot be null", (Object[])new Object[]{identityInsertModel.getCertificate()});
        return this.identityService.linkContextToIdentity(identityInsertModel).orElseThrow(NotFoundException::new);
    }
}

