/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.security.internal.rest.resource;

import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.security.internal.common.service.CRLService;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;

@Path(value="/v1/api/crl")
@Tag(name="Security")
public class AdminCRLResource {
    private final CRLService crlService;

    public AdminCRLResource(CRLService crlService) {
        this.crlService = crlService;
    }

    @POST
    @Consumes(value={"application/octet-stream"})
    public void checkIdentityWithCRL(byte[] crlCertificate) throws InvalidParseOperationException, CertificateException, CRLException {
        ParametersChecker.checkParameter((String)"CRL certificate cannot be null", (Object[])new Object[]{crlCertificate});
        this.crlService.checkIdentityWithCRL(crlCertificate);
    }
}

