/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.security.internal.rest;

import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.ServerIdentity;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.exception.VitamApplicationServerException;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.server.application.resources.VitamServiceRegistry;
import fr.gouv.vitam.common.serverv2.VitamStarter;
import fr.gouv.vitam.security.internal.rest.server.AdminIdentityApplication;
import fr.gouv.vitam.security.internal.rest.server.BusinessApplication;
import fr.gouv.vitam.security.internal.rest.server.InternalSecurityConfiguration;

public class IdentityMain {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(IdentityMain.class);
    private static final String CONF_FILE_NAME = "internal-security.conf";
    private static final String MODULE_NAME = ServerIdentity.getInstance().getRole();
    public static final String PARAMETER_JETTY_SERVER_PORT = "jetty.identity.port";
    private final VitamStarter vitamStarter;

    public IdentityMain(String configurationFile) {
        ParametersChecker.checkParameter((String)String.format("Config file %s is a mandatory argument. ", CONF_FILE_NAME), (String[])new String[]{configurationFile});
        this.vitamStarter = new VitamStarter(InternalSecurityConfiguration.class, configurationFile, BusinessApplication.class, AdminIdentityApplication.class);
    }

    public static void main(String[] args) {
        try {
            if (args == null || args.length == 0) {
                LOGGER.error(String.format("Config file %s is a mandatory argument. ", CONF_FILE_NAME));
                throw new IllegalArgumentException(String.format("Config file %s is a mandatory argument. ", CONF_FILE_NAME));
            }
            IdentityMain storageMain = new IdentityMain(args[0]);
            VitamServiceRegistry serviceRegistry = new VitamServiceRegistry();
            serviceRegistry.checkDependencies(VitamConfiguration.getRetryNumber().intValue(), (long)VitamConfiguration.getRetryDelay().intValue());
            storageMain.startAndJoin();
        }
        catch (Exception e) {
            LOGGER.error(String.format("%s application server can not start. ", MODULE_NAME) + e.getMessage(), (Throwable)e);
            System.exit(1);
        }
    }

    public void start() throws VitamApplicationServerException {
        this.vitamStarter.start();
    }

    public void startAndJoin() throws VitamApplicationServerException {
        this.vitamStarter.run();
    }

    public void stop() throws VitamApplicationServerException {
        this.vitamStarter.stop();
    }
}

