/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.ingest.external.client;

import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.external.client.AbstractMockClient;
import fr.gouv.vitam.common.external.client.ClientMockResultHelper;
import fr.gouv.vitam.common.external.client.IngestCollection;
import fr.gouv.vitam.common.model.LocalFile;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.stream.StreamUtils;
import fr.gouv.vitam.ingest.external.api.exception.IngestExternalException;
import fr.gouv.vitam.ingest.external.client.IngestExternalClient;
import fr.gouv.vitam.ingest.external.client.IngestRequestParameters;
import jakarta.ws.rs.core.Response;
import java.io.InputStream;

class IngestExternalClientMock
extends AbstractMockClient
implements IngestExternalClient {
    private static final String FAKE_X_REQUEST_ID = "aeaqaaaaaefex4j4aao2qalmjv7h24yaaaaq";
    public static final String ID = "identifier1";

    IngestExternalClientMock() {
    }

    @Override
    public RequestResponse<Void> ingest(VitamContext vitamContext, InputStream stream, String contextId, String action) throws IngestExternalException {
        if (stream == null) {
            throw new IngestExternalException("stream is null");
        }
        StreamUtils.closeSilently((InputStream)stream);
        RequestResponseOK r = new RequestResponseOK();
        r.setHttpCode(Response.Status.ACCEPTED.getStatusCode());
        r.addHeader("X-Request-Id", FAKE_X_REQUEST_ID);
        return r;
    }

    @Override
    public RequestResponse<Void> ingest(VitamContext vitamContext, InputStream stream, IngestRequestParameters ingestRequestParameters) throws IngestExternalException {
        return this.ingest(vitamContext, stream, ingestRequestParameters.getContextId(), ingestRequestParameters.getAction());
    }

    @Override
    public Response downloadObjectAsync(VitamContext vitamContext, String objectId, IngestCollection type) throws VitamClientException {
        return ClientMockResultHelper.getObjectStream();
    }

    @Override
    public RequestResponse<Void> ingestLocal(VitamContext vitamContext, LocalFile localFile, String contextId, String action) throws IngestExternalException {
        RequestResponseOK r = new RequestResponseOK();
        r.setHttpCode(Response.Status.ACCEPTED.getStatusCode());
        r.addHeader(FAKE_X_REQUEST_ID, "X-Request-Id");
        return r;
    }

    @Override
    public RequestResponse<Void> ingestLocal(VitamContext vitamContext, LocalFile localFile, IngestRequestParameters ingestRequestParameters) throws IngestExternalException {
        return this.ingestLocal(vitamContext, localFile, ingestRequestParameters.getContextId(), ingestRequestParameters.getAction());
    }
}

