/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.ingest.external.client;

import fr.gouv.vitam.common.PropertiesUtils;
import fr.gouv.vitam.common.client.VitamClientFactoryInterface;
import fr.gouv.vitam.common.client.configuration.ClientConfiguration;
import fr.gouv.vitam.common.external.client.VitamClientFactory;
import fr.gouv.vitam.common.external.client.configuration.SecureClientConfiguration;
import fr.gouv.vitam.common.external.client.configuration.SecureClientConfigurationImpl;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.ingest.external.client.IngestExternalClient;
import fr.gouv.vitam.ingest.external.client.IngestExternalClientMock;
import fr.gouv.vitam.ingest.external.client.IngestExternalClientRest;
import java.io.File;
import java.io.IOException;

public class IngestExternalClientFactory
extends VitamClientFactory<IngestExternalClient> {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(IngestExternalClientFactory.class);
    private static final IngestExternalClientFactory INGEST_EXTERNAL_CLIENT_FACTORY = new IngestExternalClientFactory();
    private static final String CONFIGURATION_FILENAME = "ingest-external-client.conf";
    private static final String RESOURCE_PATH = "/ingest-external/v1";

    private IngestExternalClientFactory() {
        super((ClientConfiguration)IngestExternalClientFactory.changeConfigurationFile(CONFIGURATION_FILENAME), RESOURCE_PATH);
    }

    static SecureClientConfiguration changeConfigurationFile(String configurationPath) {
        SecureClientConfiguration configuration = null;
        try {
            configuration = (SecureClientConfiguration)PropertiesUtils.readYaml((File)PropertiesUtils.findFile((String)configurationPath), SecureClientConfigurationImpl.class);
        }
        catch (IOException fnf) {
            LOGGER.debug("Error when retrieving configuration file {}, using mock", (Object)CONFIGURATION_FILENAME, (Object)fnf);
        }
        if (configuration == null) {
            LOGGER.error("Error when retrieving configuration file {}, using mock", (Object)CONFIGURATION_FILENAME);
        }
        return configuration;
    }

    public IngestExternalClient getClient() {
        return switch (this.getVitamClientType()) {
            case VitamClientFactoryInterface.VitamClientType.MOCK -> new IngestExternalClientMock();
            case VitamClientFactoryInterface.VitamClientType.PRODUCTION -> new IngestExternalClientRest(this);
            default -> throw new IllegalArgumentException("Ingest External client type unknown");
        };
    }

    public static IngestExternalClientFactory getInstance() {
        return INGEST_EXTERNAL_CLIENT_FACTORY;
    }

    public static void changeMode(SecureClientConfiguration configuration) {
        IngestExternalClientFactory.getInstance().initialisation((ClientConfiguration)configuration, IngestExternalClientFactory.getInstance().getResourcePath());
    }

    public static void changeMode(String configurationFile) {
        SecureClientConfiguration configuration = IngestExternalClientFactory.changeConfigurationFile(configurationFile);
        IngestExternalClientFactory.getInstance().initialisation((ClientConfiguration)configuration, IngestExternalClientFactory.getInstance().getResourcePath());
    }
}

