/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.logbook.common.parameters;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.base.Strings;
import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.i18n.VitamLogbookMessages;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.logbook.common.parameters.LogbookOperationParameters;
import fr.gouv.vitam.logbook.common.parameters.LogbookParameterName;
import fr.gouv.vitam.logbook.common.parameters.LogbookParameters;
import fr.gouv.vitam.logbook.common.parameters.LogbookParametersFactory;
import fr.gouv.vitam.logbook.common.parameters.LogbookTypeProcess;
import java.time.LocalDateTime;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

abstract class AbstractParameters
implements LogbookParameters {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(AbstractParameters.class);
    @JsonIgnore
    private final Map<LogbookParameterName, String> mapParameters = new TreeMap<LogbookParameterName, String>();
    @JsonIgnore
    protected Set<LogbookParameterName> mandatoryParameters;

    AbstractParameters(Set<LogbookParameterName> mandatory) {
        this.mandatoryParameters = mandatory;
    }

    @JsonCreator
    protected AbstractParameters(Map<String, String> map) {
        this.mandatoryParameters = LogbookParametersFactory.getDefaultOperationMandatory();
        this.setMap(map);
    }

    @Override
    @JsonIgnore
    public Set<LogbookParameterName> getMandatoriesParameters() {
        return this.mandatoryParameters;
    }

    @Override
    @JsonIgnore
    public LocalDateTime getEventDateTime() {
        String date = this.mapParameters.get((Object)LogbookParameterName.eventDateTime);
        if (!Strings.isNullOrEmpty((String)date)) {
            return LocalDateUtil.parseMongoFormattedDate(date);
        }
        return null;
    }

    @Override
    @JsonIgnore
    public LogbookParameters setStatus(StatusCode outcome) {
        this.mapParameters.put(LogbookParameterName.outcome, outcome.name());
        return this;
    }

    @Override
    @JsonIgnore
    public StatusCode getStatus() {
        String status = this.mapParameters.get((Object)LogbookParameterName.outcome);
        if (status != null) {
            return StatusCode.valueOf(status);
        }
        return null;
    }

    @Override
    public LogbookParameters setFinalStatus(String handlerId, String subTaskId, StatusCode code, String additionalMessage, String ... params) {
        if (this instanceof LogbookOperationParameters) {
            this.setFinalStatusOp(handlerId, subTaskId, code, additionalMessage, params);
        } else {
            this.setFinalStatusLfc(handlerId, subTaskId, code, additionalMessage, params);
        }
        return this;
    }

    @Override
    public LogbookParameters setBeginningLog(String handlerId, String subTaskId, String additionnalMessage, String ... params) {
        if (this instanceof LogbookOperationParameters) {
            this.setFinalStatusOp(handlerId, subTaskId, StatusCode.OK, additionnalMessage, params);
        } else {
            this.setFinalStatusLfc(handlerId, subTaskId, StatusCode.OK, additionnalMessage, params);
        }
        return this;
    }

    private LogbookParameters setFinalStatusLfc(String handlerId, String subTaskId, StatusCode code, String additionnalMessage, String ... params) {
        Object detail;
        if (subTaskId != null) {
            this.putParameterValue(LogbookParameterName.eventType, VitamLogbookMessages.getSubTaskEventTypeLfc(handlerId, subTaskId));
        } else {
            this.putParameterValue(LogbookParameterName.eventType, VitamLogbookMessages.getEventTypeLfc(handlerId));
        }
        this.putParameterValue(LogbookParameterName.outcome, code.name());
        if (subTaskId != null) {
            this.putParameterValue(LogbookParameterName.outcomeDetail, VitamLogbookMessages.getOutcomeDetailLfc(handlerId, subTaskId, code));
        } else {
            this.putParameterValue(LogbookParameterName.outcomeDetail, VitamLogbookMessages.getOutcomeDetailLfc(handlerId, code));
        }
        if (subTaskId != null) {
            detail = params != null && params.length > 0 ? VitamLogbookMessages.getCodeLfc(handlerId, subTaskId, code, (Object[])params) : VitamLogbookMessages.getCodeLfc(handlerId, subTaskId, code);
            if (additionnalMessage != null) {
                detail = (String)detail + additionnalMessage;
            }
        } else {
            detail = params != null && params.length > 0 ? VitamLogbookMessages.getCodeLfc(handlerId, code, params) : VitamLogbookMessages.getCodeLfc(handlerId, code);
            if (additionnalMessage != null) {
                detail = (String)detail + additionnalMessage;
            }
        }
        this.putParameterValue(LogbookParameterName.outcomeDetailMessage, (String)detail);
        return this;
    }

    private LogbookParameters setFinalStatusOp(String handlerId, String subTaskId, StatusCode code, String additionnalMessage, String ... params) {
        Object detail;
        if (subTaskId != null) {
            this.putParameterValue(LogbookParameterName.eventType, VitamLogbookMessages.getSubTaskEventTypeOp(handlerId, subTaskId));
        } else {
            this.putParameterValue(LogbookParameterName.eventType, handlerId);
        }
        this.putParameterValue(LogbookParameterName.outcome, code.name());
        if (subTaskId != null) {
            this.putParameterValue(LogbookParameterName.outcomeDetail, VitamLogbookMessages.getOutcomeDetail(handlerId, subTaskId, code));
        } else {
            this.putParameterValue(LogbookParameterName.outcomeDetail, VitamLogbookMessages.getOutcomeDetail(handlerId, code));
        }
        if (subTaskId != null) {
            detail = params != null && params.length > 0 ? VitamLogbookMessages.getCodeOp(handlerId, subTaskId, code, (Object[])params) : VitamLogbookMessages.getCodeOp(handlerId, subTaskId, code);
            if (additionnalMessage != null) {
                detail = (String)detail + additionnalMessage;
            }
        } else {
            detail = params != null && params.length > 0 ? VitamLogbookMessages.getCodeOp(handlerId, code, params) : VitamLogbookMessages.getCodeOp(handlerId, code);
            if (additionnalMessage != null) {
                detail = (String)detail + additionnalMessage;
            }
        }
        this.putParameterValue(LogbookParameterName.outcomeDetailMessage, (String)detail);
        return this;
    }

    @Override
    @JsonIgnore
    public LogbookParameters setTypeProcess(LogbookTypeProcess process) {
        this.mapParameters.put(LogbookParameterName.eventTypeProcess, process.name());
        return this;
    }

    @Override
    @JsonIgnore
    public LogbookTypeProcess getTypeProcess() {
        String process = this.mapParameters.get((Object)LogbookParameterName.eventTypeProcess);
        if (process != null) {
            return LogbookTypeProcess.valueOf(process);
        }
        return null;
    }

    @Override
    @JsonIgnore
    public LogbookParameters putParameterValue(LogbookParameterName parameterName, String parameterValue) {
        AbstractParameters.checkNullOrEmptyParameter(parameterName, parameterValue, this.getMandatoriesParameters());
        this.mapParameters.put(parameterName, parameterValue);
        return this;
    }

    @Override
    @JsonIgnore
    public String getParameterValue(LogbookParameterName parameterName) {
        ParametersChecker.checkParameter("Parameter cannot be null or empty", new Object[]{parameterName});
        return this.mapParameters.get((Object)parameterName);
    }

    @Override
    public LogbookParameters setMap(Map<String, String> map) {
        for (Map.Entry<String, String> item : map.entrySet()) {
            LogbookParameterName lpname = LogbookParameterName.valueOf(item.getKey());
            this.mapParameters.put(lpname, item.getValue());
        }
        return this;
    }

    @Override
    public LogbookParameters setFromParameters(LogbookParameters parameters) {
        for (LogbookParameterName item : LogbookParameterName.values()) {
            this.mapParameters.put(item, parameters.getParameterValue(item));
        }
        return this;
    }

    @Override
    @JsonIgnore
    public Map<LogbookParameterName, String> getMapParameters() {
        return this.mapParameters;
    }

    public String toString() {
        try {
            return JsonHandler.writeAsString(this.mapParameters);
        }
        catch (InvalidParseOperationException e) {
            LOGGER.error("Cannot convert to String", e);
            return this.mapParameters.toString();
        }
    }

    private static <T extends Enum<T>> void checkNullOrEmptyParameter(T key, String value, Set<T> mandatories) {
        ParametersChecker.checkParameter("Key parameter", key);
        if (mandatories.contains(key)) {
            ParametersChecker.checkParameter(key.name(), value);
        }
    }
}

