/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.stream;

import com.google.common.base.Charsets;
import com.google.common.io.CharStreams;
import fr.gouv.vitam.common.CharsetUtils;
import fr.gouv.vitam.common.logging.SysErrLogger;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import jakarta.ws.rs.core.Response;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.channels.Channel;
import java.util.Arrays;

public class StreamUtils {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(StreamUtils.class);
    private static final int BUFFER_SIZE = 8192;

    private StreamUtils() {
    }

    /*
     * Exception decompiling
     */
    public static final long copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static final long closeSilently(InputStream inputStream) {
        return StreamUtils.consumeInputStream(inputStream);
    }

    public static final InputStream getRemainingReadOnCloseInputStream(InputStream inputStream) {
        return new RemainingReadOnCloseInputStream(inputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final long consumeInputStream(InputStream inputStream) {
        long read = 0L;
        if (inputStream == null) {
            return read;
        }
        try {
            int len;
            if (inputStream.read() == -1) {
                long l = read;
                return l;
            }
            ++read;
            byte[] buffer = new byte[8192];
            while ((len = inputStream.read(buffer)) >= 0) {
                read += (long)len;
            }
        }
        catch (IOException e) {
            LOGGER.debug(e);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                LOGGER.debug(e);
            }
        }
        return read;
    }

    public static final String toString(InputStream inputStream) throws IOException {
        try {
            String string;
            try (InputStreamReader isr = new InputStreamReader(inputStream, Charsets.UTF_8);){
                string = CharStreams.toString((Readable)isr);
            }
            return string;
        }
        finally {
            StreamUtils.closeSilently(inputStream);
        }
    }

    public static InputStream toInputStream(String source) {
        return new ByteArrayInputStream(source.getBytes(CharsetUtils.UTF8));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean contentEquals(InputStream is1, InputStream is2) {
        byte[] buffer = new byte[8192];
        byte[] buffer2 = new byte[8192];
        Arrays.fill(buffer, (byte)0);
        Arrays.fill(buffer2, (byte)0);
        boolean equals = true;
        try {
            int n1 = 0;
            int n2 = 0;
            do {
                if ((n1 = is1.read(buffer)) != (n2 = is2.read(buffer2))) {
                    boolean bl = false;
                    return bl;
                }
                if (n1 == -1) {
                    boolean bl = true;
                    return bl;
                }
                if (Arrays.equals(buffer, buffer2)) continue;
                boolean bl = false;
                return bl;
            } while (n1 != -1);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            StreamUtils.consumeInputStream(is1);
            StreamUtils.consumeInputStream(is2);
        }
    }

    public static void consumeAnyEntityAndClose(Response response) {
        try {
            Object object;
            if (response != null && response.hasEntity() && (object = response.getEntity()) instanceof InputStream) {
                StreamUtils.closeSilently((InputStream)object);
            }
        }
        catch (Exception e) {
            SysErrLogger.FAKE_LOGGER.ignoreLog(e);
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (Exception e) {
                    SysErrLogger.FAKE_LOGGER.ignoreLog(e);
                }
            }
        }
    }

    public static void closeSilently(Channel channel) {
        try {
            channel.close();
        }
        catch (Exception ex2) {
            SysErrLogger.FAKE_LOGGER.ignoreLog(ex2);
        }
    }

    private static class RemainingReadOnCloseInputStream
    extends InputStream {
        private final InputStream source;

        private RemainingReadOnCloseInputStream(InputStream inputStream) {
            this.source = inputStream;
        }

        @Override
        public int available() throws IOException {
            return this.source.available();
        }

        @Override
        public void close() {
            StreamUtils.consumeInputStream(this.source);
        }

        @Override
        public synchronized void mark(int readlimit) {
            this.source.mark(readlimit);
        }

        @Override
        public boolean markSupported() {
            return this.source.markSupported();
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return this.source.read(b, off, len);
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.source.read(b);
        }

        @Override
        public synchronized void reset() throws IOException {
            this.source.reset();
        }

        @Override
        public long skip(long n) throws IOException {
            return this.source.skip(n);
        }

        @Override
        public int read() throws IOException {
            return this.source.read();
        }
    }
}

