/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.retryable;

import fr.gouv.vitam.common.retryable.DelegateRetry;
import fr.gouv.vitam.common.retryable.DelegateRetryVoid;
import fr.gouv.vitam.common.retryable.Retryable;
import fr.gouv.vitam.common.retryable.RetryableParameters;
import java.security.SecureRandom;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Predicate;

public class RetryableOnException<T, E extends Exception>
implements Retryable<T, E> {
    private static final Consumer<Exception> NOOP = e -> {};
    private static final Predicate<Exception> ALL = e -> true;
    private final AtomicInteger counter = new AtomicInteger();
    private final SecureRandom randomSleep = new SecureRandom();
    private final Predicate<Exception> retryOn;
    private final Consumer<Exception> onException;
    private RetryableParameters param;

    public RetryableOnException(RetryableParameters param, Predicate<Exception> retryOn, Consumer<Exception> onException) {
        this.param = Objects.requireNonNull(param);
        this.retryOn = Objects.requireNonNull(retryOn);
        this.onException = Objects.requireNonNull(onException);
    }

    public RetryableOnException(RetryableParameters param, Predicate<Exception> retryOn) {
        this(param, retryOn, NOOP);
    }

    public RetryableOnException(RetryableParameters param) {
        this(param, ALL, NOOP);
    }

    @Override
    public T exec(DelegateRetry<T, E> delegate) throws E {
        while (this.counter.getAndIncrement() < this.param.getNbRetry()) {
            try {
                return delegate.call();
            }
            catch (Exception e) {
                boolean attemptExceedNbRetry = this.counter.get() >= this.param.getNbRetry();
                boolean shouldStopRetry = this.retryOn.negate().test(e);
                if (attemptExceedNbRetry || shouldStopRetry) {
                    throw e;
                }
                this.sleep(this.counter.get(), delegate.toString(), this.param, this.randomSleep, this.onException, e);
            }
        }
        throw new IllegalStateException("Unreachable statement.");
    }

    @Override
    public void execute(DelegateRetryVoid<E> delegate) throws E {
        while (this.counter.getAndIncrement() < this.param.getNbRetry()) {
            try {
                delegate.call();
                return;
            }
            catch (Exception e) {
                boolean attemptExceedNbRetry = this.counter.get() >= this.param.getNbRetry();
                boolean shouldStopRetry = this.retryOn.negate().test(e);
                if (attemptExceedNbRetry || shouldStopRetry) {
                    throw e;
                }
                this.sleep(this.counter.get(), delegate.toString(), this.param, this.randomSleep, this.onException, e);
            }
        }
        throw new IllegalStateException("Unreachable statement.");
    }
}

