/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.retryable;

import fr.gouv.vitam.common.exception.VitamRuntimeException;
import fr.gouv.vitam.common.retryable.DelegateRetry;
import fr.gouv.vitam.common.retryable.DelegateRetryVoid;
import fr.gouv.vitam.common.retryable.RetryableParameters;
import java.security.SecureRandom;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.commons.lang3.exception.ExceptionUtils;

public interface Retryable<T, E extends Exception> {
    public T exec(DelegateRetry<T, E> var1) throws E;

    public void execute(DelegateRetryVoid<E> var1) throws E;

    default public void sleep(int attempt, String name, RetryableParameters param, SecureRandom randomSleep, Consumer<T> onResult, T type) {
        onResult.accept(type);
        String resultString = type.toString();
        this.doSleep(attempt, name, param, randomSleep, resultString);
    }

    default public void sleep(int attempt, String name, RetryableParameters param, SecureRandom randomSleep, Consumer<Exception> onException, Exception exception) {
        onException.accept(exception);
        String stackTrace = ExceptionUtils.getStackTrace((Throwable)exception);
        this.doSleep(attempt, name, param, randomSleep, stackTrace);
    }

    default public void doSleep(int attempt, String name, RetryableParameters param, SecureRandom randomSleep, String toPrint) {
        try {
            int randomRangeSleep = param.getRandomRangeSleep() == 0 ? 0 : randomSleep.nextInt(param.getRandomRangeSleep());
            long sleepTime = attempt == 1 ? (long)(randomRangeSleep + param.getFirstAttemptWaitingTime()) : (long)(randomRangeSleep + param.getWaitingTime());
            TimeUnit timeUnit = param.getTimeUnit();
            param.getLog().accept(String.format("Retryable='%s' - Will retry, attempt '%d' in '%d' %s. %s", name, attempt, sleepTime, timeUnit.name(), toPrint));
            timeUnit.sleep(sleepTime);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new VitamRuntimeException(String.format("Error while trying to wait in retryable: '%s'.", name), e);
        }
    }
}

