/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.model.validations;

import com.fasterxml.jackson.databind.node.ObjectNode;
import fr.gouv.vitam.common.guid.GUIDFactory;
import fr.gouv.vitam.common.i18n.VitamLogbookMessages;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.model.validations.ValidationError;
import fr.gouv.vitam.logbook.common.parameters.LogbookTypeProcess;

public final class ValidationErrorHelper {
    private ValidationErrorHelper() {
    }

    public static ValidationError createMetadataValidationError(LogbookTypeProcess eventTypeProcess, String stepOrHandler, ObjectNode evDetData) {
        return ValidationErrorHelper.getValidationError(eventTypeProcess, null, evDetData, VitamLogbookMessages.getOutcomeDetailLfc(stepOrHandler, StatusCode.KO), VitamLogbookMessages.getCodeLfc(stepOrHandler, StatusCode.KO));
    }

    public static ValidationError createMetadataValidationError(LogbookTypeProcess eventTypeProcess, String stepOrHandler, String transaction, ObjectNode evDetData) {
        return ValidationErrorHelper.getValidationError(eventTypeProcess, null, evDetData, VitamLogbookMessages.getOutcomeDetailLfc(stepOrHandler, transaction, StatusCode.KO), VitamLogbookMessages.getCodeLfc(stepOrHandler, transaction, StatusCode.KO));
    }

    public static ValidationError createObjectValidationError(LogbookTypeProcess eventTypeProcess, String stepOrHandler, String transaction, String obId, ObjectNode evDetData) {
        return ValidationErrorHelper.getValidationError(eventTypeProcess, obId, evDetData, VitamLogbookMessages.getOutcomeDetailLfc(stepOrHandler, transaction, StatusCode.KO), VitamLogbookMessages.getCodeLfc(stepOrHandler, transaction, StatusCode.KO));
    }

    public static ValidationError createObjectValidationError(LogbookTypeProcess eventTypeProcess, String stepOrHandler, String transaction, String detailedOutcome, String obId, ObjectNode evDetData) {
        return ValidationErrorHelper.getValidationError(eventTypeProcess, obId, evDetData, VitamLogbookMessages.getOutcomeDetailLfc(stepOrHandler, transaction, detailedOutcome, StatusCode.KO), VitamLogbookMessages.getCodeLfc(stepOrHandler, transaction, detailedOutcome, StatusCode.KO, new Object[0]));
    }

    private static ValidationError getValidationError(LogbookTypeProcess eventTypeProcess, String obId, ObjectNode evDetData, String outDetail, String outMessg) {
        return new ValidationError().setEvId(GUIDFactory.newGUID().toString()).setEvTypeProc(eventTypeProcess.name()).setEvDetData(evDetData == null ? null : JsonHandler.unprettyPrint(evDetData)).setObId(obId).setOutDetail(outDetail).setOutMessg(outMessg);
    }
}

