/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.model.storage;

import fr.gouv.vitam.common.collection.CloseableIterator;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.model.storage.ObjectEntry;
import fr.gouv.vitam.common.stream.StreamUtils;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.commons.collections4.iterators.PeekingIterator;

public class ObjectEntryReader
implements CloseableIterator<ObjectEntry> {
    private static final String EMPTY_ENTRY = "{}";
    private final InputStream inputStream;
    private final PeekingIterator<String> iterator;

    public ObjectEntryReader(InputStream inputStream) {
        this.inputStream = inputStream;
        this.iterator = new PeekingIterator(new BufferedReader(new InputStreamReader(inputStream)).lines().iterator());
    }

    @Override
    public boolean hasNext() {
        if (!this.iterator.hasNext()) {
            throw new RuntimeException("Premature EOF");
        }
        String nextEntry = (String)this.iterator.peek();
        return !EMPTY_ENTRY.equals(nextEntry);
    }

    @Override
    public ObjectEntry next() {
        if (!this.hasNext()) {
            throw new IllegalStateException("No more entries to read");
        }
        try {
            return JsonHandler.getFromString((String)this.iterator.next(), ObjectEntry.class);
        }
        catch (InvalidParseOperationException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() {
        StreamUtils.closeSilently(this.inputStream);
    }
}

